/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.validator;

import edu.kit.datamanager.annotations.LocalFolderURL;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFolderValidator
implements ConstraintValidator<LocalFolderURL, URL> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalFolderValidator.class);

    public boolean isValid(URL value, ConstraintValidatorContext context) {
        boolean folderValid = false;
        if (value == null) {
            LOGGER.error("Provided value is null.");
            return folderValid;
        }
        try {
            LOGGER.trace("Successfully validated folder URL {}. Checking local path.", (Object)value.toURI().toString());
            Path basePath = Paths.get(value.toURI());
            if (!Files.exists(basePath, new LinkOption[0])) {
                LOGGER.trace("Folder at {} does not exist. Try creating it.", (Object)basePath);
                Path basePathCreated = Files.createDirectories(basePath, new FileAttribute[0]);
                LOGGER.info("Successfully created folder from URL {} at {}.", (Object)value, (Object)basePathCreated);
                folderValid = true;
            } else if (!Files.isWritable(basePath)) {
                LOGGER.error("Folder at {} exists, but is not writable.", (Object)basePath);
            } else {
                LOGGER.trace("Folder at {} exists and is writable.", (Object)basePath);
                folderValid = true;
            }
        }
        catch (URISyntaxException ex) {
            LOGGER.error("Failed to validate folder property with value " + value + ".", (Throwable)ex);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to create folder for URL " + value + " at local filesystem.", (Throwable)ex);
        }
        return folderValid;
    }
}

