/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.validator;

import edu.kit.datamanager.annotations.SearchIndex;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchIndexValidator
implements ConstraintValidator<SearchIndex, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchIndexValidator.class);
    public static final String SPECIAL_CHARACTERS = "  \"\\<|>/?{}\\[\\]`A-Z";

    public boolean isValid(String value, ConstraintValidatorContext context) {
        boolean validElasticsearchIndex = false;
        if (value == null) {
            LOGGER.error("Provided value is null.");
            return validElasticsearchIndex;
        }
        Pattern p = Pattern.compile("[  \"\\<|>/?{}\\[\\]`A-Z]");
        Matcher m = p.matcher(value);
        if (m.find()) {
            LOGGER.error("Index must not contain one of the following characters: '{}'!", (Object)SPECIAL_CHARACTERS);
        } else {
            validElasticsearchIndex = true;
        }
        return validElasticsearchIndex;
    }
}

