/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.ipc.impl;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.stanford.protege.webprotege.common.Event;
import edu.stanford.protege.webprotege.common.ProjectEvent;
import edu.stanford.protege.webprotege.ipc.EventDispatcher;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Qualifier;

public class RabbitMQEventDispatcher
implements EventDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(RabbitMQEventDispatcher.class);
    private final ObjectMapper objectMapper;
    private final RabbitTemplate eventRabbitTemplate;

    public RabbitMQEventDispatcher(ObjectMapper objectMapper, @Qualifier(value="eventRabbitTemplate") RabbitTemplate eventRabbitTemplate) {
        this.objectMapper = objectMapper;
        this.eventRabbitTemplate = eventRabbitTemplate;
    }

    @Override
    public void dispatchEvent(Event event) {
        try {
            byte[] value = this.objectMapper.writeValueAsBytes((Object)event);
            Message message = MessageBuilder.withBody((byte[])value).build();
            this.getJsonTypeName(event).ifPresent(typeName -> message.getMessageProperties().getHeaders().put("webprotege_eventType", typeName));
            message.getMessageProperties().getHeaders().put("webprotege_channel", event.getChannel());
            if (event instanceof ProjectEvent) {
                String projectId = ((ProjectEvent)event).projectId().value();
                message.getMessageProperties().getHeaders().put("webprotege_projectId", projectId);
            }
            this.eventRabbitTemplate.convertAndSend("webprotege-event-exchange", "", (Object)message);
            logger.info("Sent event message!");
        }
        catch (JsonProcessingException | AmqpException e) {
            logger.info("Could not serialize event: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private Optional<String> getJsonTypeName(Event event) {
        JsonTypeName annotation = event.getClass().getAnnotation(JsonTypeName.class);
        return Optional.ofNullable(annotation).map(JsonTypeName::value);
    }
}

