/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.ipc.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.rabbitmq.client.Channel;
import edu.stanford.protege.webprotege.authorization.GetAuthorizationStatusRequest;
import edu.stanford.protege.webprotege.authorization.GetAuthorizationStatusResponse;
import edu.stanford.protege.webprotege.common.Request;
import edu.stanford.protege.webprotege.common.Response;
import edu.stanford.protege.webprotege.ipc.CommandExecutor;
import edu.stanford.protege.webprotege.ipc.CommandHandler;
import edu.stanford.protege.webprotege.ipc.impl.RabbitMqCommandHandlerWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.AsyncRabbitTemplate;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="webprotege.rabbitmq", name={"commands-subscribe"}, havingValue="true", matchIfMissing=true)
public class RabbitMqConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(RabbitMqConfiguration.class);
    @Value(value="${webprotege.rabbitmq.responsequeue}")
    public String commandsResponseQueue;
    @Value(value="${webprotege.rabbitmq.requestqueue}")
    public String commandsQueue;
    @Value(value="${webprotege.rabbitmq.timeout}")
    public Long rabbitMqTimeout;
    public static final String COMMANDS_EXCHANGE = "webprotege-exchange";
    @Autowired
    private ConnectionFactory connectionFactory;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired(required=false)
    private List<CommandHandler<? extends Request, ? extends Response>> handlers = new ArrayList<CommandHandler<? extends Request, ? extends Response>>();
    @Autowired
    private CommandExecutor<GetAuthorizationStatusRequest, GetAuthorizationStatusResponse> authorizationStatusExecutor;

    @Bean
    @ConditionalOnProperty(prefix="webprotege.rabbitmq", name={"commands-subscribe"}, havingValue="true", matchIfMissing=true)
    Queue msgQueue() {
        return new Queue(this.getCommandQueue(), true);
    }

    @Bean
    @ConditionalOnProperty(prefix="webprotege.rabbitmq", name={"commands-subscribe"}, havingValue="true", matchIfMissing=true)
    Queue replyQueue() {
        return new Queue(this.getCommandResponseQueue(), true);
    }

    @Bean
    @ConditionalOnProperty(prefix="webprotege.rabbitmq", name={"commands-subscribe"}, havingValue="true", matchIfMissing=true)
    DirectExchange exchange() {
        return new DirectExchange(COMMANDS_EXCHANGE, true, false);
    }

    @Bean(name={"rabbitTemplate"})
    @ConditionalOnProperty(prefix="webprotege.rabbitmq", name={"commands-subscribe"}, havingValue="true", matchIfMissing=true)
    public RabbitTemplate rabbitTemplate(ConnectionFactory connectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(connectionFactory);
        rabbitTemplate.setReplyTimeout(this.rabbitMqTimeout.longValue());
        rabbitTemplate.setExchange(COMMANDS_EXCHANGE);
        return rabbitTemplate;
    }

    @Bean(name={"asyncRabbitTemplate"})
    @ConditionalOnProperty(prefix="webprotege.rabbitmq", name={"commands-subscribe"}, havingValue="true", matchIfMissing=true)
    public AsyncRabbitTemplate asyncRabbitTemplate(@Qualifier(value="rabbitTemplate") RabbitTemplate rabbitTemplate, SimpleMessageListenerContainer replyListenerContainer) {
        AsyncRabbitTemplate asyncRabbitTemplate = new AsyncRabbitTemplate(rabbitTemplate, (AbstractMessageListenerContainer)replyListenerContainer, this.getCommandResponseQueue());
        asyncRabbitTemplate.setReceiveTimeout(this.rabbitMqTimeout.longValue());
        return asyncRabbitTemplate;
    }

    @Bean
    @ConditionalOnProperty(prefix="webprotege.rabbitmq", name={"commands-subscribe"}, havingValue="true", matchIfMissing=true)
    public SimpleMessageListenerContainer replyListenerContainer(ConnectionFactory connectionFactory, Queue replyQueue) {
        SimpleMessageListenerContainer container = new SimpleMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        container.setQueues(new Queue[]{replyQueue});
        return container;
    }

    @Bean
    @ConditionalOnProperty(prefix="webprotege.rabbitmq", name={"commands-subscribe"}, havingValue="true", matchIfMissing=true)
    public RabbitMqCommandHandlerWrapper rabbitMqCommandHandlerWrapper() {
        return new RabbitMqCommandHandlerWrapper(this.handlers, this.objectMapper, this.authorizationStatusExecutor);
    }

    @Bean
    @ConditionalOnProperty(prefix="webprotege.rabbitmq", name={"commands-subscribe"}, havingValue="true", matchIfMissing=true)
    public SimpleMessageListenerContainer messageListenerContainers() {
        SimpleMessageListenerContainer container = new SimpleMessageListenerContainer();
        container.setQueueNames(new String[]{this.getCommandQueue()});
        container.setConnectionFactory(this.connectionFactory);
        container.setMessageListener((MessageListener)this.rabbitMqCommandHandlerWrapper());
        return container;
    }

    @PostConstruct
    @ConditionalOnProperty(prefix="webprotege.rabbitmq", name={"commands-subscribe"}, havingValue="true", matchIfMissing=true)
    public void createBindings() {
        try (Connection connection = this.connectionFactory.createConnection();
             Channel channel = connection.createChannel(true);){
            channel.exchangeDeclare(COMMANDS_EXCHANGE, "direct", true);
            channel.queueDeclare(this.getCommandQueue(), true, false, false, null);
            channel.queueDeclare(this.getCommandResponseQueue(), true, false, false, null);
            channel.basicQos(1);
            for (CommandHandler<? extends Request, ? extends Response> handler : this.handlers) {
                logger.info("Declaring binding queue {} to exchange {} with key {}", new Object[]{this.getCommandQueue(), COMMANDS_EXCHANGE, handler.getChannelName()});
                channel.queueBind(this.getCommandQueue(), COMMANDS_EXCHANGE, handler.getChannelName());
            }
            channel.queueBind(this.getCommandResponseQueue(), COMMANDS_EXCHANGE, this.getCommandResponseQueue());
        }
        catch (IOException | TimeoutException e) {
            logger.error("Error initialize bindings", (Throwable)e);
            throw new RuntimeException("Error initialize bindings", e);
        }
    }

    private String getCommandQueue() {
        return this.commandsQueue;
    }

    private String getCommandResponseQueue() {
        return this.commandsResponseQueue;
    }
}

