/*
 * Decompiled with CFR 0.152.
 */
package edu.teco.explorer;

import edu.teco.explorer.NetworkCommunicator;
import edu.teco.explorer.Pair;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class IncrementalRecorder {
    private final String INITDATASETINCREMENT = "/api/deviceapi/initDatasetIncrement";
    private final String ADDDATASETINCREMENT = "/api/deviceapi/addDatasetIncrement";
    private final String ADDDATASETINCREMENTBATCH = "/api/deviceapi/addDatasetIncrementBatch";
    private final Object sync = new Object();
    private boolean useDeviceTime;
    private String baseUrl;
    private String projectKey;
    private String datasetKey;
    private int counter;
    private NetworkCommunicator communicator;
    private ExecutorService executorService;
    private HashMap<String, List<Pair<Long, String>>> dataStore;

    protected IncrementalRecorder(String baseUrl, String projectKey, String datasetName, boolean useDeviceTime) throws Exception {
        this.useDeviceTime = useDeviceTime;
        this.baseUrl = baseUrl;
        this.counter = 0;
        this.projectKey = projectKey;
        this.dataStore = new HashMap();
        this.communicator = new NetworkCommunicator(this.baseUrl + "/api/deviceapi/addDatasetIncrementBatch");
        this.datasetKey = this.getDatasetKey(baseUrl, projectKey, datasetName);
        if (this.datasetKey == null) {
            throw new Exception("Could not generate incremental dataset");
        }
        this.executorService = Executors.newCachedThreadPool();
    }

    private String getDatasetKey(String baseUrl, String projectKey, String name) {
        JSONObject req = new JSONObject();
        try {
            req.put("deviceApiKey", (Object)projectKey);
            req.put("name", (Object)name);
            JSONObject ret = new NetworkCommunicator(baseUrl + "/api/deviceapi/initDatasetIncrement").sendPost(req);
            if (ret.getInt("STATUS") != 200) {
                return null;
            }
            return ret.getJSONObject("MESSAGE").getString("datasetKey");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uploadDataPoint(String sensorName, double datapoint, long time) {
        Object object = this.sync;
        synchronized (object) {
            if (!this.dataStore.containsKey(sensorName)) {
                this.dataStore.put(sensorName, new LinkedList());
            }
            if (this.useDeviceTime) {
                time = new Date().getTime();
            }
            this.dataStore.get(sensorName).add(new Pair<Long, Double>(time, datapoint));
            ++this.counter;
            if (this.counter > 1000) {
                HashMap<String, List<Pair<Long, String>>> tmpMap = this.dataStore;
                this.dataStore = new HashMap();
                this.upload(tmpMap);
                this.counter = 0;
            }
        }
    }

    protected void upload(Map<String, List<Pair<Long, String>>> tmpMap) {
        Runnable runnable = () -> {
            Set keySet = tmpMap.keySet();
            JSONObject req = new JSONObject();
            req.put("datasetKey", (Object)this.datasetKey);
            JSONArray data = new JSONArray();
            for (String sensorname : keySet) {
                JSONObject sensor = new JSONObject();
                sensor.put("sensorname", (Object)sensorname);
                JSONArray timeSeriesData = new JSONArray();
                long start = Long.MAX_VALUE;
                long end = Long.MIN_VALUE;
                for (Pair sensorData : (List)tmpMap.get(sensorname)) {
                    if ((Long)sensorData.getFirst() < start) {
                        start = (Long)sensorData.getFirst();
                    }
                    if ((Long)sensorData.getFirst() > end) {
                        end = (Long)sensorData.getFirst();
                    }
                    JSONObject datapoint = new JSONObject();
                    datapoint.put("timestamp", sensorData.getFirst());
                    datapoint.put("datapoint", sensorData.getSecond());
                    timeSeriesData.put((Object)datapoint);
                }
                sensor.put("timeSeriesData", (Object)timeSeriesData);
                sensor.put("start", start);
                sensor.put("end", end);
                data.put((Object)sensor);
            }
            req.put("data", (Object)data);
            JSONObject ret = this.communicator.sendPost(req);
            if (ret.getInt("STATUS") != 200) {
                throw new RuntimeException("Upload failed");
            }
        };
        this.executorService.execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete() {
        IncrementalRecorder incrementalRecorder = this;
        synchronized (incrementalRecorder) {
            this.upload(this.dataStore);
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public abstract void addDataPoint(String var1, double var2);

    public abstract void addDataPoint(long var1, String var3, double var4);
}

