/*
 * Decompiled with CFR 0.152.
 */
package edu.teco.explorer;

import edu.teco.explorer.IncrementalRecorder;
import edu.teco.explorer.IncrementalRecorderDeviceTime;
import edu.teco.explorer.IncrementalRecorderUserTime;
import edu.teco.explorer.NetworkCommunicator;
import org.json.JSONException;
import org.json.JSONObject;

public class Recorder {
    private final String UPLOADDATASETURL = "/api/deviceapi/uploadDataset";
    private String backendUrl;
    private String projectKey;

    public Recorder(String backendUrl, String key) {
        this.backendUrl = backendUrl;
        this.projectKey = key;
    }

    public IncrementalRecorder getIncrementalDataset(String name, boolean useDeviceTime) throws Exception {
        if (!useDeviceTime) {
            return new IncrementalRecorderUserTime(this.backendUrl, this.projectKey, name);
        }
        return new IncrementalRecorderDeviceTime(this.backendUrl, this.projectKey, name);
    }

    public boolean sendDataset(JSONObject dataset) {
        JSONObject sendObj = new JSONObject();
        try {
            sendObj.put("key", (Object)this.projectKey);
            sendObj.put("payload", (Object)dataset);
            JSONObject ret = new NetworkCommunicator(this.backendUrl + this.UPLOADDATASETURL).sendPost(sendObj);
            return ret != null && ret.getInt("STATUS") == 200;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }
}

