/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.oa4mp.client.oauth2.loader;

import edu.uiuc.ncsa.myproxy.oa4mp.client.Asset;
import edu.uiuc.ncsa.myproxy.oa4mp.client.ClientEnvironment;
import edu.uiuc.ncsa.myproxy.oa4mp.client.OA4MPServiceProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.client.loader.AbstractClientLoader;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetStore;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.FSAssetStoreProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.MemoryAssetStore;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.MultiAssetStoreProvider;
import edu.uiuc.ncsa.oa4mp.client.oauth2.loader.edu.uiuc.ncsa.oa4mp.client.oauth2.client.Asset2Provider;
import edu.uiuc.ncsa.oa4mp.client.oauth2.loader.edu.uiuc.ncsa.oa4mp.client.oauth2.client.CI2;
import edu.uiuc.ncsa.oa4mp.client.oauth2.loader.edu.uiuc.ncsa.oa4mp.client.oauth2.client.OA2AssetConverter;
import edu.uiuc.ncsa.oa4mp.client.oauth2.loader.edu.uiuc.ncsa.oa4mp.client.oauth2.client.OA2AssetSerializationKeys;
import edu.uiuc.ncsa.oa4mp.client.oauth2.loader.edu.uiuc.ncsa.oa4mp.client.oauth2.client.OA2SQLAssetStoreProvider;
import edu.uiuc.ncsa.oa4mp.client.oauth2.loader.edu.uiuc.ncsa.oa4mp.client.oauth2.client.OA4MPSP2;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEvent;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEventListener;
import edu.uiuc.ncsa.security.core.configuration.provider.TypedProvider;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.delegation.client.DelegationService;
import edu.uiuc.ncsa.security.delegation.client.server.AGServer;
import edu.uiuc.ncsa.security.delegation.client.server.ATServer;
import edu.uiuc.ncsa.security.delegation.client.server.PAServer;
import edu.uiuc.ncsa.security.delegation.client.server.RTServer;
import edu.uiuc.ncsa.security.delegation.storage.Client;
import edu.uiuc.ncsa.security.delegation.token.TokenForge;
import edu.uiuc.ncsa.security.oauth_2_0.TokenForge2;
import edu.uiuc.ncsa.security.oauth_2_0.client.AGServer2;
import edu.uiuc.ncsa.security.oauth_2_0.client.ATServer2;
import edu.uiuc.ncsa.security.oauth_2_0.client.DS2;
import edu.uiuc.ncsa.security.oauth_2_0.client.PAServer2;
import edu.uiuc.ncsa.security.oauth_2_0.client.RTServer2;
import edu.uiuc.ncsa.security.oauth_2_0.client.UIServer2;
import edu.uiuc.ncsa.security.servlet.ServiceClient;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.data.SerializationKeys;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPoolProvider;
import edu.uiuc.ncsa.security.util.ssl.SSLConfiguration;
import edu.uiuc.ncsa.security.util.ssl.SSLConfigurationUtil;
import java.net.URI;
import java.util.HashMap;
import javax.inject.Provider;
import org.apache.commons.configuration.tree.ConfigurationNode;

public class ClientLoader2<T extends ClientEnvironment>
extends AbstractClientLoader<T> {
    AssetProvider assetProvider = null;
    SSLConfiguration sslConfiguration = null;

    public ClientLoader2(ConfigurationNode node) {
        super(node);
    }

    public ClientLoader2(ConfigurationNode node, MyLoggingFacade logger) {
        super(node, logger);
    }

    public String getVersionNumber() {
        return "OA4MP Client OAuth 2 configuration loader, version 1.0.8";
    }

    public OA4MPServiceProvider getServiceProvider() {
        return new OA4MPSP2(this.load());
    }

    public T createInstance(Provider<TokenForge> tokenForgeProvider, Provider<Client> clientProvider, HashMap<String, String> constants) {
        CI2 ce = null;
        ce = new CI2(this.myLogger, constants, this.getAccessTokenURI(), this.getAuthorizeURI(), this.getCallback(), this.getInitiateURI(), this.getAssetURI(), this.checkCertLifetime(), this.getId(), this.getSkin(), this.isEnableAssetCleanup(), this.getMaxAssetLifetime(), this.getAssetProvider(), clientProvider, tokenForgeProvider, this.getDSP(), this.getAssetStoreProvider(), this.isShowRedirectPage(), this.getErrorPagePath(), this.getRedirectPagePath(), this.getSuccessPagePath());
        return (T)((Object)ce);
    }

    public AssetProvider getAssetProvider() {
        if (this.assetProvider == null) {
            this.assetProvider = new Asset2Provider();
        }
        return this.assetProvider;
    }

    protected Provider<AssetStore> getAssetStoreProvider() {
        if (this.assetStoreProvider == null) {
            MultiAssetStoreProvider masp = new MultiAssetStoreProvider(this.cn, this.isDefaultStoreDisabled(new boolean[0]), (MyLoggingFacade)this.loggerProvider.get());
            OA2AssetSerializationKeys keys = new OA2AssetSerializationKeys();
            OA2AssetConverter assetConverter = new OA2AssetConverter((SerializationKeys)keys, (IdentifiableProvider<Asset>)this.getAssetProvider());
            this.assetStoreProvider = masp;
            masp.addListener((CfgEventListener)new FSAssetStoreProvider(this.cn, this.getAssetProvider(), (MapConverter)assetConverter));
            masp.addListener((CfgEventListener)new OA2SQLAssetStoreProvider(this.cn, "postgresql", (ConnectionPoolProvider<? extends ConnectionPool>)this.getPgConnectionPoolProvider(), this.getAssetProvider(), (MapConverter)assetConverter));
            masp.addListener((CfgEventListener)new OA2SQLAssetStoreProvider(this.cn, "mysql", (ConnectionPoolProvider<? extends ConnectionPool>)this.getMySQLConnectionPoolProvider(), this.getAssetProvider(), (MapConverter)assetConverter));
            masp.addListener((CfgEventListener)new TypedProvider<MemoryAssetStore>(this.cn, "memoryStore", "assetStore"){

                public Object componentFound(CfgEvent configurationEvent) {
                    if (this.checkEvent(configurationEvent)) {
                        return this.get();
                    }
                    return null;
                }

                public MemoryAssetStore get() {
                    return new MemoryAssetStore((IdentifiableProvider)ClientLoader2.this.getAssetProvider());
                }
            });
        }
        return this.assetStoreProvider;
    }

    protected String getErrorPagePath() {
        return this.getCfgValue("errorPagePath");
    }

    protected String getSuccessPagePath() {
        return this.getCfgValue("successPagePath");
    }

    protected String getRedirectPagePath() {
        return this.getCfgValue("redirectPagePath");
    }

    protected boolean isShowRedirectPage() {
        String temp = this.getCfgValue("showRedirectPage");
        if (temp == null || temp.length() == 0) {
            return false;
        }
        return Boolean.parseBoolean(this.getCfgValue("showRedirectPage"));
    }

    public T createInstance() {
        Provider<TokenForge> tokenForgeProvider = new Provider<TokenForge>(){

            public TokenForge get() {
                return new TokenForge2(ClientLoader2.this.getId());
            }
        };
        Provider<Client> clientProvider = new Provider<Client>(){

            public Client get() {
                return new Client(BasicIdentifier.newID((String)ClientLoader2.this.getId()));
            }
        };
        HashMap<String, String> constants = new HashMap<String, String>();
        constants.put("oa4mp:callback_uri", "redirect_uri");
        constants.put("oa4mp:form_encoding", "application/x-www-form-urlencoded");
        constants.put("oa4mp:token", "access_token");
        constants.put("oa4mp:token", "code");
        return this.createInstance(tokenForgeProvider, clientProvider, constants);
    }

    protected Provider<DelegationService> getDSP() {
        if (this.dsp == null) {
            this.dsp = new Provider<DelegationService>(){

                public DelegationService get() {
                    return new DS2((AGServer)new AGServer2(ClientLoader2.this.createServiceClient(ClientLoader2.this.getAuthzURI())), (ATServer)new ATServer2(ClientLoader2.this.createServiceClient(ClientLoader2.this.getAccessTokenURI())), (PAServer)new PAServer2(ClientLoader2.this.createServiceClient(ClientLoader2.this.getAssetURI())), new UIServer2(ClientLoader2.this.createServiceClient(ClientLoader2.this.getUIURI())), (RTServer)new RTServer2(ClientLoader2.this.createServiceClient(ClientLoader2.this.getAccessTokenURI())));
                }
            };
        }
        return this.dsp;
    }

    public SSLConfiguration getSSLConfiguration() {
        if (this.sslConfiguration == null) {
            this.sslConfiguration = SSLConfigurationUtil.getSSLConfiguration((ConfigurationNode)this.cn);
        }
        return this.sslConfiguration;
    }

    public ServiceClient createServiceClient(URI host) {
        return new ServiceClient(host, this.getSSLConfiguration());
    }

    protected URI getUIURI() {
        return this.createServiceURI(this.getCfgValue("userInfoUri"), this.getCfgValue("serviceUri"), "userinfo");
    }

    protected URI getAuthzURI() {
        return this.createServiceURI(this.getCfgValue("authorizationUri"), this.getCfgValue("serviceUri"), "authorize");
    }
}

