/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.oa4mp.client.oauth2.loader.edu.uiuc.ncsa.oa4mp.client.oauth2.client;

import edu.uiuc.ncsa.myproxy.oa4mp.client.Asset;
import edu.uiuc.ncsa.myproxy.oa4mp.client.ClientEnvironment;
import edu.uiuc.ncsa.myproxy.oa4mp.client.OA4MPService;
import edu.uiuc.ncsa.oa4mp.client.oauth2.loader.edu.uiuc.ncsa.oa4mp.client.oauth2.client.Asset2;
import edu.uiuc.ncsa.security.delegation.client.request.RTRequest;
import edu.uiuc.ncsa.security.delegation.client.request.RTResponse;
import edu.uiuc.ncsa.security.delegation.client.request.UIRequest;
import edu.uiuc.ncsa.security.delegation.client.request.UIResponse;
import edu.uiuc.ncsa.security.oauth_2_0.UserInfo;
import edu.uiuc.ncsa.security.oauth_2_0.client.DS2;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;

public class OA4MPService2
extends OA4MPService {
    public void preGetCert(Asset asset, Map parameters) {
        super.preGetCert(asset, parameters);
        parameters.put("certreq", Base64.encodeBase64String((byte[])asset.getCertReq().getEncoded()));
        if (!parameters.containsKey(this.getEnvironment().getConstants().get("oa4mp:callback_uri"))) {
            parameters.put(this.getEnvironment().getConstants().get("oa4mp:callback_uri"), this.getEnvironment().getCallback().toString());
        }
        if (0L <= this.getEnvironment().getCertLifetime()) {
            parameters.put("certlifetime", this.getEnvironment().getCertLifetime());
        }
    }

    public void preRequestCert(Asset asset, Map parameters) {
        if (!parameters.containsKey(this.getEnvironment().getConstants().get("oa4mp:callback_uri"))) {
            parameters.put(this.getEnvironment().getConstants().get("oa4mp:callback_uri"), this.getEnvironment().getCallback().toString());
        }
    }

    public OA4MPService2(ClientEnvironment environment) {
        super(environment);
    }

    public Asset2 refresh(String identifier) {
        Asset2 asset = (Asset2)this.getAssetStore().get(identifier);
        if (asset == null) {
            return null;
        }
        DS2 ds2 = (DS2)this.getEnvironment().getDelegationService();
        RTRequest rtRequest = new RTRequest(this.getEnvironment().getClient(), null);
        rtRequest.setAccessToken(asset.getAccessToken());
        rtRequest.setRefreshToken(asset.getRefreshToken());
        RTResponse rtResponse = ds2.refresh(rtRequest);
        asset.setAccessToken(rtRequest.getAccessToken());
        asset.setRefreshToken(rtRequest.getRefreshToken());
        return asset;
    }

    public UserInfo getUserInfo(String identifier) {
        Asset2 asset = (Asset2)this.getAssetStore().get(identifier);
        if (asset == null || asset.getAccessToken() == null) {
            return null;
        }
        UIRequest uiRequest = new UIRequest(asset.getAccessToken());
        uiRequest.setClient(this.getEnvironment().getClient());
        DS2 ds2 = (DS2)this.getEnvironment().getDelegationService();
        UIResponse resp = ds2.getUserInfo(uiRequest);
        JSONObject json = JSONObject.fromObject((Object)resp.getRawJSON());
        UserInfo ui = (UserInfo)JSONObject.toBean((JSONObject)json, UserInfo.class);
        return ui;
    }
}

