/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.oa4mp.oauth2.client;

import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetStore;
import edu.uiuc.ncsa.oa4mp.oauth2.client.OA2Asset;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.cache.RetentionPolicy;
import edu.uiuc.ncsa.security.core.util.DateUtils;
import edu.uiuc.ncsa.security.delegation.token.RefreshToken;
import java.util.Date;
import java.util.Map;

public class AssetRetentionPolicy
implements RetentionPolicy {
    AssetStore rts;

    public AssetRetentionPolicy(AssetStore rts) {
        this.rts = rts;
    }

    public boolean applies() {
        return true;
    }

    public boolean retain(Object key, Object value) {
        Identifier identifier = (Identifier)key;
        OA2Asset oa2Asset = (OA2Asset)((Object)value);
        RefreshToken rt = oa2Asset.getRefreshToken();
        if (rt == null || rt.getToken() == null) {
            return true;
        }
        Date creationTS = DateUtils.getDate((String)oa2Asset.getRefreshToken().getToken());
        return creationTS.getTime() + oa2Asset.getRefreshToken().getExpiresIn() <= System.currentTimeMillis();
    }

    public Map getMap() {
        return this.rts;
    }
}

