/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.oa4mp.oauth2.client;

import edu.uiuc.ncsa.myproxy.oa4mp.client.Asset;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetConverter;
import edu.uiuc.ncsa.oa4mp.oauth2.client.OA2Asset;
import edu.uiuc.ncsa.oa4mp.oauth2.client.OA2AssetSerializationKeys;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.delegation.token.AccessToken;
import edu.uiuc.ncsa.security.delegation.token.RefreshToken;
import edu.uiuc.ncsa.security.delegation.token.impl.AccessTokenImpl;
import edu.uiuc.ncsa.security.oauth_2_0.OA2RefreshTokenImpl;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import edu.uiuc.ncsa.security.storage.data.SerializationKeys;
import edu.uiuc.ncsa.security.util.pkcs.CertUtil;
import edu.uiuc.ncsa.security.util.pkcs.MyPKCS10CertRequest;
import java.net.URI;

public class OA2AssetConverter
extends AssetConverter {
    public OA2AssetConverter(SerializationKeys keys, IdentifiableProvider<Asset> provider) {
        super(keys, provider);
    }

    OA2AssetSerializationKeys getASK() {
        return (OA2AssetSerializationKeys)this.keys;
    }

    public Asset fromMap(ConversionMap<String, Object> map, Asset asset) {
        String state;
        String rt;
        String at;
        OA2Asset a = (OA2Asset)super.fromMap(map, asset);
        String rawCR = map.getString((Object)this.getASK().certReq(new String[0]));
        if (rawCR != null) {
            MyPKCS10CertRequest certReq = CertUtil.fromStringToCertReq((String)rawCR);
            a.setCertReq(certReq);
        }
        if ((at = map.getString((Object)this.getASK().accessToken(new String[0]))) != null) {
            a.setAccessToken((AccessToken)new AccessTokenImpl(URI.create(at)));
        }
        if ((rt = map.getString((Object)this.getASK().refreshToken(new String[0]))) != null) {
            OA2RefreshTokenImpl refreshToken = new OA2RefreshTokenImpl(URI.create(rt));
            refreshToken.setExpiresIn(map.getLong((Object)this.getASK().refreshLifetime(new String[0])));
            a.setRefreshToken((RefreshToken)refreshToken);
        }
        if ((state = map.getString((Object)this.getASK().state(new String[0]))) != null) {
            a.setState(state);
        }
        a.setNonce(map.getString((Object)this.getASK().nonce(new String[0])));
        if (map.containsKey((Object)"iat")) {
            a.setIssuedAt(map.getDate((Object)"iat"));
        }
        return a;
    }

    public void toMap(Asset asset, ConversionMap<String, Object> map) {
        super.toMap(asset, map);
        OA2Asset a = (OA2Asset)super.fromMap(map, asset);
        if (a.getCertReq() != null) {
            map.put((Object)this.getASK().certReq(new String[0]), (Object)CertUtil.fromCertReqToString((MyPKCS10CertRequest)asset.getCertReq()));
        }
        if (a.getAccessToken() != null) {
            map.put((Object)this.getASK().accessToken(new String[0]), (Object)a.getAccessToken().getToken());
        }
        if (a.getRefreshToken() != null) {
            map.put((Object)this.getASK().refreshToken(new String[0]), (Object)a.getRefreshToken().getToken());
            map.put((Object)this.getASK().refreshLifetime(new String[0]), (Object)a.getRefreshToken().getExpiresIn());
        }
        if (a.getState() != null) {
            map.put((Object)this.getASK().state(new String[0]), (Object)a.getState());
        }
        map.put((Object)this.getASK().nonce(new String[0]), (Object)a.getNonce());
        if (a.getIssuedAt() != null) {
            map.put((Object)"iat", (Object)a.getIssuedAt());
        }
    }
}

