/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.oa4mp.oauth2.client;

import edu.uiuc.ncsa.myproxy.oa4mp.client.ClientEnvironment;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetStore;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.delegation.client.DelegationService;
import edu.uiuc.ncsa.security.delegation.storage.Client;
import edu.uiuc.ncsa.security.delegation.token.TokenForge;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import javax.inject.Provider;

public class OA2ClientEnvironment
extends ClientEnvironment {
    Collection<String> scopes = null;
    String secret;

    public OA2ClientEnvironment(URI accessTokenUri, URI authorizationUri, URI callback, long certLifetime, String clientId, DelegationService delegationService, URI resourceServerUri, TokenForge tokenForge, AssetStore assetStore, boolean showRedirectPage, String errorPagePath, String redirectPagePath, String successPagePath) {
        super(accessTokenUri, authorizationUri, callback, certLifetime, clientId, delegationService, null, null, null, resourceServerUri, tokenForge, assetStore, showRedirectPage, errorPagePath, redirectPagePath, successPagePath);
    }

    public OA2ClientEnvironment(MyLoggingFacade logger, Map<String, String> constants, URI accessTokenUri, URI authorizationUri, URI callback, URI initializeURI, URI resourceServerUri, long certLifetime, String clientId, String skin, boolean enableAssetCleanup, long maxAssetLifetime, long keypairLifetime, AssetProvider assetProvider, Provider<Client> clientProvider, Provider<TokenForge> tokenForgeProvider, Provider<DelegationService> delegationServiceProvider, Provider<AssetStore> assetStoreProvider, boolean showRedirectPage, String errorPagePath, String redirectPagePath, String successPagePath, String secret, Collection<String> scopes) {
        super(logger, constants, accessTokenUri, authorizationUri, callback, initializeURI, resourceServerUri, certLifetime, clientId, null, null, skin, enableAssetCleanup, maxAssetLifetime, keypairLifetime, assetProvider, clientProvider, tokenForgeProvider, delegationServiceProvider, assetStoreProvider, showRedirectPage, errorPagePath, redirectPagePath, successPagePath);
        this.secret = secret;
        this.scopes = scopes;
    }

    public Collection<String> getScopes() {
        return this.scopes;
    }

    public Client getClient() {
        if (this.client == null) {
            this.client = (Client)this.cp.get();
            this.client.setIdentifier((Identifier)new BasicIdentifier(this.getClientId()));
            this.client.setSecret(this.secret);
        }
        return this.client;
    }
}

