/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.oa4mp.oauth2.client;

import edu.uiuc.ncsa.myproxy.oa4mp.client.Asset;
import edu.uiuc.ncsa.myproxy.oa4mp.client.AssetResponse;
import edu.uiuc.ncsa.myproxy.oa4mp.client.ClientEnvironment;
import edu.uiuc.ncsa.myproxy.oa4mp.client.OA4MPResponse;
import edu.uiuc.ncsa.myproxy.oa4mp.client.OA4MPService;
import edu.uiuc.ncsa.oa4mp.oauth2.client.OA2Asset;
import edu.uiuc.ncsa.oa4mp.oauth2.client.OA2ClientEnvironment;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.NFWException;
import edu.uiuc.ncsa.security.delegation.client.request.ATResponse;
import edu.uiuc.ncsa.security.delegation.client.request.DelegatedAssetRequest;
import edu.uiuc.ncsa.security.delegation.client.request.DelegatedAssetResponse;
import edu.uiuc.ncsa.security.delegation.client.request.RTRequest;
import edu.uiuc.ncsa.security.delegation.client.request.RTResponse;
import edu.uiuc.ncsa.security.delegation.client.request.UIRequest;
import edu.uiuc.ncsa.security.delegation.client.request.UIResponse;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import edu.uiuc.ncsa.security.delegation.token.MyX509Certificates;
import edu.uiuc.ncsa.security.delegation.token.Verifier;
import edu.uiuc.ncsa.security.oauth_2_0.NonceHerder;
import edu.uiuc.ncsa.security.oauth_2_0.OA2Scopes;
import edu.uiuc.ncsa.security.oauth_2_0.UserInfo;
import edu.uiuc.ncsa.security.oauth_2_0.client.ATResponse2;
import edu.uiuc.ncsa.security.oauth_2_0.client.DS2;
import edu.uiuc.ncsa.security.oauth_2_0.server.InvalidNonceException;
import edu.uiuc.ncsa.security.util.pkcs.CertUtil;
import edu.uiuc.ncsa.security.util.pkcs.KeyUtil;
import edu.uiuc.ncsa.security.util.pkcs.MyPKCS10CertRequest;
import edu.uiuc.ncsa.security.util.pkcs.PEMFormatUtil;
import java.net.URLEncoder;
import java.security.KeyPair;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import net.sf.json.JSONObject;

public class OA2MPService
extends OA4MPService {
    private static final boolean MANUAL_TEST = false;
    protected String requestedScopes;

    public void preGetCert(Asset asset, Map parameters) {
        super.preGetCert(asset, parameters);
        OA2Asset a = (OA2Asset)asset;
        parameters.put("certreq", PEMFormatUtil.bytesToChunkedString((byte[])asset.getCertReq().getEncoded()));
        if (!parameters.containsKey(this.getEnvironment().getConstants().get("oa4mp:callback_uri"))) {
            parameters.put(this.getEnvironment().getConstants().get("oa4mp:callback_uri"), this.getEnvironment().getCallback().toString());
        }
        if (0L <= this.getEnvironment().getCertLifetime()) {
            parameters.put("certlifetime", this.getEnvironment().getCertLifetime());
        }
        if (asset.getCertificates() != null) {
            MyPKCS10CertRequest certRequest = asset.getCertReq();
            KeyPair keyPair = null;
            if (certRequest == null) {
                try {
                    keyPair = KeyUtil.generateKeyPair();
                }
                catch (Throwable e) {
                    String msg = "Unable to generate a new keypair.";
                    this.getEnvironment().getMyLogger().warn(msg, e);
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new GeneralException(msg, e);
                }
                asset.setPrivateKey(keyPair.getPrivate());
            } else {
                keyPair = new KeyPair(certRequest.getPublicKey(), asset.getPrivateKey());
            }
            if (asset.getPrivateKey() == null) {
                String msg = "Error: The private key is missing. The internal state of the asset is invalid";
                NFWException x = new NFWException(msg);
                this.getEnvironment().getMyLogger().warn(msg, (Throwable)x);
                throw x;
            }
            try {
                asset.setCertReq(CertUtil.createCertRequest((KeyPair)keyPair));
            }
            catch (Throwable t) {
                String msg = "Error: could not create cert request.";
                this.getEnvironment().getMyLogger().warn(msg, t);
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new GeneralException(msg, t);
            }
        }
    }

    protected Map<String, String> getATParameters(Asset asset, AuthorizationGrant ag, Verifier v) {
        Map m = super.getATParameters(asset, ag, v);
        OA2Asset a = (OA2Asset)asset;
        m.put("nonce", a.getNonce());
        m.put("state", a.getState());
        return m;
    }

    public String getRequestedScopes() {
        if (this.requestedScopes == null) {
            boolean firstPass = true;
            String[] basicScopes = OA2Scopes.basicScopes;
            HashSet<String> targetScopes = new HashSet<String>();
            Collection<String> scopeList = ((OA2ClientEnvironment)this.getEnvironment()).getScopes();
            targetScopes.addAll(scopeList);
            for (String x : basicScopes) {
                targetScopes.add(x);
            }
            this.requestedScopes = "";
            for (String scope : targetScopes) {
                if (firstPass) {
                    this.requestedScopes = scope;
                    firstPass = false;
                    continue;
                }
                this.requestedScopes = this.requestedScopes + " " + scope;
            }
        }
        return this.requestedScopes;
    }

    public void preRequestCert(Asset asset, Map parameters) {
        if (!parameters.containsKey(this.getEnvironment().getConstants().get("oa4mp:callback_uri"))) {
            parameters.put(this.getEnvironment().getConstants().get("oa4mp:callback_uri"), this.getEnvironment().getCallback().toString());
        }
        OA2Asset a = (OA2Asset)asset;
        a.setState(NonceHerder.createNonce());
        a.setNonce(NonceHerder.createNonce());
        parameters.put("response_type", "code");
        parameters.put("scope", this.getRequestedScopes());
        parameters.put("state", a.getState());
        parameters.put("nonce", a.getNonce());
        parameters.put("prompt", "login");
    }

    public void postRequestCert(Asset asset, OA4MPResponse oa4MPResponse) {
        super.postRequestCert(asset, oa4MPResponse);
        OA2Asset a = (OA2Asset)asset;
    }

    public OA2MPService(ClientEnvironment environment) {
        super(environment);
    }

    public ATResponse2 getAccessToken(OA2Asset asset, AuthorizationGrant ag) {
        DelegatedAssetRequest dar = new DelegatedAssetRequest();
        dar.setAuthorizationGrant(ag);
        dar.setClient(this.getEnvironment().getClient());
        Map<String, String> m1 = this.getATParameters(asset, ag, null);
        dar.setParameters(m1);
        ATResponse2 atResponse2 = (ATResponse2)this.getEnvironment().getDelegationService().getAT(dar);
        asset.setIssuedAt((Date)atResponse2.getParameters().get("iat"));
        asset.setUsername((String)atResponse2.getParameters().get("sub"));
        if (!NonceHerder.hasNonce((String)((String)atResponse2.getParameters().get("nonce")))) {
            throw new InvalidNonceException("Unknown nonce.");
        }
        NonceHerder.removeNonce((String)((String)atResponse2.getParameters().get("nonce")));
        asset.setAccessToken(atResponse2.getAccessToken());
        asset.setRefreshToken(atResponse2.getRefreshToken());
        this.getAssetStore().save((Identifiable)asset);
        return atResponse2;
    }

    protected AssetResponse manualTest(OA2Asset a, Map<String, String> m1) {
        try {
            System.err.println(((Object)((Object)this)).getClass().getSimpleName() + ".getAccessToken: Returned parameters");
            System.err.println("access token=" + URLEncoder.encode(a.getAccessToken().getToken(), "UTF-8") + "");
            System.err.println("&client_id=" + URLEncoder.encode(this.getEnvironment().getClient().getIdentifierString(), "UTF-8") + "");
            System.err.println("&client_secret=" + URLEncoder.encode(this.getEnvironment().getClient().getSecret(), "UTF-8") + "");
            System.err.println("&certreq=" + URLEncoder.encode(m1.get("certreq"), "UTF-8") + "");
        }
        catch (Throwable t) {
            System.err.println(((Object)((Object)this)).getClass().getSimpleName() + ".getCert: attempt to get response parameters failed.");
            t.printStackTrace();
        }
        return null;
    }

    public AssetResponse getCert(OA2Asset a, ATResponse2 atResponse2) {
        KeyPair keyPair = this.getNextKeyPair();
        MyPKCS10CertRequest certReq = null;
        try {
            certReq = CertUtil.createCertRequest((KeyPair)keyPair, (String)a.getUsername());
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new GeneralException("Could no create cert request", e);
        }
        a.setPrivateKey(keyPair.getPrivate());
        a.setCertReq(certReq);
        Map m1 = this.getAssetParameters(a);
        this.preGetCert(a, m1);
        DelegatedAssetResponse daResp = this.getEnvironment().getDelegationService().getCert((ATResponse)atResponse2, this.getEnvironment().getClient(), m1);
        AssetResponse par = new AssetResponse();
        MyX509Certificates myX509Certificate = (MyX509Certificates)daResp.getProtectedAsset();
        par.setX509Certificates(myX509Certificate.getX509Certificates());
        this.postGetCert(a, par);
        a.setCertificates(par.getX509Certificates());
        this.getEnvironment().getAssetStore().save((Identifiable)a);
        return par;
    }

    protected AssetResponse getCert(Asset a, AuthorizationGrant ag, Verifier v) {
        OA2Asset asset = (OA2Asset)a;
        ATResponse2 atResp = this.getAccessToken(asset, ag);
        return this.getCert(asset, atResp);
    }

    public OA2Asset refresh(String identifier) {
        OA2Asset asset = (OA2Asset)this.getAssetStore().get(identifier);
        if (asset == null) {
            return null;
        }
        DS2 ds2 = (DS2)this.getEnvironment().getDelegationService();
        RTRequest rtRequest = new RTRequest(this.getEnvironment().getClient(), null);
        rtRequest.setAccessToken(asset.getAccessToken());
        rtRequest.setRefreshToken(asset.getRefreshToken());
        RTResponse rtResponse = ds2.refresh(rtRequest);
        asset.setAccessToken(rtResponse.getAccessToken());
        asset.setRefreshToken(rtResponse.getRefreshToken());
        this.getAssetStore().remove((Object)asset.getIdentifier());
        this.getAssetStore().save((Identifiable)asset);
        return asset;
    }

    public UserInfo getUserInfo(String identifier) {
        OA2Asset asset = this.getAsset2(identifier);
        if (asset == null || asset.getAccessToken() == null) {
            return null;
        }
        UIRequest uiRequest = new UIRequest(asset.getAccessToken());
        uiRequest.setClient(this.getEnvironment().getClient());
        DS2 ds2 = (DS2)this.getEnvironment().getDelegationService();
        UIResponse resp = ds2.getUserInfo(uiRequest);
        JSONObject json = JSONObject.fromObject((Object)resp.getRawJSON());
        UserInfo ui = new UserInfo();
        ui.setMap((Map)json);
        return ui;
    }

    protected OA2Asset getAsset2(String id) {
        return (OA2Asset)this.getAssetStore().get(id);
    }

    public OA2Asset getCert(String id) {
        OA2Asset OA2Asset2 = (OA2Asset)this.getAssetStore().get(id);
        AssetResponse assetResponse = this.getCert(OA2Asset2.getAccessToken().getToken(), null);
        OA2Asset2.setCertificates(assetResponse.getX509Certificates());
        OA2Asset2.setUsername(assetResponse.getUsername());
        this.getAssetStore().save((Identifiable)OA2Asset2);
        return OA2Asset2;
    }
}

