/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.oa4mp.oauth2.client.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.client.servlet.ClientExceptionHandler;
import edu.uiuc.ncsa.myproxy.oa4mp.client.servlet.ClientServlet;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.oauth_2_0.OA2RedirectableError;
import edu.uiuc.ncsa.security.servlet.JSPUtil;
import edu.uiuc.ncsa.security.servlet.ServiceClientHTTPException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OA2ClientExceptionHandler
extends ClientExceptionHandler {
    public OA2ClientExceptionHandler(ClientServlet clientServlet, MyLoggingFacade myLogger) {
        super(clientServlet, myLogger);
    }

    public void handleException(Throwable t, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (t instanceof OA2RedirectableError) {
            this.getLogger().info("get a standard error with a redirect");
            OA2RedirectableError oa2RedirectableError = (OA2RedirectableError)t;
            request.setAttribute("error", (Object)oa2RedirectableError.getError());
            request.setAttribute("error_description", (Object)oa2RedirectableError.getDescription());
            request.setAttribute("state", (Object)oa2RedirectableError.getState());
        } else if (t instanceof ServiceClientHTTPException) {
            ServiceClientHTTPException tt = (ServiceClientHTTPException)t;
            this.getLogger().info("got standard error with http status code = " + tt.getStatus());
            if (!tt.hasContent()) {
                this.defaultSCXresponse(tt, request);
            } else {
                try {
                    this.parseContent(tt.getContent(), request);
                }
                catch (GeneralException xx) {
                    this.defaultSCXresponse(tt, request);
                }
            }
        } else {
            this.getLogger().info("Got exception of type " + t.getClass().getSimpleName());
            t.printStackTrace();
            request.setAttribute("error", (Object)t.getClass().getSimpleName());
            request.setAttribute("error_description", (Object)t.getMessage());
        }
        request.setAttribute("action", (Object)request.getContextPath());
        JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)this.clientServlet.getCE().getErrorPagePath());
    }

    protected void parseContent(String content, HttpServletRequest request) {
        boolean hasValidContent = false;
        StringTokenizer st = new StringTokenizer(content, "\n");
        while (st.hasMoreElements()) {
            String currentLine = st.nextToken();
            StringTokenizer clST = new StringTokenizer(currentLine, "=");
            if (!clST.hasMoreTokens() || clST.countTokens() != 2) continue;
            try {
                request.setAttribute(clST.nextToken(), (Object)URLDecoder.decode(clST.nextToken(), "UTF-8"));
            }
            catch (UnsupportedEncodingException xx) {
                request.setAttribute(clST.nextToken(), (Object)clST.nextToken());
            }
            hasValidContent = true;
        }
        if (!hasValidContent) {
            this.getLogger().warn("Body or error was not parseable");
            throw new GeneralException();
        }
    }

    protected void defaultSCXresponse(ServiceClientHTTPException tt, HttpServletRequest request) {
        request.setAttribute("error", (Object)tt.getClass().getSimpleName());
        request.setAttribute("error_description", (Object)("Status code=" + tt.getStatus() + ", message=\"" + tt.getMessage() + "\""));
        request.setAttribute("state", (Object)"(none)");
    }
}

