/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.oa4mp.oauth2.client.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.client.AssetResponse;
import edu.uiuc.ncsa.myproxy.oa4mp.client.servlet.ClientServlet;
import edu.uiuc.ncsa.oa4mp.oauth2.client.OA2Asset;
import edu.uiuc.ncsa.oa4mp.oauth2.client.OA2ClientEnvironment;
import edu.uiuc.ncsa.oa4mp.oauth2.client.OA2MPService;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import edu.uiuc.ncsa.security.delegation.token.impl.AuthorizationGrantImpl;
import edu.uiuc.ncsa.security.oauth_2_0.OA2RedirectableError;
import edu.uiuc.ncsa.security.oauth_2_0.UserInfo;
import edu.uiuc.ncsa.security.oauth_2_0.client.ATResponse2;
import edu.uiuc.ncsa.security.servlet.JSPUtil;
import edu.uiuc.ncsa.security.util.pkcs.CertUtil;
import java.net.URI;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.util.JSONUtils;

public class OA2ReadyServlet
extends ClientServlet {
    protected void doIt(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        if (request.getParameterMap().containsKey("error")) {
            throw new OA2RedirectableError(request.getParameter("error"), request.getParameter("error_description"), request.getParameter("state"));
        }
        this.info("2.a. Getting token and verifier.");
        String token = request.getParameter(OA2ReadyServlet.CONST((String)"oa4mp:token"));
        String state = request.getParameter("state");
        if (token == null) {
            this.warn("2.a. The token is " + (token == null ? "null" : token) + ".");
            GeneralException ge = new GeneralException("Error: This servlet requires parameters for the token and possibly verifier.");
            request.setAttribute("exception", (Object)ge);
            JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)this.getCE().getErrorPagePath());
            return;
        }
        this.info("2.a Token found.");
        AuthorizationGrantImpl grant = new AuthorizationGrantImpl(URI.create(token));
        this.info("2.a. Getting the cert(s) from the service");
        String identifier = this.clearCookie(request, response);
        OA2Asset asset = null;
        if (identifier == null && (asset = (OA2Asset)this.getCE().getAssetStore().getByToken(BasicIdentifier.newID((String)token))) != null) {
            identifier = asset.getIdentifierString();
        }
        AssetResponse assetResponse = null;
        OA2MPService oa2MPService = (OA2MPService)this.getOA4MPService();
        UserInfo ui = null;
        boolean getCerts = ((OA2ClientEnvironment)this.getCE()).getScopes().contains("edu.uiuc.ncsa.myproxy.getcert");
        if (identifier == null) {
            String msg = "Error: no cookie found. Cannot save certificates";
            this.warn(msg);
            this.debug("No cookie found");
            ATResponse2 atResponse2 = oa2MPService.getAccessToken(asset, (AuthorizationGrant)grant);
            ui = oa2MPService.getUserInfo(atResponse2.getAccessToken().toString());
            if (getCerts) {
                assetResponse = oa2MPService.getCert(asset, atResponse2);
            }
        } else {
            asset = (OA2Asset)this.getCE().getAssetStore().get(identifier);
            if (asset.getState() == null || !asset.getState().equals(state)) {
                this.warn("The expected state from the server was \"" + asset.getState() + "\", but instead \"" + state + "\" was returned. Transaction aborted.");
                throw new IllegalArgumentException("Error: The state returned by the server is invalid.");
            }
            ATResponse2 atResponse2 = oa2MPService.getAccessToken(asset, (AuthorizationGrant)grant);
            ui = oa2MPService.getUserInfo(identifier);
            if (getCerts) {
                assetResponse = oa2MPService.getCert(asset, atResponse2);
            }
        }
        this.info("2.b. Done! Displaying success page.");
        if (getCerts) {
            if (assetResponse.getX509Certificates() == null) {
                request.setAttribute("certSubject", (Object)"(no cert returned)");
            } else {
                X509Certificate cert = assetResponse.getX509Certificates()[0];
                request.setAttribute("certSubject", (Object)cert.getSubjectDN());
                request.setAttribute("cert", (Object)CertUtil.toPEM((X509Certificate[])assetResponse.getX509Certificates()));
                request.setAttribute("username", (Object)assetResponse.getUsername());
            }
        } else {
            request.setAttribute("certSubject", (Object)"(no cert requested)");
        }
        if (ui != null) {
            String output = JSONUtils.valueToString((Object)ui.toJSon(), (int)4, (int)2);
            request.setAttribute("userinfo", (Object)output);
        } else {
            request.setAttribute("userinfo", (Object)"no user info returned.");
        }
        String contextPath = request.getContextPath();
        if (!contextPath.endsWith("/")) {
            contextPath = contextPath + "/";
        }
        request.setAttribute("action", (Object)contextPath);
        this.info("2.a. Completely finished with delegation.");
        JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)this.getCE().getSuccessPagePath());
    }
}

