/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.oa4mp.oauth2.client;

import edu.uiuc.ncsa.myproxy.oa4mp.client.Asset;
import edu.uiuc.ncsa.myproxy.oa4mp.client.ClientEnvironment;
import edu.uiuc.ncsa.myproxy.oa4mp.client.OA4MPServiceProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.client.loader.AbstractClientLoader;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetStore;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.FSAssetStoreProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.MemoryAssetStore;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.MultiAssetStoreProvider;
import edu.uiuc.ncsa.oa4mp.oauth2.client.OA2AssetConverter;
import edu.uiuc.ncsa.oa4mp.oauth2.client.OA2AssetProvider;
import edu.uiuc.ncsa.oa4mp.oauth2.client.OA2AssetSerializationKeys;
import edu.uiuc.ncsa.oa4mp.oauth2.client.OA2ClientEnvironment;
import edu.uiuc.ncsa.oa4mp.oauth2.client.OA2MPServiceProvider;
import edu.uiuc.ncsa.oa4mp.oauth2.client.OA2SQLAssetStoreProvider;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEvent;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEventListener;
import edu.uiuc.ncsa.security.core.configuration.provider.TypedProvider;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.NotImplementedException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.delegation.client.DelegationService;
import edu.uiuc.ncsa.security.delegation.client.server.AGServer;
import edu.uiuc.ncsa.security.delegation.client.server.ATServer;
import edu.uiuc.ncsa.security.delegation.client.server.PAServer;
import edu.uiuc.ncsa.security.delegation.client.server.RTServer;
import edu.uiuc.ncsa.security.delegation.storage.Client;
import edu.uiuc.ncsa.security.delegation.token.TokenForge;
import edu.uiuc.ncsa.security.oauth_2_0.OA2ConfigurationLoaderUtils;
import edu.uiuc.ncsa.security.oauth_2_0.OA2TokenForge;
import edu.uiuc.ncsa.security.oauth_2_0.client.AGServer2;
import edu.uiuc.ncsa.security.oauth_2_0.client.ATServer2;
import edu.uiuc.ncsa.security.oauth_2_0.client.DS2;
import edu.uiuc.ncsa.security.oauth_2_0.client.PAServer2;
import edu.uiuc.ncsa.security.oauth_2_0.client.RTServer2;
import edu.uiuc.ncsa.security.oauth_2_0.client.UIServer2;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.data.SerializationKeys;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPoolProvider;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import javax.inject.Provider;
import org.apache.commons.configuration.tree.ConfigurationNode;

public class OA2ClientLoader<T extends ClientEnvironment>
extends AbstractClientLoader<T> {
    protected Collection<String> scopes = null;
    AssetProvider assetProvider = null;
    String wellKnownURI = null;
    Boolean showIDToken = null;
    Boolean oidcEnabled = null;
    Boolean useBasicAuth = null;

    public OA2ClientLoader(ConfigurationNode node) {
        super(node);
    }

    public String getVersionString() {
        return "OA4MP Client OAuth 2 configuration loader, version 4.3";
    }

    public OA4MPServiceProvider getServiceProvider() {
        return new OA2MPServiceProvider(this.load());
    }

    public Collection<String> getScopes() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (this.scopes == null) {
            this.scopes = OA2ConfigurationLoaderUtils.getScopes((ConfigurationNode)this.cn);
        }
        return this.scopes;
    }

    public T createInstance(Provider<TokenForge> tokenForgeProvider, Provider<Client> clientProvider, HashMap<String, String> constants) {
        try {
            return (T)((Object)new OA2ClientEnvironment(this.myLogger, constants, this.getAccessTokenURI(), this.getAuthorizeURI(), this.getCallback(), this.getInitiateURI(), this.getAssetURI(), this.checkCertLifetime(), this.getId(), this.getSkin(), this.isEnableAssetCleanup(), this.getMaxAssetLifetime(), this.getKeypairLifetime(), this.getAssetProvider(), clientProvider, tokenForgeProvider, this.getDSP(), this.getAssetStoreProvider(), this.isShowRedirectPage(), this.getErrorPagePath(), this.getRedirectPagePath(), this.getSuccessPagePath(), this.getSecret(), this.getScopes(), this.getWellKnownURI(), this.isOIDCEnabled(), this.isShowIDToken(), this.isUseBasicAuth()));
        }
        catch (Throwable e) {
            throw new GeneralException("Unable to create client environment", e);
        }
    }

    public AssetProvider getAssetProvider() {
        if (this.assetProvider == null) {
            this.assetProvider = new OA2AssetProvider();
        }
        return this.assetProvider;
    }

    public String getWellKnownURI() {
        if (this.wellKnownURI == null) {
            this.wellKnownURI = this.getCfgValue("wellKnownUri");
        }
        return this.wellKnownURI;
    }

    public boolean isShowIDToken() {
        if (this.showIDToken == null) {
            try {
                this.showIDToken = Boolean.parseBoolean(this.getCfgValue("showIDToken"));
            }
            catch (Throwable t) {
                this.showIDToken = Boolean.FALSE;
            }
            ServletDebugUtil.trace((Object)((Object)this), (String)("setting showIDToken to " + this.showIDToken));
        }
        return this.showIDToken;
    }

    public boolean isOIDCEnabled() {
        if (this.oidcEnabled == null) {
            this.oidcEnabled = Boolean.TRUE;
            String content = this.getCfgValue("OIDCEnabled");
            if (content == null || content.isEmpty()) {
                return this.oidcEnabled;
            }
            try {
                this.oidcEnabled = Boolean.parseBoolean(content);
            }
            catch (Throwable t) {
                this.myLogger.warn("Unable to parse OIDCEnabled element content of \"" + content + "\". Using default of true.");
            }
        }
        return this.oidcEnabled;
    }

    protected Provider<AssetStore> getAssetStoreProvider() {
        if (this.assetStoreProvider == null) {
            MultiAssetStoreProvider masp = new MultiAssetStoreProvider(this.cn, this.isDefaultStoreDisabled(new boolean[0]), (MyLoggingFacade)this.loggerProvider.get());
            OA2AssetSerializationKeys keys = new OA2AssetSerializationKeys();
            OA2AssetConverter assetConverter = new OA2AssetConverter((SerializationKeys)keys, (IdentifiableProvider<Asset>)this.getAssetProvider());
            this.assetStoreProvider = masp;
            masp.addListener((CfgEventListener)new FSAssetStoreProvider(this.cn, this.getAssetProvider(), (MapConverter)assetConverter));
            masp.addListener((CfgEventListener)new OA2SQLAssetStoreProvider(this.cn, "postgresql", (ConnectionPoolProvider<? extends ConnectionPool>)this.getPgConnectionPoolProvider(), this.getAssetProvider(), (MapConverter)assetConverter));
            masp.addListener((CfgEventListener)new OA2SQLAssetStoreProvider(this.cn, "mysql", (ConnectionPoolProvider<? extends ConnectionPool>)this.getMySQLConnectionPoolProvider(), this.getAssetProvider(), (MapConverter)assetConverter));
            masp.addListener((CfgEventListener)new OA2SQLAssetStoreProvider(this.cn, "mariadb", (ConnectionPoolProvider<? extends ConnectionPool>)this.getMariaDBConnectionPoolProvider(), this.getAssetProvider(), (MapConverter)assetConverter));
            masp.addListener((CfgEventListener)new TypedProvider<MemoryAssetStore>(this.cn, "memoryStore", "assetStore"){

                public Object componentFound(CfgEvent configurationEvent) {
                    if (this.checkEvent(configurationEvent)) {
                        return this.get();
                    }
                    return null;
                }

                public MemoryAssetStore get() {
                    return new MemoryAssetStore((IdentifiableProvider)OA2ClientLoader.this.getAssetProvider());
                }
            });
        }
        return this.assetStoreProvider;
    }

    protected String getErrorPagePath() {
        return this.getCfgValue("errorPagePath");
    }

    protected String getSecret() {
        return this.getCfgValue("secret");
    }

    protected String getSuccessPagePath() {
        return this.getCfgValue("successPagePath");
    }

    protected String getRedirectPagePath() {
        return this.getCfgValue("redirectPagePath");
    }

    protected boolean isShowRedirectPage() {
        String temp = this.getCfgValue("showRedirectPage");
        if (temp == null || temp.length() == 0) {
            return false;
        }
        return Boolean.parseBoolean(this.getCfgValue("showRedirectPage"));
    }

    public T createInstance() {
        Provider<TokenForge> tokenForgeProvider = new Provider<TokenForge>(){

            public TokenForge get() {
                return new OA2TokenForge(OA2ClientLoader.this.getId());
            }
        };
        Provider<Client> clientProvider = new Provider<Client>(){

            public Client get() {
                return new Client(BasicIdentifier.newID((String)OA2ClientLoader.this.getId()));
            }
        };
        HashMap<String, String> constants = new HashMap<String, String>();
        constants.put("oa4mp:callback_uri", "redirect_uri");
        constants.put("oa4mp:form_encoding", "application/x-www-form-urlencoded");
        constants.put("oa4mp:token", "access_token");
        constants.put("oa4mp:token", "code");
        T t = this.createInstance(tokenForgeProvider, clientProvider, constants);
        this.loadDebug();
        t.setDebugOn(DebugUtil.isEnabled());
        return t;
    }

    public Boolean isUseBasicAuth() {
        if (this.useBasicAuth == null) {
            try {
                this.useBasicAuth = Boolean.parseBoolean(this.getCfgValue("useHTTPBasicAuth"));
            }
            catch (Throwable t) {
                this.useBasicAuth = Boolean.FALSE;
            }
        }
        return this.useBasicAuth;
    }

    public void setUseBasicAuth(Boolean useBasicAuth) {
        this.useBasicAuth = useBasicAuth;
    }

    protected Provider<DelegationService> getDSP() {
        if (this.dsp == null) {
            this.dsp = new Provider<DelegationService>(){

                public DelegationService get() {
                    return new DS2((AGServer)new AGServer2(OA2ClientLoader.this.createServiceClient(OA2ClientLoader.this.getAuthzURI())), (ATServer)new ATServer2(OA2ClientLoader.this.createServiceClient(OA2ClientLoader.this.getAccessTokenURI()), OA2ClientLoader.this.getWellKnownURI(), OA2ClientLoader.this.isOIDCEnabled(), OA2ClientLoader.this.isUseBasicAuth().booleanValue()), (PAServer)new PAServer2(OA2ClientLoader.this.createServiceClient(OA2ClientLoader.this.getAssetURI())), new UIServer2(OA2ClientLoader.this.createServiceClient(OA2ClientLoader.this.getUIURI())), (RTServer)new RTServer2(OA2ClientLoader.this.createServiceClient(OA2ClientLoader.this.getAccessTokenURI()), OA2ClientLoader.this.getWellKnownURI(), OA2ClientLoader.this.isOIDCEnabled()));
                }
            };
        }
        return this.dsp;
    }

    protected URI getUIURI() {
        return this.createServiceURI(this.getCfgValue("userInfoUri"), this.getCfgValue("serviceUri"), "userinfo");
    }

    protected URI getAuthzURI() {
        return this.createServiceURI(this.getCfgValue("authorizeUri"), this.getCfgValue("serviceUri"), "authorize");
    }

    protected URI getRevocationURI() {
        return this.createServiceURI(this.getCfgValue("revocationUri"), this.getCfgValue("serviceUri"), "authorize");
    }

    public HashMap<String, String> getConstants() {
        throw new NotImplementedException("Error: This method is not implemented.");
    }
}

