/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.oa4mp.oauth2.client.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.client.AssetResponse;
import edu.uiuc.ncsa.myproxy.oa4mp.client.servlet.ClientServlet;
import edu.uiuc.ncsa.oa4mp.oauth2.client.OA2Asset;
import edu.uiuc.ncsa.oa4mp.oauth2.client.OA2ClientEnvironment;
import edu.uiuc.ncsa.oa4mp.oauth2.client.OA2MPService;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import edu.uiuc.ncsa.security.delegation.token.impl.AuthorizationGrantImpl;
import edu.uiuc.ncsa.security.oauth_2_0.JWTUtil;
import edu.uiuc.ncsa.security.oauth_2_0.OA2RedirectableError;
import edu.uiuc.ncsa.security.oauth_2_0.UserInfo;
import edu.uiuc.ncsa.security.oauth_2_0.client.ATResponse2;
import edu.uiuc.ncsa.security.oauth_2_0.client.ATServer2;
import edu.uiuc.ncsa.security.servlet.JSPUtil;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKey;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import edu.uiuc.ncsa.security.util.pkcs.CertUtil;
import edu.uiuc.ncsa.security.util.pkcs.KeyUtil;
import java.net.URI;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import net.sf.json.util.JSONUtils;
import org.apache.commons.codec.binary.Base64;

public class OA2ReadyServlet
extends ClientServlet {
    protected void doIt(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        if (request.getParameterMap().containsKey("error")) {
            throw new OA2RedirectableError(request.getParameter("error"), request.getParameter("error_description"), request.getParameter("state"));
        }
        this.info("2.a. Getting token and verifier.");
        String token = request.getParameter(OA2ReadyServlet.CONST((String)"oa4mp:token"));
        String state = request.getParameter("state");
        if (token == null) {
            this.warn("2.a. The token is " + (token == null ? "null" : token) + ".");
            GeneralException ge = new GeneralException("Error: This servlet requires parameters for the token and possibly verifier.");
            request.setAttribute("exception", (Object)ge);
            JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)this.getCE().getErrorPagePath());
            return;
        }
        this.info("2.a Token found.");
        OA2ClientEnvironment oa2ce = (OA2ClientEnvironment)this.getCE();
        AuthorizationGrantImpl grant = new AuthorizationGrantImpl(URI.create(token));
        this.info("2.a. Getting the token from the service");
        String identifier = this.clearCookie(request, response);
        OA2Asset asset = null;
        if (identifier == null && (asset = (OA2Asset)this.getCE().getAssetStore().getByToken(BasicIdentifier.newID((String)token))) != null) {
            identifier = asset.getIdentifierString();
        }
        AssetResponse assetResponse = null;
        OA2MPService oa2MPService = (OA2MPService)this.getOA4MPService();
        String rawAT = null;
        UserInfo ui = null;
        boolean getCerts = oa2ce.getScopes().contains("edu.uiuc.ncsa.myproxy.getcert");
        if (identifier == null) {
            String msg = "Error: no cookie found. Cannot save certificates";
            this.warn(msg);
            this.debug("No cookie found");
            ATResponse2 atResponse2 = oa2MPService.getAccessToken(asset, (AuthorizationGrant)grant);
            rawAT = atResponse2.getAccessToken().getToken();
            ui = oa2MPService.getUserInfo(atResponse2.getAccessToken().toString());
            if (getCerts) {
                assetResponse = oa2MPService.getCert(asset, atResponse2);
            }
        } else {
            asset = (OA2Asset)this.getCE().getAssetStore().get(identifier);
            if (asset.getState() == null || !asset.getState().equals(state)) {
                this.warn("The expected state from the server was \"" + asset.getState() + "\", but instead \"" + state + "\" was returned. Transaction aborted.");
                throw new IllegalArgumentException("Error: The state returned by the server is invalid.");
            }
            ATResponse2 atResponse2 = oa2MPService.getAccessToken(asset, (AuthorizationGrant)grant);
            rawAT = atResponse2.getAccessToken().getToken();
            ui = oa2MPService.getUserInfo(identifier);
            if (getCerts) {
                this.info("2.b. Certs requested, retrieving...");
                assetResponse = oa2MPService.getCert(asset, atResponse2);
            }
        }
        ServletDebugUtil.trace((Object)((Object)this), (String)("show ID token? " + oa2ce.isShowIDToken()));
        if (oa2ce.isOidcEnabled() && oa2ce.isShowIDToken()) {
            ATServer2 atServer2 = (ATServer2)oa2ce.getDelegationService().getAtServer();
            JSONWebKeys jsonWebKeys = atServer2.getJsonWebKeys();
            ServletDebugUtil.trace((Object)((Object)this), (String)("JSON webkeys = " + jsonWebKeys));
            ServletDebugUtil.trace((Object)((Object)this), (String)("ID Token store = " + ATServer2.getIDTokenStore()));
            ServletDebugUtil.trace((Object)((Object)this), (String)("ID Token store size = " + ATServer2.getIDTokenStore().size()));
            ServletDebugUtil.trace((Object)((Object)this), (String)("ID Token store contains key \"" + rawAT + "\"? " + ATServer2.getIDTokenStore().containsKey(rawAT)));
            ATServer2.IDTokenEntry tokenEntry = (ATServer2.IDTokenEntry)ATServer2.getIDTokenStore().get(rawAT);
            ServletDebugUtil.trace((Object)((Object)this), (String)("TokenEntry = " + tokenEntry));
            this.setJWTInfo(request, tokenEntry.rawToken, jsonWebKeys);
        } else {
            this.setJWTInfo(request, null, null);
        }
        if (getCerts) {
            if (assetResponse.getX509Certificates() == null) {
                request.setAttribute("certSubject", (Object)"(no cert returned)");
            } else {
                X509Certificate cert = assetResponse.getX509Certificates()[0];
                request.setAttribute("certSubject", (Object)cert.getSubjectDN());
                request.setAttribute("cert", (Object)CertUtil.toPEM((X509Certificate[])assetResponse.getX509Certificates()));
                request.setAttribute("username", (Object)assetResponse.getUsername());
                if (asset.getPrivateKey() != null) {
                    request.setAttribute("privateKey", (Object)KeyUtil.toPKCS1PEM((PrivateKey)asset.getPrivateKey()));
                } else {
                    request.setAttribute("privateKey", (Object)"(none)");
                }
            }
        } else {
            request.setAttribute("certSubject", (Object)"(no cert requested)");
        }
        this.info("2.b. Done! Displaying success page.");
        if (ui != null) {
            String output = JSONUtils.valueToString((Object)ui.toJSon(), (int)1, (int)0);
            request.setAttribute("userinfo", (Object)output);
        } else {
            request.setAttribute("userinfo", (Object)"no user info returned.");
        }
        String contextPath = request.getContextPath();
        if (!contextPath.endsWith("/")) {
            contextPath = contextPath + "/";
        }
        request.setAttribute("action", (Object)contextPath);
        this.info("2.a. Completely finished with delegation.");
        response.setCharacterEncoding("UTF-8");
        JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)this.getCE().getSuccessPagePath());
    }

    protected void setJWTInfo(HttpServletRequest request, String rawJWT, JSONWebKeys jsonWebKeys) {
        if (rawJWT == null || rawJWT.isEmpty()) {
            request.setAttribute("id_token", (Object)"(none)");
        } else {
            String[] atParts = JWTUtil.decat((String)rawJWT);
            String h = atParts[0];
            JSONObject header = null;
            String p = atParts[1];
            header = JSONObject.fromObject((Object)new String(Base64.decodeBase64((String)h)));
            JSONObject payload = JSONObject.fromObject((Object)new String(Base64.decodeBase64((String)p)));
            request.setAttribute("id_token", (Object)rawJWT);
            request.setAttribute("id_payload", (Object)payload.toString(2));
            request.setAttribute("id_header", (Object)header.toString(2));
            JSONWebKey webKey = (JSONWebKey)jsonWebKeys.get(header.get(JWTUtil.KEY_ID));
            String keyPEM = KeyUtil.toX509PEM((PublicKey)webKey.publicKey);
            request.setAttribute("id_public_key", (Object)keyPEM);
        }
    }
}

