/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oauth2.tools;

import edu.uiuc.ncsa.myproxy.oa4mp.server.admin.adminClient.AdminClient;
import edu.uiuc.ncsa.myproxy.oa4mp.server.testing.BaseClientStoreCommands;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.delegation.server.storage.ClientApprovalStore;
import org.apache.commons.codec.digest.DigestUtils;

public class OA2AdminClientCommands
extends BaseClientStoreCommands {
    public OA2AdminClientCommands(MyLoggingFacade logger, String defaultIndent, Store clientStore, ClientApprovalStore clientApprovalStore) {
        super(logger, defaultIndent, clientStore, clientApprovalStore);
    }

    public String getName() {
        return "  admins";
    }

    protected void longFormat(Identifiable identifiable) {
        super.longFormat(identifiable);
        AdminClient client = (AdminClient)identifiable;
        this.sayi("issuer=" + client.getIssuer());
        this.sayi("vo=" + client.getVirtualOrganization());
    }

    public void extraUpdates(Identifiable identifiable) {
        String vo;
        String issuer;
        AdminClient client = (AdminClient)identifiable;
        String secret = client.getSecret();
        boolean askForSecret = true;
        while (askForSecret) {
            String input = this.getInput("enter a new secret or return to skip.", secret);
            if (this.isEmpty(input)) {
                this.sayi("Nothing entered. Client secret entry skipped.");
                break;
            }
            if (input.equals(secret)) {
                this.sayi(" Client secret entry skipped.");
                break;
            }
            secret = DigestUtils.sha1Hex((String)input);
            client.setSecret(secret);
            askForSecret = false;
        }
        if (!this.isEmpty(issuer = this.getInput("Give the issuer", client.getIssuer()))) {
            client.setIssuer(issuer);
        }
        if (!this.isEmpty(vo = this.getInput("Give the VO", client.getVirtualOrganization()))) {
            client.setVirtualOrganization(vo);
        }
    }

    protected void showDeserializeHelp() {
        super.showDeserializeHelp();
        this.say("NOTE that for clients, the assumption is that you are supplying the hashed secret, not the actual secret.");
        this.say("If you need to create a hash of a secret, invoke the create_hash method on the secret");
    }
}

