/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oauth2.tools;

import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.storage.clients.OA2Client;
import edu.uiuc.ncsa.myproxy.oa4mp.server.ClientStoreCommands;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.delegation.server.storage.ClientApproval;
import edu.uiuc.ncsa.security.delegation.server.storage.ClientApprovalStore;
import edu.uiuc.ncsa.security.delegation.storage.BaseClient;
import edu.uiuc.ncsa.security.oauth_2_0.server.config.LDAPConfigurationUtil;
import edu.uiuc.ncsa.security.util.cli.ExitException;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import java.util.StringTokenizer;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;

public class OA2ClientCommands
extends ClientStoreCommands {
    boolean refreshTokensEnabled;
    Collection<String> supportedScopes = null;

    public OA2ClientCommands(MyLoggingFacade logger, String defaultIndent, Store clientStore, ClientApprovalStore clientApprovalStore) {
        super(logger, defaultIndent, clientStore, clientApprovalStore);
    }

    public boolean isRefreshTokensEnabled() {
        return this.refreshTokensEnabled;
    }

    public void setRefreshTokensEnabled(boolean refreshTokensEnabled) {
        this.refreshTokensEnabled = refreshTokensEnabled;
    }

    public Collection<String> getSupportedScopes() {
        return this.supportedScopes;
    }

    public void setSupportedScopes(Collection<String> supportedScopes) {
        this.supportedScopes = supportedScopes;
    }

    protected void longFormat(BaseClient identifiable, ClientApproval clientApproval) {
        OA2Client client = (OA2Client)identifiable;
        this.say("Client name=" + (client.getName() == null ? "(no name)" : client.getName()));
        this.sayi("identifier=" + client.getIdentifier());
        this.sayi("email=" + client.getEmail());
        this.sayi("home uri=" + client.getHomeUri());
        this.sayi("error uri=" + client.getErrorUri());
        this.sayi("limited proxies? " + client.isProxyLimited());
        this.sayi("creation timestamp=" + client.getCreationTS());
        this.sayi("sign ID tokens?=" + client.isSignTokens());
        this.sayi("issuer=" + client.getIssuer());
        this.sayi("is public?=" + client.isPublicClient());
        if (clientApproval == null) {
            clientApproval = (ClientApproval)this.getClientApprovalStore().create();
            clientApproval.setIdentifier(client.getIdentifier());
            clientApproval.setStatus(ClientApproval.Status.PENDING);
            clientApproval.setApproved(false);
            this.getClientApprovalStore().save((Identifiable)clientApproval);
        }
        if (clientApproval.isApproved() && clientApproval.getStatus() != ClientApproval.Status.APPROVED) {
            clientApproval.setStatus(ClientApproval.Status.APPROVED);
        }
        switch (clientApproval.getStatus()) {
            case APPROVED: {
                String approver = "(unknown)";
                if (clientApproval.getApprover() != null) {
                    approver = clientApproval.getApprover();
                }
                this.sayi("status=approved by " + approver);
                break;
            }
            case NONE: {
                this.sayi("status=none");
                break;
            }
            case PENDING: {
                this.sayi("status=pending");
                break;
            }
            case DENIED: {
                this.sayi("status=approval denied");
                break;
            }
            case REVOKED: {
                this.sayi("status=revoked");
            }
        }
        if (client.getSecret() == null) {
            this.sayi("client secret: (none)");
        } else {
            this.sayi("client secret (hash):" + client.getSecret());
        }
        Collection uris = client.getCallbackURIs();
        if (uris == null) {
            this.sayi("callback uris: (none)");
        } else {
            this.sayi("callback uris" + (uris.isEmpty() ? ":(none)" : ":"));
            for (Object x : uris) {
                this.sayi("      " + (String)x);
            }
        }
        Collection scopes = client.getScopes();
        if (scopes == null) {
            this.sayi("scopes: (none)");
        } else {
            this.sayi("scopes" + (scopes.isEmpty() ? ":(none)" : ":"));
            for (String x : scopes) {
                this.sayi("      " + x);
            }
        }
        if (this.isRefreshTokensEnabled()) {
            this.sayi("refresh lifetime (sec): " + (client.isRTLifetimeEnabled() ? Long.valueOf(client.getRtLifetime() / 1000L) : "none"));
        }
        if (client.getLdaps() == null || client.getLdaps().isEmpty()) {
            this.sayi("ldap:(none configured.)");
        } else {
            this.sayi("LDAPS (warning-deprecated, use the config instead):");
            LDAPConfigurationUtil ldapConfigurationUtil = new LDAPConfigurationUtil();
            this.say(ldapConfigurationUtil.toJSON(client.getLdaps()).toString(2));
        }
        if (client.getConfig() == null || client.getConfig().isEmpty()) {
            this.sayi("config:(none)");
        } else {
            this.sayi("config:");
            this.sayi(client.getConfig().toString(2));
        }
    }

    public void extraUpdates(Identifiable identifiable) {
        JSONObject newConfig;
        String uris;
        String scopes;
        String signTokens;
        boolean publicClient;
        String rawPC;
        OA2Client client = (OA2Client)identifiable;
        String secret = client.getSecret();
        boolean askForSecret = true;
        while (askForSecret) {
            String input = this.getInput("enter a new secret or return to skip.", secret);
            if (this.isEmpty(input)) {
                this.sayi("Nothing entered. Client secret entry skipped.");
                break;
            }
            if (input.equals(secret)) {
                this.sayi(" Client secret entry skipped.");
                break;
            }
            secret = DigestUtils.sha1Hex((String)input);
            client.setSecret(secret);
            askForSecret = false;
        }
        OA2Client oa2Client = (OA2Client)identifiable;
        if (this.isRefreshTokensEnabled()) {
            String NONE = "none";
            String rtString = oa2Client.isRTLifetimeEnabled() ? Long.toString(oa2Client.getRtLifetime() / 1000L) : NONE;
            String rawLifetime = this.getInput("enter the refresh lifetime in ms.", rtString);
            if (rawLifetime == null || rawLifetime.length() == 0 || rawLifetime.toLowerCase().equals(NONE)) {
                oa2Client.setRtLifetime(0L);
            } else {
                try {
                    oa2Client.setRtLifetime(Long.parseLong(rawLifetime));
                }
                catch (Throwable t) {
                    this.sayi("Sorry but \"" + rawLifetime + "\" is not a valid number. No change.");
                }
            }
        }
        if ((rawPC = this.getInput("is this client public?", Boolean.toString(publicClient = oa2Client.isPublicClient()))) != null && rawPC.toLowerCase().equalsIgnoreCase("y") || rawPC.toLowerCase().equalsIgnoreCase("yes")) {
            rawPC = "true";
        }
        try {
            boolean x = Boolean.parseBoolean(rawPC);
            oa2Client.setPublicClient(x);
        }
        catch (Throwable t) {
            this.sayi("Sorry, but unable to parse the response of \"" + rawPC + "\". No change.");
        }
        String issuer = this.getInput("enter the issuer (optional)", oa2Client.getIssuer());
        if (!this.isEmpty(issuer)) {
            oa2Client.setIssuer(issuer);
        }
        if (!this.isEmpty(signTokens = this.getInput("Enable ID token signing (true/false)?", Boolean.toString(oa2Client.isSignTokens())))) {
            try {
                oa2Client.setSignTokens(Boolean.parseBoolean(signTokens));
            }
            catch (Throwable t) {
                this.sayi("Unknown response of \"" + signTokens + "\". Must be \"true\" or \"false\", ignoring.");
            }
        }
        String currentScopes = null;
        if (oa2Client.getScopes() != null) {
            boolean firstPass = true;
            for (String x : oa2Client.getScopes()) {
                if (firstPass) {
                    firstPass = false;
                    currentScopes = x;
                    continue;
                }
                currentScopes = currentScopes + "," + x;
            }
        }
        if ((scopes = this.getInput("enter a comma separated list of scopes. Scopes to this server will be rejected.", currentScopes)) != null && !scopes.isEmpty()) {
            LinkedList<Object> list = new LinkedList<Object>();
            StringTokenizer stringTokenizer = new StringTokenizer(scopes, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String raw = stringTokenizer.nextToken().trim();
                if (this.getSupportedScopes().contains(raw)) {
                    list.add(raw);
                    continue;
                }
                this.say("Unknown scope \"" + (String)raw + "\" rejected.");
            }
            oa2Client.setScopes(list);
        }
        String currentUris = null;
        if (oa2Client.getCallbackURIs() != null) {
            boolean firstPass = true;
            for (String x : oa2Client.getCallbackURIs()) {
                if (firstPass) {
                    firstPass = false;
                    currentUris = x;
                    continue;
                }
                currentUris = currentUris + "," + x;
            }
        }
        if (!(uris = this.getInput("enter a comma separated list of callback uris. These must start with https or they will be ignored.", currentUris)).isEmpty()) {
            LinkedList<String> list = new LinkedList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(uris, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String raw = stringTokenizer.nextToken().trim();
                try {
                    URI uri = URI.create(raw);
                    if (uri.getScheme().toLowerCase().equals("https")) {
                        list.add(raw);
                        continue;
                    }
                    this.sayi("\"" + raw + "\" rejected -- illegal protocol");
                }
                catch (Throwable t) {
                    this.sayi("\"" + raw + "\" rejected -- illegal uri");
                }
            }
            oa2Client.setCallbackURIs(list);
        }
        JSONArray currentLDAPs = null;
        LDAPConfigurationUtil ldapConfigurationUtil = new LDAPConfigurationUtil();
        currentLDAPs = client.getLdaps() == null || client.getLdaps().isEmpty() ? null : ldapConfigurationUtil.toJSON(client.getLdaps());
        JSONArray newLDAPS = (JSONArray)this.inputJSON((JSON)currentLDAPs, "ldap configuration", true);
        if (newLDAPS != null) {
            client.setLdaps(ldapConfigurationUtil.fromJSON(newLDAPS));
        }
        if ((newConfig = (JSONObject)this.inputJSON((JSON)client.getConfig(), "client configuration")) != null) {
            client.setConfig(newConfig);
        }
    }

    protected JSON inputJSON(JSON oldJSON, String componentName) {
        return this.inputJSON(oldJSON, componentName, false);
    }

    protected JSON inputJSON(JSON oldJSON, String componentName, boolean isArray) {
        if (oldJSON == null) {
            this.sayi("no current value for " + componentName);
        } else {
            this.sayi("current value for " + componentName + ":");
            this.say(oldJSON.toString(2));
        }
        this.sayi("Enter new JSON value. An empty line terminates input. Entering a line with /exit will terminate input too.\n Hitting /clear will clear the contents of this.");
        String rawJSON = "";
        boolean redo = true;
        while (redo) {
            try {
                String inLine = this.readline();
                while (!this.isEmpty(inLine)) {
                    if (inLine.equals("/clear")) {
                        if (isArray) {
                            return new JSONArray();
                        }
                        return new JSONObject();
                    }
                    rawJSON = rawJSON + inLine;
                    inLine = this.readline();
                }
            }
            catch (ExitException x) {
                return null;
            }
            if (rawJSON.isEmpty()) {
                return null;
            }
            try {
                Object json = null;
                json = isArray ? JSONArray.fromObject((Object)rawJSON) : JSONObject.fromObject((Object)rawJSON);
                this.sayi("Success! JSON is valid.");
                return json;
            }
            catch (Throwable t) {
                this.sayi("uh-oh... It seems this was not a valid JSON object. The parser message reads:\"" + t.getMessage() + "\"");
                redo = this.isOk(this.getInput("Try to re-enter this?", "true"));
            }
        }
        return null;
    }

    protected void showDeserializeHelp() {
        super.showDeserializeHelp();
        this.say("NOTE that for clients, the assumption is that you are supplying the hashed secret, not the actual secret.");
        this.say("If you need to create a hash of a secret, invoke the create_hash method on the secret");
    }

    public OA2ClientCommands(MyLoggingFacade logger, Store store) {
        super(logger, store);
    }
}

