/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oauth2.tools;

import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.OA2SE;
import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.loader.OA2ConfigurationLoader;
import edu.uiuc.ncsa.myproxy.oa4mp.server.BaseCommands;
import edu.uiuc.ncsa.myproxy.oa4mp.server.ClientStoreCommands;
import edu.uiuc.ncsa.myproxy.oa4mp.server.CopyCommands;
import edu.uiuc.ncsa.myproxy.oa4mp.server.CopyTool;
import edu.uiuc.ncsa.myproxy.oa4mp.server.CopyToolVerifier;
import edu.uiuc.ncsa.myproxy.oauth2.tools.OA2AdminClientCommands;
import edu.uiuc.ncsa.myproxy.oauth2.tools.OA2ClientCommands;
import edu.uiuc.ncsa.myproxy.oauth2.tools.OA2CopyTool;
import edu.uiuc.ncsa.myproxy.oauth2.tools.OA2CopyToolVerifier;
import edu.uiuc.ncsa.myproxy.oauth2.tools.OA2PermissionCommands;
import edu.uiuc.ncsa.myproxy.oauth2.tools.SigningCommands;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.ConfigurationLoader;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.util.cli.CLIDriver;
import edu.uiuc.ncsa.security.util.cli.Commands;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import org.apache.commons.lang.StringUtils;

public class OA2Commands
extends BaseCommands {
    public static final String PERMISSIONS = "permissions";
    public static final String ADMINS = "admins";
    public static final String KEYS = "keys";

    public OA2Commands(MyLoggingFacade logger) {
        super(logger);
    }

    public String getPrompt() {
        return "oa2>";
    }

    public ConfigurationLoader<? extends AbstractEnvironment> getLoader() {
        return new OA2ConfigurationLoader(this.getConfigurationNode(), this.getMyLogger());
    }

    OA2SE getOA2SE() throws Exception {
        return (OA2SE)this.getServiceEnvironment();
    }

    public static void main(String[] args) {
        try {
            OA2Commands oa2Commands = new OA2Commands(null);
            oa2Commands.start(args);
            CLIDriver cli = new CLIDriver(new Commands[]{oa2Commands});
            cli.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void useHelp() {
        this.say("Choose the component you wish to use.");
        this.say("you specify the component as use + name. Supported components are");
        this.say("clients - edit client records");
        this.say("approvals - edit client approval records\n");
        this.say("copy - copy an entire store.\n");
        this.say("keys - create a set of signing keys.\n");
        this.say("permissions - basic permission management.\n");
        this.say("admins - create or manage administrative clients.\n");
        this.say("e.g.\n\nuse clients\n\nwill call up the client management component.");
        this.say("Type 'exit' when you wish to exit the component and return to the main menu");
    }

    public void about() {
        int width = 60;
        String stars = StringUtils.rightPad((String)"", (int)(width + 1), (String)"*");
        this.say(stars);
        this.say(this.padLineWithBlanks("* OA4MP2 OAuth 2/OIDC CLI (Command Line Interpreter)", width) + "*");
        this.say(this.padLineWithBlanks("* Version 4.1", width) + "*");
        this.say(this.padLineWithBlanks("* By Jeff Gaynor  NCSA", width) + "*");
        this.say(this.padLineWithBlanks("*  (National Center for Supercomputing Applications)", width) + "*");
        this.say(this.padLineWithBlanks("*", width) + "*");
        this.say(this.padLineWithBlanks("* type 'help' for a list of commands", width) + "*");
        this.say(this.padLineWithBlanks("*      'exit' or 'quit' to end this session.", width) + "*");
        this.say(stars);
    }

    public ClientStoreCommands getNewClientStoreCommands() throws Exception {
        OA2ClientCommands x = new OA2ClientCommands(this.getMyLogger(), "  ", (Store)this.getServiceEnvironment().getClientStore(), this.getServiceEnvironment().getClientApprovalStore());
        x.setRefreshTokensEnabled(this.getOA2SE().isRefreshTokenEnabled());
        x.setSupportedScopes(this.getOA2SE().getScopes());
        return x;
    }

    public CopyCommands getNewCopyCommands() throws Exception {
        return new CopyCommands(this.getMyLogger(), (CopyTool)new OA2CopyTool(), (CopyToolVerifier)new OA2CopyToolVerifier(), this.getConfigFile());
    }

    public OA2AdminClientCommands getAdminClientCommands() throws Exception {
        return new OA2AdminClientCommands(this.getMyLogger(), "  ", (Store)this.getOA2SE().getAdminClientStore(), this.getOA2SE().getClientApprovalStore());
    }

    public OA2PermissionCommands getPermissionCommands() throws Exception {
        return new OA2PermissionCommands(this.getMyLogger(), "  ", (Store)this.getOA2SE().getPermissionStore());
    }

    public boolean use(InputLine inputLine) throws Exception {
        Object commands = null;
        if (inputLine.hasArg(ADMINS)) {
            commands = this.getAdminClientCommands();
        }
        if (inputLine.hasArg(KEYS)) {
            commands = new SigningCommands(this.getOA2SE());
        }
        if (inputLine.hasArg(PERMISSIONS)) {
            commands = this.getPermissionCommands();
        }
        if (commands != null) {
            CLIDriver cli = new CLIDriver(new Commands[]{commands});
            cli.start();
            return true;
        }
        return super.use(inputLine);
    }
}

