/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oauth2.tools;

import edu.uiuc.ncsa.myproxy.oa4mp.server.StoreCommands2;
import edu.uiuc.ncsa.myproxy.oa4mp.server.admin.permissions.Permission;
import edu.uiuc.ncsa.myproxy.oa4mp.server.admin.permissions.PermissionsStore;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;

public class OA2PermissionCommands
extends StoreCommands2 {
    public OA2PermissionCommands(MyLoggingFacade logger, String defaultIndent, Store store) {
        super(logger, defaultIndent, store);
    }

    public OA2PermissionCommands(MyLoggingFacade logger, Store store) {
        super(logger, store);
    }

    protected PermissionsStore getPStore() {
        return (PermissionsStore)this.getStore();
    }

    public void extraUpdates(Identifiable identifiable) {
    }

    public String getName() {
        return "permissions";
    }

    protected String format(Identifiable identifiable) {
        Permission p = (Permission)identifiable;
        String output = "Permission: admin=" + p.getAdminID() + ", client=" + p.getClientID() + ", id=" + p.getIdentifierString();
        return output;
    }

    public boolean update(Identifiable identifiable) {
        Permission p = (Permission)identifiable;
        String input = p.getClientID() == null ? this.getInput("Enter new client id", "") : this.getInput("Enter new client id", p.getClientID().toString());
        if (!this.isEmpty(input)) {
            p.setClientID(BasicIdentifier.newID((String)input));
        }
        if (!this.isEmpty(input = p.getAdminID() == null ? this.getInput("Enter new admin id", "") : this.getInput("Enter new admin id", p.getAdminID().toString()))) {
            p.setAdminID(BasicIdentifier.newID((String)input));
        }
        if (!this.isEmpty(input = this.getInput("set all permissions (y/n):", "y"))) {
            if (input.toLowerCase().equals("y")) {
                p.setApprove(true);
                p.setCreate(true);
                p.setDelete(true);
                p.setRead(true);
                p.setWrite(true);
            } else {
                p.setApprove(false);
                p.setCreate(false);
                p.setDelete(false);
                p.setRead(false);
                p.setWrite(false);
            }
        }
        return false;
    }

    protected void longFormat(Identifiable identifiable) {
        Permission p = (Permission)identifiable;
        this.sayi("client id=" + p.getClientID());
        this.sayi("admin id=" + p.getAdminID());
        this.sayi("can approve?=" + p.isApprove());
        this.sayi("can read?=" + p.isRead());
        this.sayi("can write?=" + p.isWrite());
        this.sayi("can delete?=" + p.isDelete());
        this.sayi("can create?=" + p.isCreate());
    }
}

