/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oauth2.tools;

import edu.uiuc.ncsa.myproxy.oa4mp.client.AssetResponse;
import edu.uiuc.ncsa.myproxy.oa4mp.client.ClientEnvironment;
import edu.uiuc.ncsa.myproxy.oa4mp.client.OA4MPResponse;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetStoreUtil;
import edu.uiuc.ncsa.myproxy.oa4mp.server.testing.TestCommands;
import edu.uiuc.ncsa.oa4mp.oauth2.client.OA2Asset;
import edu.uiuc.ncsa.oa4mp.oauth2.client.OA2MPService;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.DateUtils;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.delegation.client.request.RTResponse;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import edu.uiuc.ncsa.security.delegation.token.impl.AuthorizationGrantImpl;
import edu.uiuc.ncsa.security.oauth_2_0.UserInfo;
import edu.uiuc.ncsa.security.oauth_2_0.client.ATResponse2;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import edu.uiuc.ncsa.security.util.pkcs.CertUtil;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import net.sf.json.JSONObject;

public class OA2TestCommands
extends TestCommands {
    protected OA2MPService service;
    SecureRandom secureRandom = new SecureRandom();
    static String encoding = "UTF-8";
    AuthorizationGrant grant;
    boolean canGetGrant = false;
    boolean canGetAT = false;
    boolean canGetCert = false;
    boolean canGetRT = false;
    OA2Asset dummyAsset;
    String rawIdToken = null;
    JSONObject claims = null;
    ATResponse2 currentATResponse;
    AssetResponse assetResponse = null;
    public static final String CLAIMS_FLAG = "-claims";

    public OA2TestCommands(MyLoggingFacade logger, ClientEnvironment ce) {
        super(logger, ce);
    }

    protected OA2MPService getOA2S() {
        return this.getService();
    }

    public OA2MPService getService() {
        if (this.service == null) {
            this.service = new OA2MPService(this.getCe());
        }
        return this.service;
    }

    public void getURIHelp() {
        this.say("Usage: This will create the correct URL to pass to your browser.");
        this.say("       This URL should be pasted exactly into the location bar.");
        this.say("       You must then authenticate. After you authenticate, the");
        this.say("       service will attempt a call back to a client endpoint which will");
        this.say("       fail (this is the hook that lets us do this manually).");
        this.say("       Next Step: You should invoke setgrant with the callback uri from the server.");
    }

    protected String getRandomString() {
        long ll = this.secureRandom.nextLong();
        return Long.toHexString(ll);
    }

    public void geturi(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.getURIHelp();
            return;
        }
        Identifier id = AssetStoreUtil.createID();
        OA4MPResponse resp = this.getService().requestCert(id);
        this.dummyAsset = (OA2Asset)this.getCe().getAssetStore().get(id.toString());
        this.say(resp.getRedirect().toString());
    }

    protected String createURI(String base, HashMap<String, String> args) throws UnsupportedEncodingException {
        String uri = base;
        boolean firstPass = true;
        for (String key : args.keySet()) {
            String value = args.get(key);
            uri = uri + (firstPass ? "?" : "&") + key + "=" + this.encode(value);
            if (!firstPass) continue;
            firstPass = false;
        }
        this.canGetGrant = true;
        return uri;
    }

    String encode(String x) throws UnsupportedEncodingException {
        if (x == null) {
            return "";
        }
        return URLEncoder.encode(x, encoding);
    }

    String decode(String x) throws UnsupportedEncodingException {
        if (x == null) {
            return "";
        }
        return URLDecoder.decode(x, encoding);
    }

    public void setgrant(InputLine inputLine) throws Exception {
        if (inputLine.size() != 2 || this.showHelp(inputLine)) {
            this.setGrantHelp();
            return;
        }
        String x = inputLine.getArg(1);
        if (!x.startsWith(this.getCe().getCallback().toString())) {
            this.say("The callback in the configuration does not match that in the argument you gave");
            return;
        }
        String args = x.substring(x.indexOf("?") + 1);
        StringTokenizer st = new StringTokenizer(args, "&");
        while (st.hasMoreTokens()) {
            String current = st.nextToken();
            if (!current.startsWith("code=")) continue;
            URI uri = URI.create(this.decode(current.substring(5)));
            this.say("grant=" + uri.toString());
            this.grant = new AuthorizationGrantImpl(uri);
        }
    }

    public OA2Asset getDummyAsset() {
        return this.dummyAsset;
    }

    public void clear(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.getClearHelp();
            return;
        }
        this.dummyAsset = null;
        this.assetResponse = null;
        this.currentATResponse = null;
        this.grant = null;
        this.rawIdToken = null;
        this.claims = null;
        this.canGetCert = false;
        this.canGetGrant = false;
        this.canGetRT = false;
        this.canGetAT = false;
    }

    protected void getClearHelp() {
        this.say("clear: reset all internal state and restart. You should do this rather than just starting over");
        this.say("       as you may run into old state.");
    }

    protected void saveCertHelp() {
        this.say("savecert filename");
        this.say("This will save the cert (be sure to do a getcert call first so you have one) to the");
        this.say("fully qualified filename");
        this.say("If there is no cert available, no file will be written, but a message will be printed.");
    }

    public void savecert(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.saveCertHelp();
            return;
        }
        if (this.assetResponse == null) {
            this.say("Sorry, but there is no cert to save. Please do a successful getcert call first.");
            return;
        }
        String cert = CertUtil.toPEM((X509Certificate[])this.assetResponse.getX509Certificates());
        if (!inputLine.hasArgs()) {
            this.say("Sorry. You did not specify a file so the cert cannot be saved.");
            return;
        }
        String fileName = inputLine.getArg(1);
        FileWriter fileWriter = new FileWriter(fileName);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        bufferedWriter.write(cert + "\n");
        bufferedWriter.flush();
        bufferedWriter.close();
        this.say("File \"" + fileName + "\" saved successfully.");
    }

    protected void showRawTokenHelp() {
        this.sayi("showRawToken - This will show the raw id token, i.e., the JWT. ");
        this.sayi("               If you wish to see the contents of this JWT");
        this.sayi("               you should probably invoke showClaims instead.");
    }

    public void showrawtoken(InputLine inputLine) throws Exception {
        if (this.grant == null || this.showHelp(inputLine)) {
            this.getATHelp();
            return;
        }
        if (this.rawIdToken == null) {
            this.sayi("No id token.");
            return;
        }
        if (this.rawIdToken.length() == 0) {
            this.sayi("Empty id token");
            return;
        }
        this.sayi(this.rawIdToken);
    }

    public void showclaims(InputLine inputLine) throws Exception {
        if (this.grant == null || this.showHelp(inputLine)) {
            this.showClaimsHelp();
            return;
        }
        if (this.claims == null || this.claims.isEmpty()) {
            this.say("(no claims found)");
        } else {
            this.say(this.claims.toString(2));
        }
    }

    protected void showClaimsHelp() {
        this.sayi("showClaims - This will show the most recent set of claims. You must get an access token");
        this.sayi("             before this is set.");
        this.sayi("             You may also see the raw version of this (simply the JWT) by calling showRawToken.");
    }

    public void getat(InputLine inputLine) throws Exception {
        if (this.grant == null || this.showHelp(inputLine)) {
            this.getATHelp();
            return;
        }
        this.currentATResponse = this.getOA2S().getAccessToken(this.getDummyAsset(), this.grant);
        Object x = this.currentATResponse.getParameters().get("raw_id_token");
        if (x == null) {
            x = "";
        } else {
            this.rawIdToken = x.toString();
        }
        this.claims = (JSONObject)this.currentATResponse.getParameters().get("id_token");
        if (inputLine.hasArg(CLAIMS_FLAG)) {
            if (this.claims.isEmpty()) {
                this.say("(no claims found)");
            } else {
                this.say(this.claims.toString(2));
            }
        }
        this.printTokens();
    }

    protected void getCertHelp() {
        this.say("getcert: This will get the requested cert chain from the server.");
    }

    protected void getUIHelp() {
        this.say("getuserinfo: This will get the user info from the server. You must have already authenticated");
        this.say("             *and* gotten a valid access token by this point. Just a list of these it printed.");
        this.say("             What is returned is dependant upon what the server supports.");
    }

    public void getuserinfo(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.getUIHelp();
            return;
        }
        UserInfo userInfo = this.getOA2S().getUserInfo(this.dummyAsset.getIdentifier().toString());
        this.say("user info:");
        for (String key : userInfo.getMap().keySet()) {
            this.say("          " + key + " = " + userInfo.getMap().get(key));
        }
    }

    public void getcert(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.getCertHelp();
            return;
        }
        this.assetResponse = this.getOA2S().getCert(this.dummyAsset, this.currentATResponse);
        if (this.assetResponse.getUsername() != null) {
            this.say("returned username=" + this.assetResponse.getUsername());
        }
        this.say("X509Certs:");
        this.say(CertUtil.toPEM((X509Certificate[])this.assetResponse.getX509Certificates()));
    }

    protected void getRTHelp() {
        this.say("getrt [-claims]:");
        this.say("       Get a new refresh token. You must have already called getat to have gotten an access token");
        this.say("       first. This will print out a summary of the expiration time.");
        this.say("       If the -claims flag is supplied, the id token will be printed");
    }

    protected void printTokens() {
        if (this.dummyAsset.getAccessToken() != null) {
            this.say(" access token = " + this.dummyAsset.getAccessToken().getToken());
        }
        if (this.dummyAsset.getRefreshToken() != null) {
            this.say("refresh token = " + this.dummyAsset.getRefreshToken().getToken());
            this.say("RT expires in = " + this.dummyAsset.getRefreshToken().getExpiresIn() + " ms.");
            Date startDate = DateUtils.getDate((String)this.dummyAsset.getRefreshToken().getToken());
            startDate.setTime(startDate.getTime() + this.dummyAsset.getRefreshToken().getExpiresIn());
            this.say("   expires at " + startDate);
        }
    }

    public void getrt(InputLine inputLine) throws Exception {
        JSONObject json;
        if (this.showHelp(inputLine)) {
            this.getRTHelp();
            return;
        }
        RTResponse rtResponse = this.getOA2S().refresh(this.dummyAsset.getIdentifier().toString());
        this.dummyAsset = (OA2Asset)this.getCe().getAssetStore().get(this.dummyAsset.getIdentifier().toString());
        this.currentATResponse = new ATResponse2(this.dummyAsset.getAccessToken(), this.dummyAsset.getRefreshToken());
        this.currentATResponse.setParameters(rtResponse.getParameters());
        this.claims = json = JSONObject.fromObject((Object)this.currentATResponse.getParameters());
        if (inputLine.hasArg(CLAIMS_FLAG)) {
            if (json.isEmpty()) {
                this.say("(no claims found)");
            } else {
                this.say(json.toString(2));
            }
        }
        this.printTokens();
    }

    protected void getATHelp() {
        this.say("getat [-claims]:");
        this.say("       Gets the access token and refresh token (if supported on the server) for a given grant. ");
        this.say("       Your argument is the output from the setgrant call here.");
        this.say("       A summary of the refresh token and its expiration is printed, if applicable.");
        this.say("       If the --claims flag is supplied, the id token will be printed");
    }

    protected void setGrantHelp() {
        this.say("setgrant: The assumption is that you use geturi to get the correct authorization uri and have ");
        this.say("          logged in. Your browser *should* have a call back to your client. Cut and paste that");
        this.say("          as the argument to this call. This will return a string with the grant in it. You can use");
        this.say("          that to get an access token.");
    }
}

