/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oauth2.tools;

import edu.uiuc.ncsa.myproxy.oauth2.tools.SciTokensCommands;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.ConfigurationLoader;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.util.cli.CLIDriver;
import edu.uiuc.ncsa.security.util.cli.Commands;
import edu.uiuc.ncsa.security.util.cli.CommonCommands;
import edu.uiuc.ncsa.security.util.cli.ConfigurableCommandsImpl;
import org.apache.commons.lang.StringUtils;

public class SciTokensCLI
extends ConfigurableCommandsImpl {
    public SciTokensCLI(MyLoggingFacade logger) {
        super(logger);
    }

    public void about() {
        int width = 60;
        String stars = StringUtils.rightPad((String)"", (int)(width + 1), (String)"*");
        this.say(stars);
        this.say(this.padLineWithBlanks("* SciTokens CLI (Command Line Interpreter)", width) + "*");
        this.say(this.padLineWithBlanks("* Version 4.1", width) + "*");
        this.say(this.padLineWithBlanks("* By Jeff Gaynor  NCSA", width) + "*");
        this.say(this.padLineWithBlanks("*  (National Center for Supercomputing Applications)", width) + "*");
        this.say(this.padLineWithBlanks("*", width) + "*");
        this.say(this.padLineWithBlanks("* type 'help' for a list of commands", width) + "*");
        this.say(this.padLineWithBlanks("*      'exit' or 'quit' to end this session.", width) + "*");
        this.say(stars);
    }

    public ConfigurationLoader<? extends AbstractEnvironment> getLoader() {
        return null;
    }

    public String getPrompt() {
        return "sciTokens>";
    }

    public String getComponentName() {
        return null;
    }

    public void useHelp() {
        this.say("You may use this in both interactive mode and as a command line utility.");
        this.say("To use in batch mode, supply the " + CommonCommands.BATCH_MODE_FLAG + " flag.");
        this.say("This will suppress all output and will not prompt for missing arguments to functions.");
        this.say("If you omit this flag, then missing arguments will still cause you to be prompted.");
        this.say("Here is a list of commands:");
        this.say("create_claims");
        this.say("create_token");
        this.say("list_key_ids");
        this.say("list_keys");
        this.say("parse_claims");
        this.say("print_token");
        this.say("To get a full explination of the command and its syntax, type \"command --help \", e.g. ");
        this.say("java -jar scitokens.jar -batch create_keys -- help");
        this.say("  create_keys filename: This will create a JWK file and the corresponding public and private key files in pem format.");
        this.say("                        when this is done, the following files will be create filename.jwk, filename-public.pem and                        filename-private.pem. At this point only 512 bit signing is supported.");
        this.say("                        NOTE: the pem files are supplied so you can use them with other applications. This only uses the .jwk file");
        this.say("  set_key filename: This will set the signing and validation key from the given file");
        this.say("  sign string: This creates an id token from the given string.");
        this.say("  -");
        this.say("Type 'exit' when you wish to exit the component and return to the main menu");
    }

    public static void main(String[] args) {
        SciTokensCLI oa2Commands = new SciTokensCLI(null);
        SciTokensCommands sciTokensCommands = new SciTokensCommands(null);
        try {
            CLIDriver cli = new CLIDriver(new Commands[]{sciTokensCommands});
            if (args == null || args.length == 0) {
                cli.start();
                return;
            }
            sciTokensCommands.setBatchMode(false);
            if (args[0].equalsIgnoreCase("--help")) {
                oa2Commands.useHelp();
                return;
            }
            String cmdLine = args[0];
            for (int i = 1; i < args.length; ++i) {
                if (args[i].equals(CommonCommands.BATCH_MODE_FLAG)) {
                    sciTokensCommands.setBatchMode(true);
                    continue;
                }
                cmdLine = cmdLine + " " + args[i];
            }
            cli.execute(cmdLine);
        }
        catch (Throwable t) {
            if (sciTokensCommands.isBatchMode()) {
                System.exit(1);
            }
            t.printStackTrace();
        }
    }

    protected void start(String[] args) throws Exception {
        this.about();
        if (!this.getOptions(args)) {
            this.say("Warning: no configuration file specified. type in 'load --help' to see how to load one.");
            return;
        }
    }
}

