/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oauth2.tools;

import edu.uiuc.ncsa.myproxy.oauth2.tools.SigningCommands;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.oauth_2_0.JWTUtil;
import edu.uiuc.ncsa.security.servlet.ServiceClient;
import edu.uiuc.ncsa.security.util.cli.CommonCommands;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKey;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeyUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import edu.uiuc.ncsa.security.util.pkcs.KeyUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URI;
import java.security.PublicKey;
import java.util.StringTokenizer;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;

public class SciTokensCommands
extends CommonCommands {
    public static String JWK_EXTENSION = "jwk";
    JSONWebKeys keys = null;
    String wellKnown = null;
    String defaultKeyID = null;
    String lastToken = null;

    public SciTokensCommands(MyLoggingFacade logger) {
        super(logger);
    }

    public String getPrompt() {
        return "sciTokens>";
    }

    public void create_keys(InputLine inputLine) throws Exception {
        SigningCommands sg = new SigningCommands(null);
        sg.create(inputLine);
    }

    public void set_well_known(InputLine inputLine) throws Exception {
    }

    protected void setKeysHelp() {
        this.say("set_keys: [-file filename | uri]");
        this.say("          Set the keys used for signing and validation in this session.");
        this.say("          Either supplied a fully qualified path to the file or a uri. If you pass nothing");
        this.say("          prompted for a file. You can invoke this at any to change the keys.");
        this.say("  Related: create_keys");
    }

    public void set_keys(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.setKeysHelp();
            return;
        }
        if (inputLine.hasArg("-file")) {
            File f = new File(inputLine.getArg(1));
            if (!f.exists()) {
                this.say("Sorry, the file you specified, \"" + inputLine.getArg(1) + "\" does not exist.");
                return;
            }
            this.keys = this.readKeys(f);
            if (this.defaultKeyID != null && this.keys.containsKey((Object)this.defaultKeyID)) {
                this.keys.setDefaultKeyID(this.defaultKeyID);
            }
        } else {
            this.wellKnown = inputLine.getArg(1);
            try {
                this.keys = JWTUtil.getJsonWebKeys((ServiceClient)new ServiceClient(URI.create("https://scitokens.org")), (String)this.wellKnown);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw t;
            }
        }
    }

    protected JSONWebKeys readKeys(File file) throws Exception {
        return JSONWebKeyUtil.fromJSON((File)file);
    }

    protected void say(String x) {
        if (!this.isBatchMode()) {
            super.say(x);
        }
    }

    protected void listKeysHelp() {
        this.say("list_keys:This will list all the public keys in the key file in pem format.");
        this.say("           Each key will be preceeded by its unique ID in the key file.");
        this.say("           You may invoke this with no argument, in which case the default key file");
        this.say("           as set in the set_keys command will be used, or you can supply a fully qualified");
        this.say("           path to a JSON web key file that will be used.");
        this.say("  Related: set_keys, create_keys");
    }

    protected String readFile(String filename) throws Exception {
        File f = new File(filename);
        if (!f.exists()) {
            return null;
        }
        FileReader fr = new FileReader(f);
        BufferedReader br = new BufferedReader(fr);
        String output = "";
        String currentLine = br.readLine();
        while (currentLine != null) {
            output = output + currentLine;
            currentLine = br.readLine();
        }
        br.close();
        return output;
    }

    public void list_keys(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.listKeysHelp();
            return;
        }
        JSONWebKeys localKeys = null;
        if (1 == inputLine.size()) {
            if (this.keys == null || this.keys.isEmpty()) {
                this.say("Sorry, there are no keys specified. Either use setkeys or specify a key file.");
                return;
            }
            localKeys = this.keys;
        } else {
            File publicKeyFile = new File(inputLine.getArg(1));
            localKeys = this.readKeys(publicKeyFile);
        }
        boolean hasDefault = localKeys.hasDefaultKey();
        String defaultKey = null;
        if (hasDefault) {
            defaultKey = localKeys.getDefaultKeyID();
        }
        for (String key : localKeys.keySet()) {
            if (hasDefault) {
                if (key.equals(defaultKey)) {
                    this.say("key id=" + key + " (default)");
                } else {
                    this.say("key id=" + key);
                }
            } else {
                this.say("key id=" + key);
            }
            this.say(KeyUtil.toX509PEM((PublicKey)((JSONWebKey)localKeys.get((Object)key)).publicKey));
        }
    }

    protected void printCreateClaimsHelp() {
        this.say("create_claims: Prompt the user for key/value pairs and build a claims object. ");
        this.say("               This will write the object to a file for future use.");
        this.say("");
        this.say("Related: parse_claims");
    }

    public void create_claims(InputLine inputLine) throws Exception {
        String overwrite;
        String fileName;
        File f;
        this.say("Enter a key then a value when prompted. You can enter multiple values separated by commas");
        this.say("Just hit return (no value) to exit");
        boolean isDone = false;
        JSONObject jsonObject = new JSONObject();
        while (!isDone) {
            String key = this.getInput("Enter key or return to exit.");
            if (this.isEmpty(key)) {
                isDone = true;
                continue;
            }
            String value = this.getInput("Enter value. multiple values should be comma separated");
            if (0 < value.indexOf(",")) {
                StringTokenizer st = new StringTokenizer(value, ",");
                JSONArray array = new JSONArray();
                while (st.hasMoreTokens()) {
                    array.add((Object)st.nextToken());
                }
                jsonObject.put((Object)key, (Object)array);
                continue;
            }
            jsonObject.put((Object)key, (Object)value);
        }
        this.say(jsonObject.toString());
        String writeToFile = this.getInput("Would you like to write this to a file?", "false");
        Boolean isWrite = Boolean.parseBoolean(writeToFile);
        if (!isWrite.booleanValue() || !(f = new File(fileName = this.getInput("Enter filename"))).exists() || Boolean.parseBoolean(overwrite = this.getInput("This file exists. Do you want to overwrite it?", "false"))) {
            // empty if block
        }
    }

    protected boolean getBooleanInput(String prompt) {
        String x = this.getInput(prompt, "y");
        return x.equalsIgnoreCase("y") || x.equalsIgnoreCase("yes") || x.equalsIgnoreCase("true");
    }

    protected String getInput(String prompt) {
        this.sayi2(prompt + ":");
        String inLine = this.readline();
        if (this.isEmpty(inLine)) {
            return null;
        }
        return inLine;
    }

    protected void printSetDefaultIDHelp() {
        this.say("set_default_id [keyid]: This will set the default key id to be used for all signing and verification.");
        this.say("                        If this is not set, you will be prompted each time for an id.");
    }

    public void set_default_id(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.createTokenHelp();
            return;
        }
        if (1 < inputLine.size()) {
            this.defaultKeyID = inputLine.getArg(1);
            return;
        }
        String x = this.getInput("Enter the key id");
        if (this.isEmpty(x)) {
            return;
        }
        this.defaultKeyID = x;
    }

    protected void printParseClaimsHelp() {
        this.say("parse_claims [filename]");
        this.say("           Read a file and print out if it parses as JSON.");
        this.say("           If the filename is omitted, you will be prompted for it.");
        this.say("           Note that this will try to give some limited feedback in syntax errors.");
        this.say("Related: create_claims");
    }

    public void parse_claims(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.printParseClaimsHelp();
            return;
        }
        String filename = null;
        if (1 < inputLine.size()) {
            filename = inputLine.getArg(1);
        } else {
            filename = this.getInput("Enter full path to the claims file.");
            if (this.isEmpty(filename)) {
                this.say("No claims file. Exiting...");
                return;
            }
        }
        String rawJSON = this.readFile(filename);
        if (rawJSON == null) {
            this.say("Could not read the file \"" + filename + "\"");
            return;
        }
        JSONObject jsonObject = null;
        try {
            jsonObject = JSONObject.fromObject((Object)rawJSON);
        }
        catch (Throwable t) {
            this.say("Parsing fail with a message of \"" + t.getMessage() + "\"");
            return;
        }
        if (jsonObject != null) {
            this.say("success!");
            this.say(jsonObject.toString(3));
        } else {
            this.say("No JSON object resulted from parsing.");
        }
    }

    protected String getArgValue(InputLine inputLine, String key) {
        int index = inputLine.indexOf(key);
        if (index == -1) {
            return null;
        }
        if (inputLine.size() + 1 == index) {
            return null;
        }
        return inputLine.getArg(index + 1);
    }

    protected void createTokenHelp() {
        this.say("create_token [-file claims -keys keyfile -keyid id]");
        this.say("              This will take the current keys (uses default) and a file containing a JSON");
        this.say("              format set of claims. It will then sign the claims with the right headers etc.");
        this.say("              and print out the results to the console. Any of the arguments omitted will cause you");
        this.say("              to be prompted. If you have already set the key and keyid these will be used.");
        this.say("");
        this.say("Related: set_keys, set_default_id");
    }

    public void create_token(InputLine inputLine) throws Exception {
        String signedToken;
        if (this.showHelp(inputLine)) {
            this.createTokenHelp();
            return;
        }
        JSONWebKeys localKeys = null;
        if (inputLine.hasArg("-keys")) {
            String fileName = this.getArgValue(inputLine, "-keys");
            File f = new File(fileName);
            if (!f.exists()) {
                this.say("Sorry, that file does not seem to exist");
                return;
            }
            if (!f.isFile()) {
                this.say("Sorry, the thing yo specified is not a file.");
                return;
            }
            localKeys = this.readKeys(f);
        } else if (this.keys == null || this.keys.isEmpty()) {
            if (this.getBooleanInput("No keys set. Would you like to specify keys for signing?")) {
                String x = this.getInput("Enter fully qualified path and file name");
                if (this.isEmpty(x)) {
                    this.say("no file entered, exiting...");
                    return;
                }
                localKeys = this.readKeys(new File(x));
            }
        } else {
            localKeys = this.keys;
        }
        String localDefaultID = null;
        if (inputLine.hasArg("-id")) {
            localDefaultID = this.getArgValue(inputLine, "-id");
        } else if (this.defaultKeyID != null) {
            localDefaultID = this.defaultKeyID;
        } else if (this.getBooleanInput("No key id found. Do you want to enter one?")) {
            localDefaultID = this.getInput("Enter key id:");
        } else {
            return;
        }
        JSONObject claims = null;
        if (inputLine.hasArg("-file")) {
            claims = JSONObject.fromObject((Object)this.readFile(this.getArgValue(inputLine, "-file")));
        } else {
            String x = this.getInput("Enter the name of the file containing the JSON object to use:");
            if (this.isEmpty(x)) {
                this.say("No argument, exiting...");
                return;
            }
            claims = JSONObject.fromObject((Object)this.readFile(x));
        }
        this.lastToken = signedToken = JWTUtil.createJWT((JSONObject)claims, (JSONWebKey)((JSONWebKey)localKeys.get((Object)localDefaultID)));
        this.say(signedToken);
    }

    protected void printTokenHelp() {
        this.say("print_token: Print the last token generated by the create_token call.");
        this.say("             If there is no token, that will be shown too. ");
        this.say("   Related: create_token");
    }

    public void print_token(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.printTokenHelp();
            return;
        }
        if (this.lastToken == null) {
            this.say("(no token has been created)");
            return;
        }
        this.say(this.lastToken);
    }

    protected void printListKeyIDs() {
        this.say("list_key_ids [filename]");
        this.say("                List the unique key ids in the file");
        this.say("                If you do not supply an argument, the globally set keys will be used");
        this.say("                If there is no default set of keys, you will be prompted for a file");
        this.say("      related: set_keys, set_default_id");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void list_key_ids(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.printListKeyIDs();
            return;
        }
        JSONWebKeys jsonWebKeys = null;
        if (1 < inputLine.size()) {
            jsonWebKeys = JSONWebKeyUtil.fromJSON((File)new File(inputLine.getArg(1)));
        } else if (this.keys == null) {
            if (!this.getBooleanInput("Do you want to enter a file name?")) return;
            String x = this.getInput("Enter path and name of the key file");
            jsonWebKeys = JSONWebKeyUtil.fromJSON((File)new File(x));
        } else {
            jsonWebKeys = this.keys;
        }
        String defaultWebKey = null;
        defaultWebKey = jsonWebKeys.hasDefaultKey() ? jsonWebKeys.getDefaultKeyID() : this.defaultKeyID;
        for (String keyID : jsonWebKeys.keySet()) {
            JSONWebKey webKey = (JSONWebKey)jsonWebKeys.get((Object)keyID);
            boolean isDefault = webKey.id.equals(defaultWebKey);
            this.say("id=" + keyID + ", alg=" + webKey.algorithm + ", type=" + webKey.type + ", use=" + webKey.use + (isDefault ? " (default)" : ""));
        }
    }

    protected void printValidateTokenHelp() {
        this.say("validate_token [-file filename] | string");
        this.say("         This will take a token and check the signature. It will also print out the payload");
        this.say("         and header information.");
        this.say("         You may supply either the token itself or specify with the -file flag that this is in a file.");
        this.say("   related: create_token");
    }

    public void validate_token(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.printValidateTokenHelp();
            return;
        }
        String token = null;
        if (1 == inputLine.size()) {
            this.say("Sorry, no argument");
            return;
        }
        token = inputLine.hasArg("-file") ? this.getArgValue(inputLine, "-file") : inputLine.getArg(1);
        String[] x = JWTUtil.decat((String)token);
        JSONObject h = JSONObject.fromObject((Object)new String(Base64.decodeBase64((String)x[0])));
        JSONObject p = JSONObject.fromObject((Object)new String(Base64.decodeBase64((String)x[1])));
        this.say("header=" + h);
        this.say("payload=" + p);
        if (JWTUtil.verify((JSONObject)h, (JSONObject)p, (String)x[2], (JSONWebKey)((JSONWebKey)this.keys.get((Object)this.defaultKeyID)))) {
            this.say("token valid!");
        } else {
            this.say("could not validate token");
        }
    }
}

