/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oauth2.tools;

import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.OA2SE;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.util.cli.CommonCommands;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKey;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeyUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import edu.uiuc.ncsa.security.util.pkcs.KeyUtil;
import java.io.File;
import java.io.FileWriter;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import javax.xml.bind.DatatypeConverter;
import net.sf.json.JSONObject;

public class SigningCommands
extends CommonCommands {
    OA2SE oa2SE;
    SecureRandom random = new SecureRandom();

    public SigningCommands(OA2SE oa2se) {
        super(oa2se == null ? null : oa2se.getMyLogger());
        this.oa2SE = oa2se;
    }

    public OA2SE getOa2SE() {
        return this.oa2SE;
    }

    public String getPrompt() {
        return "keys>";
    }

    protected void createHelp() {
        this.say("create [path]: This will allow you to create a completely new set of JSON web keys and write it to a file");
        this.say("       If the path is given, the keys will be written. If the path is not given then you will be");
        this.say("       prompted for one. This will not overwrite an existing file.");
    }

    public void create(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.createHelp();
            return;
        }
        boolean retry = true;
        File publicKeyFile = null;
        boolean isInteractive = true;
        if (1 < inputLine.size()) {
            publicKeyFile = new File(inputLine.getArg(1));
        }
        if (publicKeyFile == null && this.isBatchMode()) {
            throw new GeneralException("No full path to the file given.");
        }
        while (retry) {
            String publicKeyPath = this.getInput("Give the file path", "");
            if (publicKeyPath.toLowerCase().equals("exit") || publicKeyPath.toLowerCase().equals("quit")) {
                return;
            }
            publicKeyFile = new File(publicKeyPath);
            if (publicKeyFile.exists()) {
                if (!publicKeyFile.isFile()) {
                    this.sayi("Sorry, but you must supply the name of the file as well (or type 'exit' to exit");
                    continue;
                }
                this.sayi2("The file you gave exists, do you want to over write it? [y/n]");
                retry = !this.isOk(this.readline());
                continue;
            }
            retry = false;
        }
        retry = true;
        this.sayi2("create a new set of JSON web keys?[y/n]");
        if (!this.isOk(this.readline())) {
            this.say("create cancelled.");
            return;
        }
        JSONWebKeys keys = new JSONWebKeys(null);
        keys.put(this.createJWK("RS256"));
        keys.put(this.createJWK("RS384"));
        keys.put(this.createJWK("RS512"));
        FileWriter writer = new FileWriter(publicKeyFile);
        JSONObject jwks = JSONWebKeyUtil.toJSON((JSONWebKeys)keys);
        writer.write(jwks.toString(3));
        writer.flush();
        writer.close();
        if (isInteractive) {
            this.sayi("JSONweb keys written");
            this.sayi("Done!");
        }
    }

    protected JSONWebKey createJWK(String algorithm) throws NoSuchProviderException, NoSuchAlgorithmException {
        byte[] byteArray = new byte[16];
        this.random.nextBytes(byteArray);
        String id = DatatypeConverter.printHexBinary((byte[])byteArray);
        KeyPair keyPair = KeyUtil.generateKeyPair();
        JSONWebKey webKey = new JSONWebKey();
        webKey.publicKey = keyPair.getPublic();
        webKey.privateKey = keyPair.getPrivate();
        webKey.use = "sig";
        webKey.id = id;
        webKey.algorithm = algorithm;
        webKey.type = "RSA";
        return webKey;
    }
}

