/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.server;

import edu.uiuc.ncsa.myproxy.MyProxyServiceFacade;
import edu.uiuc.ncsa.myproxy.ServiceFacadeConfiguration;
import edu.uiuc.ncsa.myproxy.oa4mp.server.OA4MPConfigTags;
import edu.uiuc.ncsa.security.core.configuration.Configurations;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEvent;
import edu.uiuc.ncsa.security.core.configuration.provider.HierarchicalConfigProvider;
import edu.uiuc.ncsa.security.util.ssl.SSLConfiguration;
import edu.uiuc.ncsa.security.util.ssl.SSLConfigurationUtil;
import edu.uiuc.ncsa.security.util.ssl.SSLKeystoreConfiguration;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.configuration.tree.ConfigurationNode;

public class MyProxyFacadeProvider
extends HierarchicalConfigProvider<MyProxyServiceFacade>
implements OA4MPConfigTags {
    protected boolean checkEvent(CfgEvent cfgEvent) {
        if (cfgEvent.getConfiguration().getName().equals("myproxy")) {
            this.setConfig(cfgEvent.getConfiguration());
            return true;
        }
        return false;
    }

    public Object componentFound(CfgEvent configurationEvent) {
        if (this.checkEvent(configurationEvent)) {
            return this.get();
        }
        return null;
    }

    public MyProxyServiceFacade get() {
        ServiceFacadeConfiguration sfc;
        HashMap<String, Integer> loas = new HashMap<String, Integer>();
        String localhostname = null;
        try {
            localhostname = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            localhostname = "localhost";
        }
        int port = 7512;
        if (this.getConfig() == null) {
            sfc = new ServiceFacadeConfiguration(localhostname, port, loas);
        } else {
            try {
                port = this.getIntAttribute("port");
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (this.getAttribute("host") != null) {
                localhostname = this.getAttribute("host");
            }
            sfc = new ServiceFacadeConfiguration(localhostname, port, loas);
            List list = this.getConfig().getChildren("loa");
            if (!list.isEmpty()) {
                for (Object obj : list) {
                    ConfigurationNode cn = (ConfigurationNode)obj;
                    loas.put(Configurations.getFirstAttribute((ConfigurationNode)cn, (String)"name"), Integer.parseInt(Configurations.getFirstAttribute((ConfigurationNode)cn, (String)"port")));
                }
            }
        }
        SSLConfiguration sslKeystoreConfiguration = SSLConfigurationUtil.getSSLConfiguration((ConfigurationNode)this.getConfig());
        return new MyProxyServiceFacade(sfc, (SSLKeystoreConfiguration)sslKeystoreConfiguration);
    }

    public MyProxyFacadeProvider() {
    }

    public MyProxyFacadeProvider(ConfigurationNode config) {
        super(config);
    }
}

