/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.server;

import edu.uiuc.ncsa.myproxy.MyProxyServiceFacade;
import edu.uiuc.ncsa.myproxy.oa4mp.server.MyProxyFacadeProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.server.ServiceEnvironment;
import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.AuthorizationServletConfig;
import edu.uiuc.ncsa.myproxy.oa4mp.server.util.AbstractCLIApprover;
import edu.uiuc.ncsa.security.core.configuration.Configurations;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEvent;
import edu.uiuc.ncsa.security.core.configuration.provider.HierarchicalConfigProvider;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.delegation.server.ServiceTransaction;
import edu.uiuc.ncsa.security.delegation.server.issuers.AGIssuer;
import edu.uiuc.ncsa.security.delegation.server.issuers.ATIssuer;
import edu.uiuc.ncsa.security.delegation.server.issuers.PAIssuer;
import edu.uiuc.ncsa.security.delegation.server.storage.ClientApproval;
import edu.uiuc.ncsa.security.delegation.server.storage.ClientApprovalStore;
import edu.uiuc.ncsa.security.delegation.server.storage.ClientStore;
import edu.uiuc.ncsa.security.delegation.storage.TransactionStore;
import edu.uiuc.ncsa.security.delegation.token.TokenForge;
import edu.uiuc.ncsa.security.servlet.TrivialUsernameTransformer;
import edu.uiuc.ncsa.security.servlet.UsernameTransformer;
import edu.uiuc.ncsa.security.util.mail.MailUtil;
import edu.uiuc.ncsa.security.util.mail.MailUtilProvider;
import edu.uiuc.ncsa.security.util.pkcs.KeyPairQueue;
import java.net.URI;
import java.security.KeyPair;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import org.apache.commons.configuration.tree.ConfigurationNode;

public class ServiceEnvironmentImpl
extends AbstractEnvironment
implements ServiceEnvironment {
    KeyPairQueue kpq = new KeyPairQueue();
    AuthorizationServletConfig authorizationServletConfig;
    AGIssuer agIssuer;
    URI serviceAddress;
    ATIssuer atIssuer;
    PAIssuer paIssuer;
    MessagesProvider messagesProvider;
    protected Provider<TransactionStore> tsp;
    protected Provider<ClientStore> csp;
    protected Provider<ClientApprovalStore> casp;
    protected Provider<AGIssuer> agip;
    protected Provider<ATIssuer> atip;
    protected Provider<PAIssuer> paip;
    protected Provider<TokenForge> tfp;
    Map<String, String> messages;
    protected MailUtil mailUtil;
    protected ClientApprovalStore<ClientApproval> clientApprovalStore;
    protected ClientStore clientStore;
    protected TransactionStore<ServiceTransaction> transactionStore;
    protected List<MyProxyServiceFacade> myProxyServices;
    MailUtilProvider mup;
    List<MyProxyFacadeProvider> mfps;
    AbstractCLIApprover.ClientApprovalThread clientApprovalThread;
    int maxAllowedNewClientRequests = 100;
    UsernameTransformer usernameTransformer = new TrivialUsernameTransformer();

    public KeyPairQueue getKeyPairQueue() {
        return this.kpq;
    }

    @Override
    public KeyPair getKeyPair() {
        return this.kpq.pop();
    }

    @Override
    public AuthorizationServletConfig getAuthorizationServletConfig() {
        return this.authorizationServletConfig;
    }

    @Override
    public URI getServiceAddress() {
        return this.serviceAddress;
    }

    @Override
    public void setServiceAddress(URI serviceAddress) {
        this.serviceAddress = serviceAddress;
    }

    @Override
    public AGIssuer getAgIssuer() {
        if (this.agIssuer == null) {
            this.agIssuer = (AGIssuer)this.agip.get();
        }
        return this.agIssuer;
    }

    @Override
    public ATIssuer getAtIssuer() {
        if (this.atIssuer == null) {
            this.atIssuer = (ATIssuer)this.atip.get();
        }
        return this.atIssuer;
    }

    @Override
    public PAIssuer getPaIssuer() {
        if (this.paIssuer == null) {
            this.paIssuer = (PAIssuer)this.paip.get();
        }
        return this.paIssuer;
    }

    @Override
    public TokenForge getTokenForge() {
        return (TokenForge)this.tfp.get();
    }

    public ServiceEnvironmentImpl(MyLoggingFacade logger, Provider<TransactionStore> tsp, Provider<ClientStore> csp, int maxAllowedNewClientRequests, Provider<ClientApprovalStore> casp, List<MyProxyFacadeProvider> mfp, MailUtilProvider mup, MessagesProvider messagesProvider, Provider<AGIssuer> agip, Provider<ATIssuer> atip, Provider<PAIssuer> paip, Provider<TokenForge> tfp, HashMap<String, String> constants, AuthorizationServletConfig ac, UsernameTransformer usernameTransformer) {
        super(logger, constants);
        this.casp = casp;
        this.csp = csp;
        this.tsp = tsp;
        this.mfps = mfp;
        this.mup = mup;
        this.messagesProvider = messagesProvider;
        this.atip = atip;
        this.agip = agip;
        this.paip = paip;
        this.tfp = tfp;
        this.authorizationServletConfig = ac;
        this.maxAllowedNewClientRequests = maxAllowedNewClientRequests;
        this.usernameTransformer = usernameTransformer;
    }

    @Override
    public Map<String, String> getMessages() {
        if (this.messages == null) {
            if (this.messagesProvider == null) {
                this.messages = new HashMap<String, String>();
                this.messages.put("retryMessage", "Authentication failed.");
            } else {
                this.messages = this.messagesProvider.get();
            }
        }
        return this.messages;
    }

    public ClientApprovalStore getClientApprovalStore() {
        if (this.clientApprovalStore == null) {
            this.clientApprovalStore = (ClientApprovalStore)this.casp.get();
        }
        return this.clientApprovalStore;
    }

    public ClientStore getClientStore() {
        if (this.clientStore == null) {
            this.clientStore = (ClientStore)this.csp.get();
        }
        return this.clientStore;
    }

    @Override
    public MailUtil getMailUtil() {
        if (this.mailUtil == null) {
            this.mailUtil = this.mup.get();
        }
        return this.mailUtil;
    }

    @Override
    public List<MyProxyServiceFacade> getMyProxyServices() {
        if (this.myProxyServices == null) {
            this.myProxyServices = new LinkedList<MyProxyServiceFacade>();
            for (MyProxyFacadeProvider m : this.mfps) {
                this.myProxyServices.add(m.get());
            }
            return this.myProxyServices;
        }
        return this.myProxyServices;
    }

    @Override
    public TransactionStore<ServiceTransaction> getTransactionStore() {
        if (this.transactionStore == null) {
            this.transactionStore = (TransactionStore)this.tsp.get();
        }
        return this.transactionStore;
    }

    public boolean isPollingEnabled() {
        return this.clientApprovalThread != null;
    }

    public AbstractCLIApprover.ClientApprovalThread getClientApprovalThread() {
        return this.clientApprovalThread;
    }

    public void setClientApprovalThread(AbstractCLIApprover.ClientApprovalThread clientApprovalThread) {
        this.clientApprovalThread = clientApprovalThread;
    }

    @Override
    public int getMaxAllowedNewClientRequests() {
        return this.maxAllowedNewClientRequests;
    }

    @Override
    public UsernameTransformer getUsernameTransformer() {
        return this.usernameTransformer;
    }

    @Override
    public void setUsernameTransformer(UsernameTransformer usernameTransformer) {
        this.usernameTransformer = usernameTransformer;
    }

    public static class MessagesProvider
    extends HierarchicalConfigProvider<Map<String, String>> {
        public MessagesProvider(ConfigurationNode config) {
            super(config);
        }

        protected boolean checkEvent(CfgEvent cfgEvent) {
            if (cfgEvent.getConfiguration().getName().equals("messages")) {
                this.setConfig(cfgEvent.getConfiguration());
                return true;
            }
            return false;
        }

        public Object componentFound(CfgEvent configurationEvent) {
            if (this.checkEvent(configurationEvent)) {
                return this.get();
            }
            return null;
        }

        public Map<String, String> get() {
            HashMap<String, String> messages = new HashMap<String, String>();
            messages.put("retryMessage", Configurations.getNodeValue((ConfigurationNode)this.getConfig(), (String)"retryMessage", (String)"Authentication failed."));
            return messages;
        }
    }
}

