/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.server.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.CRServlet;
import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.MyProxyDelegationServlet;
import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.PresentationState;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.exceptions.ConnectionException;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.DateUtils;
import edu.uiuc.ncsa.security.delegation.server.ServiceTransaction;
import edu.uiuc.ncsa.security.delegation.server.request.IssuerResponse;
import edu.uiuc.ncsa.security.delegation.servlet.TransactionState;
import edu.uiuc.ncsa.security.delegation.storage.impl.BasicTransaction;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import edu.uiuc.ncsa.security.servlet.JSPUtil;
import edu.uiuc.ncsa.security.servlet.Presentable;
import edu.uiuc.ncsa.security.servlet.PresentableState;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;

public abstract class AAS2
extends CRServlet
implements Presentable {
    public static final String AUTHORIZATION_ACTION_KEY = "action";
    public static final String AUTHORIZATION_USER_NAME_KEY = "AuthUserName";
    public static final String AUTHORIZATION_USER_NAME_VALUE = "userName";
    public static final String AUTHORIZATION_PASSWORD_KEY = "AuthPassword";
    public static final String AUTHORIZATION_ACTION_OK_VALUE = "ok";
    public static final int AUTHORIZATION_ACTION_OK = 1;
    public static final int AUTHORIZATION_ACTION_START = 0;
    public static final String RETRY_MESSAGE = "retryMessage";
    public static String INITIAL_PAGE = "/authorize-init.jsp";
    public static String OK_PAGE = "/authorize-ok.jsp";
    public static String ERROR_PAGE = "/authorize-error.jsp";

    @Override
    public ServiceTransaction verifyAndGet(IssuerResponse iResponse) throws IOException {
        return null;
    }

    public abstract String createCallback(ServiceTransaction var1, Map<String, String> var2);

    public void prepare(PresentableState state) throws Throwable {
        AuthorizedState aState = (AuthorizedState)state;
        switch (aState.getState()) {
            case 1: {
                return;
            }
            case 0: {
                this.info("3.a. Starting authorization for grant =" + aState.getTransaction().getIdentifierString());
                HttpServletRequest request = state.getRequest();
                request.setAttribute(AUTHORIZATION_USER_NAME_KEY, (Object)AUTHORIZATION_USER_NAME_KEY);
                request.setAttribute(AUTHORIZATION_PASSWORD_KEY, (Object)AUTHORIZATION_PASSWORD_KEY);
                request.setAttribute(AUTHORIZATION_ACTION_KEY, (Object)AUTHORIZATION_ACTION_KEY);
                request.setAttribute("actionOk", (Object)AUTHORIZATION_ACTION_OK_VALUE);
                request.setAttribute("authorizationGrant", (Object)aState.getTransaction().getIdentifierString());
                request.setAttribute("tokenKey", (Object)AAS2.CONST((String)"oa4mp:token"));
                request.setAttribute("clientHome", (Object)StringEscapeUtils.escapeHtml((String)aState.getTransaction().getClient().getHomeUri()));
                request.setAttribute("clientName", (Object)StringEscapeUtils.escapeHtml((String)aState.getTransaction().getClient().getName()));
                request.setAttribute("actionToTake", (Object)(request.getContextPath() + "/authorize"));
                return;
            }
        }
    }

    public void present(PresentableState state) throws Throwable {
        AuthorizedState aState = (AuthorizedState)state;
        this.postprocess(new TransactionState(state.getRequest(), aState.getResponse(), null, (BasicTransaction)aState.getTransaction()));
        switch (aState.getState()) {
            case 0: {
                String initPage = INITIAL_PAGE;
                this.info("*** STARTING present");
                if (AAS2.getServiceEnvironment().getAuthorizationServletConfig().isUseHeader()) {
                    this.info("*** PRESENT: Use headers enabled.");
                    String x = null;
                    if (AAS2.getServiceEnvironment().getAuthorizationServletConfig().getHeaderFieldName().equals("REMOTE_USER")) {
                        x = aState.getRequest().getRemoteUser();
                        this.info("*** got user name from request = " + x);
                    } else {
                        x = aState.getRequest().getHeader(AAS2.getServiceEnvironment().getAuthorizationServletConfig().getHeaderFieldName());
                        this.info("Got username from header \"" + AAS2.getServiceEnvironment().getAuthorizationServletConfig().getHeaderFieldName() + "\" + directly: " + x);
                    }
                    if (this.isEmpty(x)) {
                        if (AAS2.getServiceEnvironment().getAuthorizationServletConfig().isRequireHeader()) {
                            throw new GeneralException("Error: configuration required using the header \"" + AAS2.getServiceEnvironment().getAuthorizationServletConfig().getHeaderFieldName() + "\" " + "but this was not set. Cannot continue.");
                        }
                    } else {
                        aState.getTransaction().setUsername(x);
                        this.info("*** storing user name = " + x);
                        this.getTransactionStore().save((Identifiable)aState.getTransaction());
                        aState.getRequest().setAttribute(AUTHORIZATION_USER_NAME_VALUE, (Object)StringEscapeUtils.escapeHtml((String)x));
                    }
                } else {
                    this.info("*** PRESENT: Use headers DISABLED.");
                }
                JSPUtil.fwd((HttpServletRequest)state.getRequest(), (HttpServletResponse)state.getResponse(), (String)initPage);
                this.info("3.a. User information obtained for grant = " + aState.getTransaction().getAuthorizationGrant());
                break;
            }
            case 1: {
                JSPUtil.fwd((HttpServletRequest)state.getRequest(), (HttpServletResponse)state.getResponse(), (String)OK_PAGE);
                break;
            }
            default: {
                this.debug("Hit default case in AbstractAuthZ servlet");
            }
        }
    }

    public void handleError(PresentableState state, Throwable t) throws IOException, ServletException {
        AuthorizedState aState = (AuthorizedState)state;
        state.getResponse().setHeader("X-Frame-Options", "DENY");
        state.getRequest().setAttribute("client", (Object)aState.getTransaction().getClient());
        JSPUtil.handleException((Throwable)t, (HttpServletRequest)state.getRequest(), (HttpServletResponse)state.getResponse(), (String)ERROR_PAGE);
    }

    protected void doIt(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        this.info("*** STARTING request");
        String ag = request.getParameter(AAS2.CONST((String)"oa4mp:token"));
        ServiceTransaction trans = null;
        if (ag == null) {
            throw new GeneralException("Error: Invalid request -- no token. Request rejected.");
        }
        trans = this.getAndCheckTransaction(ag);
        AuthorizedState pState = new AuthorizedState(this.getState(request), request, response, trans);
        this.prepare(pState);
        this.preprocess(new TransactionState(request, response, null, (BasicTransaction)trans));
        switch (pState.getState()) {
            case 1: {
                trans.setAuthGrantValid(true);
                this.getTransactionStore().save((Identifiable)trans);
                try {
                    this.createRedirect(request, response, trans);
                    return;
                }
                catch (ConnectionException ce) {
                    String message = ce.getMessage();
                    if (ce.getCause() != null) {
                        message = ce.getCause().getMessage();
                    }
                    this.info("**** AuthZServlet, got connection exception:" + message + " Retrying...");
                    request.setAttribute(RETRY_MESSAGE, (Object)(message + "<br/><br/>" + AAS2.getServiceEnvironment().getMessages().get(RETRY_MESSAGE)));
                    pState.setState(0);
                    this.prepare(pState);
                    break;
                }
                catch (GeneralSecurityException t) {
                    this.info("**** AuthZServlet, got General security exception. This is benign and might just mean a mistyped password. Retrying...");
                    request.setAttribute(RETRY_MESSAGE, (Object)AAS2.getServiceEnvironment().getMessages().get(RETRY_MESSAGE));
                    pState.setState(0);
                    this.prepare(pState);
                    break;
                }
            }
            case 0: {
                break;
            }
        }
        this.present(pState);
    }

    public int getState(HttpServletRequest request) {
        String action = request.getParameter(AUTHORIZATION_ACTION_KEY);
        this.log("action = " + action);
        if (action == null || action.length() == 0) {
            return 0;
        }
        if (action.equals(AUTHORIZATION_ACTION_OK_VALUE)) {
            return 1;
        }
        throw new GeneralException("Error: unknown authorization request action = \"" + action + "\"");
    }

    protected ServiceTransaction getAndCheckTransaction(String token) throws IOException {
        DateUtils.checkTimestamp((String)token);
        AuthorizationGrant grant = MyProxyDelegationServlet.getServiceEnvironment().getTokenForge().getAuthorizationGrant(new String[]{token});
        ServiceTransaction trans = (ServiceTransaction)MyProxyDelegationServlet.getServiceEnvironment().getTransactionStore().get(grant);
        if (trans == null) {
            this.warn("Error: no delegation request found for " + token);
            throw new GeneralException("Error: no delegation request found.");
        }
        this.checkClient(trans.getClient());
        return trans;
    }

    protected void createRedirect(HttpServletRequest request, HttpServletResponse response, ServiceTransaction trans) throws Throwable {
        String userName = request.getParameter(AUTHORIZATION_USER_NAME_KEY);
        trans.setUsername(userName);
        String password = request.getParameter(AUTHORIZATION_PASSWORD_KEY);
        this.info("3.b. transaction has user name = " + userName);
        this.preprocess(new TransactionState(request, response, null, (BasicTransaction)trans));
        String statusString = " transaction =" + trans.getIdentifierString() + " and client=" + trans.getClient().getIdentifierString();
        trans.setVerifier(MyProxyDelegationServlet.getServiceEnvironment().getTokenForge().getVerifier(new String[0]));
        MyProxyDelegationServlet.getServiceEnvironment().getTransactionStore().save((Identifiable)trans);
        this.createMPConnection(trans.getIdentifier(), userName, password, trans.getLifetime(), statusString);
        this.doRealCertRequest(trans, statusString);
        this.debug("4.a. verifier = " + trans.getVerifier() + ", " + statusString);
        String cb = this.createCallback(trans, this.getFirstParameters(request));
        this.info("4.a. starting redirect to " + cb + ", " + statusString);
        response.sendRedirect(cb);
        this.info("4.b. Redirect to callback " + cb + " ok, " + statusString);
    }

    protected class AuthorizedState
    extends PresentationState {
        ServiceTransaction transaction;

        public AuthorizedState(int state, HttpServletRequest request, HttpServletResponse response, ServiceTransaction transaction) {
            super(state, request, response);
            this.transaction = transaction;
        }

        public ServiceTransaction getTransaction() {
            return this.transaction;
        }
    }
}

