/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.server.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.CRServlet;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.delegation.server.ServiceTransaction;
import edu.uiuc.ncsa.security.delegation.server.issuers.PAIssuer;
import edu.uiuc.ncsa.security.delegation.server.request.IssuerResponse;
import edu.uiuc.ncsa.security.delegation.server.request.PARequest;
import edu.uiuc.ncsa.security.delegation.server.request.PAResponse;
import edu.uiuc.ncsa.security.delegation.services.Request;
import edu.uiuc.ncsa.security.delegation.servlet.TransactionState;
import edu.uiuc.ncsa.security.delegation.storage.impl.BasicTransaction;
import edu.uiuc.ncsa.security.util.pkcs.CertUtil;
import edu.uiuc.ncsa.security.util.pkcs.MyPKCS10CertRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class ACS2
extends CRServlet {
    protected PAIssuer getPAI() throws IOException {
        return ACS2.getServiceEnvironment().getPaIssuer();
    }

    protected void doIt(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable {
        this.doDelegation(httpServletRequest, httpServletResponse);
    }

    protected void doDelegation(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable {
        this.info("6.a. Starting to process cert request");
        PARequest paRequest = new PARequest(httpServletRequest, this.getClient(httpServletRequest));
        String statusString = "client = " + paRequest.getClient().getIdentifier();
        paRequest.setAccessToken(ACS2.getServiceEnvironment().getTokenForge().getAccessToken(httpServletRequest));
        PAResponse paResponse = (PAResponse)this.getPAI().process((Request)paRequest);
        this.debug("6.a. " + statusString);
        ServiceTransaction t = this.verifyAndGet((IssuerResponse)paResponse);
        Map params = httpServletRequest.getParameterMap();
        if (t.getCertReq() == null) {
            MyPKCS10CertRequest certReq;
            String rawCR = ((String[])params.get(ACS2.CONST((String)"oa4mp:certreq")))[0];
            try {
                certReq = CertUtil.fromStringToCertReq((String)rawCR);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new GeneralException("Error: cert request is bad/not understandable:" + (rawCR == null ? "(null)" : rawCR), throwable);
            }
            t.setCertReq(certReq);
            t.setLifetime(Long.parseLong(((String[])params.get(ACS2.CONST((String)"oa4mp:certlifetime")))[0]));
            this.getTransactionStore().save((Identifiable)t);
        }
        this.info("6.a. Processing request for transaction " + t.getIdentifier());
        this.doRealCertRequest(t, statusString);
        t.setAccessTokenValid(false);
        this.preprocess(new TransactionState(httpServletRequest, httpServletResponse, paResponse.getParameters(), (BasicTransaction)t));
        this.debug("6.a. protected asset:" + (t.getProtectedAsset() == null ? "(null)" : "ok") + ", " + statusString);
        HashMap<String, String> username = new HashMap<String, String>();
        username.put("username", t.getUsername());
        if (paResponse.getParameters() != null) {
            username.putAll(paResponse.getParameters());
        }
        paResponse.setAdditionalInformation(username);
        paResponse.setProtectedAsset(t.getProtectedAsset());
        this.debug("6.a. Added username \"" + t.getUsername() + "\" & cert for request from " + statusString);
        this.getTransactionStore().save((Identifiable)t);
        this.info("6.b. Done with cert request " + statusString);
        paResponse.write(httpServletResponse);
        this.info("6.b. Completed transaction " + t.getIdentifierString() + ", " + statusString);
        this.postprocess(new TransactionState(httpServletRequest, httpServletResponse, paResponse.getParameters(), (BasicTransaction)t));
    }
}

