/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.server.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.IssuerTransactionState;
import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.MyProxyDelegationServlet;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.DateUtils;
import edu.uiuc.ncsa.security.delegation.server.ServiceTransaction;
import edu.uiuc.ncsa.security.delegation.server.request.ATRequest;
import edu.uiuc.ncsa.security.delegation.server.request.ATResponse;
import edu.uiuc.ncsa.security.delegation.server.request.IssuerResponse;
import edu.uiuc.ncsa.security.delegation.services.Request;
import edu.uiuc.ncsa.security.delegation.servlet.TransactionState;
import edu.uiuc.ncsa.security.delegation.storage.impl.BasicTransaction;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import edu.uiuc.ncsa.security.delegation.token.Verifier;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractAccessTokenServlet
extends MyProxyDelegationServlet {
    protected void doIt(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable {
        this.doDelegation(httpServletRequest, httpServletResponse);
    }

    protected IssuerTransactionState doDelegation(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable, ServletException {
        this.info("5.a. Starting access token exchange");
        Verifier v = AbstractAccessTokenServlet.getServiceEnvironment().getTokenForge().getVerifier(httpServletRequest);
        AuthorizationGrant ag = AbstractAccessTokenServlet.getServiceEnvironment().getTokenForge().getAuthorizationGrant(httpServletRequest);
        ATRequest atRequest = new ATRequest(httpServletRequest, this.getClient(httpServletRequest));
        atRequest.setVerifier(v);
        atRequest.setAuthorizationGrant(ag);
        atRequest.setExpiresIn(DateUtils.MAX_TIMEOUT);
        ATResponse atResp = (ATResponse)this.getATI().process((Request)atRequest);
        ServiceTransaction transaction = this.verifyAndGet((IssuerResponse)atResp);
        String cc = "client=" + transaction.getClient();
        this.info("5.a. got access token " + cc);
        this.preprocess(new TransactionState(httpServletRequest, httpServletResponse, atResp.getParameters(), (BasicTransaction)transaction));
        this.debug("5.a. access token = " + atResp.getAccessToken() + " for verifier = " + v);
        transaction.setAuthGrantValid(false);
        transaction.setAccessToken(atResp.getAccessToken());
        transaction.setAccessTokenValid(true);
        try {
            this.getTransactionStore().save((Identifiable)transaction);
            this.info("5.a. updated transaction state for " + cc + ", sending response to client");
        }
        catch (GeneralException e) {
            throw new ServletException("Error saving transaction", (Throwable)e);
        }
        atResp.write(httpServletResponse);
        this.info("5.b. done with access token exchange with " + cc);
        IssuerTransactionState transactionState = new IssuerTransactionState(httpServletRequest, httpServletResponse, atResp.getParameters(), (BasicTransaction)transaction, (IssuerResponse)atResp);
        this.postprocess(transactionState);
        return transactionState;
    }
}

