/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.server.servlet;

import edu.uiuc.ncsa.myproxy.MyProxyServiceFacade;
import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.AuthorizationHandler;
import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.MyProxyDelegationServlet;
import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.PresentationState;
import edu.uiuc.ncsa.myproxy.oa4mp.server.util.JGlobusUtil;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.DateUtils;
import edu.uiuc.ncsa.security.delegation.server.ServiceTransaction;
import edu.uiuc.ncsa.security.delegation.server.request.IssuerResponse;
import edu.uiuc.ncsa.security.delegation.servlet.TransactionState;
import edu.uiuc.ncsa.security.delegation.storage.impl.BasicTransaction;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import edu.uiuc.ncsa.security.delegation.token.MyX509Certificates;
import edu.uiuc.ncsa.security.delegation.token.ProtectedAsset;
import edu.uiuc.ncsa.security.servlet.JSPUtil;
import edu.uiuc.ncsa.security.servlet.Presentable;
import edu.uiuc.ncsa.security.servlet.PresentableState;
import edu.uiuc.ncsa.security.util.pkcs.CertUtil;
import edu.uiuc.ncsa.security.util.pkcs.MyPKCS10CertRequest;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.LinkedList;
import javax.security.auth.x500.X500Principal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;

public abstract class AbstractAuthorizationServlet
extends MyProxyDelegationServlet
implements Presentable,
AuthorizationHandler {
    public static final String AUTHORIZATION_ACTION_KEY = "action";
    public static final String AUTHORIZATION_USER_NAME_KEY = "AuthUserName";
    public static final String AUTHORIZATION_USER_NAME_VALUE = "userName";
    public static final String AUTHORIZATION_PASSWORD_KEY = "AuthPassword";
    public static final String AUTHORIZATION_ACTION_OK_VALUE = "ok";
    public static final int AUTHORIZATION_ACTION_OK = 1;
    public static final int AUTHORIZATION_ACTION_START = 0;
    public static final String RETRY_MESSAGE = "retryMessage";
    public static String INITIAL_PAGE = "/authorize-init.jsp";
    public static String OK_PAGE = "/authorize-ok.jsp";
    public static String ERROR_PAGE = "/authorize-error.jsp";

    @Override
    public ServiceTransaction verifyAndGet(IssuerResponse iResponse) throws IOException {
        return null;
    }

    public abstract String createCallback(ServiceTransaction var1);

    public void prepare(PresentableState state) throws Throwable {
        AuthorizedState aState = (AuthorizedState)state;
        switch (aState.getState()) {
            case 1: {
                return;
            }
            case 0: {
                this.info("3.a. Starting authorization for grant =" + aState.getTransaction().getIdentifierString());
                HttpServletRequest request = state.getRequest();
                request.setAttribute(AUTHORIZATION_USER_NAME_KEY, (Object)AUTHORIZATION_USER_NAME_KEY);
                request.setAttribute(AUTHORIZATION_PASSWORD_KEY, (Object)AUTHORIZATION_PASSWORD_KEY);
                request.setAttribute(AUTHORIZATION_ACTION_KEY, (Object)AUTHORIZATION_ACTION_KEY);
                request.setAttribute("actionOk", (Object)AUTHORIZATION_ACTION_OK_VALUE);
                request.setAttribute("authorizationGrant", (Object)aState.getTransaction().getIdentifierString());
                request.setAttribute("tokenKey", (Object)AbstractAuthorizationServlet.CONST((String)"oa4mp:token"));
                request.setAttribute("clientHome", (Object)StringEscapeUtils.escapeHtml((String)aState.getTransaction().getClient().getHomeUri()));
                request.setAttribute("clientName", (Object)StringEscapeUtils.escapeHtml((String)aState.getTransaction().getClient().getName()));
                request.setAttribute("actionToTake", (Object)(request.getContextPath() + "/authorize"));
                return;
            }
        }
    }

    public void present(PresentableState state) throws Throwable {
        AuthorizedState aState = (AuthorizedState)state;
        this.postprocess(new TransactionState(state.getRequest(), aState.getResponse(), null, (BasicTransaction)aState.getTransaction()));
        switch (aState.getState()) {
            case 0: {
                String initPage = INITIAL_PAGE;
                this.info("*** STARTING present");
                if (AbstractAuthorizationServlet.getServiceEnvironment().getAuthorizationServletConfig().isUseHeader()) {
                    this.info("*** PRESENT: Use headers enabled.");
                    String x = null;
                    if (AbstractAuthorizationServlet.getServiceEnvironment().getAuthorizationServletConfig().getHeaderFieldName().equals("REMOTE_USER")) {
                        x = aState.getRequest().getRemoteUser();
                        this.info("*** got user name from request = " + x);
                    } else {
                        x = aState.getRequest().getHeader(AbstractAuthorizationServlet.getServiceEnvironment().getAuthorizationServletConfig().getHeaderFieldName());
                        this.info("Got username from header \"" + AbstractAuthorizationServlet.getServiceEnvironment().getAuthorizationServletConfig().getHeaderFieldName() + "\" + directly: " + x);
                    }
                    if (this.isEmpty(x)) {
                        if (AbstractAuthorizationServlet.getServiceEnvironment().getAuthorizationServletConfig().isRequireHeader()) {
                            throw new GeneralException("Error: configuration required using the header \"" + AbstractAuthorizationServlet.getServiceEnvironment().getAuthorizationServletConfig().getHeaderFieldName() + "\" " + "but this was not set. Cannot continue.");
                        }
                    } else {
                        aState.getTransaction().setUsername(x);
                        this.info("*** storing user name = " + x);
                        this.getTransactionStore().save((Identifiable)aState.getTransaction());
                        aState.getRequest().setAttribute(AUTHORIZATION_USER_NAME_VALUE, (Object)StringEscapeUtils.escapeHtml((String)x));
                    }
                } else {
                    this.info("*** PRESENT: Use headers DISABLED.");
                }
                JSPUtil.fwd((HttpServletRequest)state.getRequest(), (HttpServletResponse)state.getResponse(), (String)initPage);
                this.info("3.a. User information obtained for grant = " + aState.getTransaction().getAuthorizationGrant());
                break;
            }
            case 1: {
                JSPUtil.fwd((HttpServletRequest)state.getRequest(), (HttpServletResponse)state.getResponse(), (String)OK_PAGE);
                break;
            }
            default: {
                this.debug("Hit default case in AbstractAuthZ servlet");
            }
        }
    }

    public void handleError(PresentableState state, Throwable t) throws IOException, ServletException {
        AuthorizedState aState = (AuthorizedState)state;
        state.getResponse().setHeader("X-Frame-Options", "DENY");
        state.getRequest().setAttribute("client", (Object)aState.getTransaction().getClient());
        JSPUtil.handleException((Throwable)t, (HttpServletRequest)state.getRequest(), (HttpServletResponse)state.getResponse(), (String)ERROR_PAGE);
    }

    @Override
    public void doIt(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        this.info("*** STARTING request");
        String ag = request.getParameter(AbstractAuthorizationServlet.CONST((String)"oa4mp:token"));
        ServiceTransaction trans = null;
        if (ag == null) {
            throw new GeneralException("Error: Invalid request -- no token. Request rejected.");
        }
        trans = this.getAndCheckTransaction(ag);
        AuthorizedState pState = new AuthorizedState(this.getState(request), request, response, trans);
        this.prepare(pState);
        this.preprocess(new TransactionState(request, response, null, (BasicTransaction)trans));
        switch (pState.getState()) {
            case 1: {
                trans.setAuthGrantValid(true);
                this.getTransactionStore().save((Identifiable)trans);
                try {
                    if (trans.getClient().isProxyLimited()) {
                        this.doCertRequestLimited(request, response);
                    } else {
                        this.doCertRequest(request, response);
                    }
                    return;
                }
                catch (GeneralSecurityException t) {
                    this.info("**** AuthZServlet, got GSX");
                    request.setAttribute(RETRY_MESSAGE, (Object)AbstractAuthorizationServlet.getServiceEnvironment().getMessages().get(RETRY_MESSAGE));
                    pState.setState(0);
                    this.prepare(pState);
                    break;
                }
            }
            case 0: {
                break;
            }
        }
        this.present(pState);
    }

    public int getState(HttpServletRequest request) {
        String action = request.getParameter(AUTHORIZATION_ACTION_KEY);
        this.log("action = " + action);
        if (action == null || action.length() == 0) {
            return 0;
        }
        if (action.equals(AUTHORIZATION_ACTION_OK_VALUE)) {
            return 1;
        }
        throw new GeneralException("Error: unknown authorization request action = \"" + action + "\"");
    }

    protected ServiceTransaction getAndCheckTransaction(String token) throws IOException {
        DateUtils.checkTimestamp((String)token);
        AuthorizationGrant grant = MyProxyDelegationServlet.getServiceEnvironment().getTokenForge().getAuthorizationGrant(new String[]{token});
        ServiceTransaction trans = (ServiceTransaction)MyProxyDelegationServlet.getServiceEnvironment().getTransactionStore().get(grant);
        if (trans == null) {
            this.warn("Error: no delegation request found for " + token);
            throw new GeneralException("Error: no delegation request found.");
        }
        this.checkClient(trans.getClient());
        return trans;
    }

    protected void doCertRequest(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        ServiceTransaction trans = this.getAndCheckTransaction(request.getParameter(AbstractAuthorizationServlet.CONST((String)"oa4mp:token")));
        String userName = trans.getUsername();
        String password = null;
        this.info("*** stored transaction username = " + userName);
        if (this.isEmpty(userName)) {
            userName = request.getParameter(AUTHORIZATION_USER_NAME_KEY);
            this.info("got user name from form = " + userName);
            if (this.isEmpty(userName)) {
                throw new GeneralException("Error: No user name found");
            }
            password = request.getParameter(AUTHORIZATION_PASSWORD_KEY);
        }
        this.info("3.b. transaction has user name = " + userName);
        this.preprocess(new TransactionState(request, response, null, (BasicTransaction)trans));
        String xx = " transaction =" + trans.getIdentifierString() + " and client=" + trans.getClient().getIdentifierString();
        this.info("3.b. " + xx);
        this.info("3.b. MP facade #=" + MyProxyDelegationServlet.getServiceEnvironment().getMyProxyServices().size());
        String u2 = AbstractAuthorizationServlet.getServiceEnvironment().getUsernameTransformer().createMyProxyUsername(request);
        userName = u2 != null ? u2 : userName;
        this.info("3.b. Starting call to MyProxy with (transformed) username = " + userName);
        LinkedList<X509Certificate> certs = this.getX509Certificates(trans, xx, userName, password, trans.getCertReq());
        MyX509Certificates myCerts = new MyX509Certificates(certs);
        trans.setProtectedAsset((ProtectedAsset)myCerts);
        if (AbstractAuthorizationServlet.getServiceEnvironment().getAuthorizationServletConfig().isReturnDnAsUsername()) {
            if (myCerts.getX509Certificates().length > 0) {
                X500Principal x500Principal = myCerts.getX509Certificates()[0].getSubjectX500Principal();
                userName = x500Principal.getName();
                if (AbstractAuthorizationServlet.getServiceEnvironment().getAuthorizationServletConfig().isConvertDNToGlobusID()) {
                    userName = JGlobusUtil.toGlobusID(userName);
                }
            } else {
                userName = "no_certificates_found";
            }
            trans.setUsername(userName);
            this.info("3.c. Set username returned to client to first certificate's DN: " + userName);
        }
        trans.setUsername(userName);
        trans.setVerifier(MyProxyDelegationServlet.getServiceEnvironment().getTokenForge().getVerifier(new String[0]));
        MyProxyDelegationServlet.getServiceEnvironment().getTransactionStore().save((Identifiable)trans);
        this.debug("4.a. verifier = " + trans.getVerifier() + ", " + xx);
        String cb = this.createCallback(trans);
        this.info("4.a. starting redirect to " + cb + ", " + xx);
        response.sendRedirect(cb);
        this.info("4.b. Redirect to callback " + cb + " ok, " + xx);
    }

    protected void doCertRequestLimited(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        ServiceTransaction trans = this.getAndCheckTransaction(request.getParameter(AbstractAuthorizationServlet.CONST((String)"oa4mp:token")));
        String transIDString = " transaction =" + trans.getIdentifier() + " and client=" + trans.getClient().getIdentifier();
        String userName = trans.getUsername();
        String password = null;
        this.info("*** stored transaction username = " + userName);
        if (this.isEmpty(userName)) {
            userName = request.getParameter(AUTHORIZATION_USER_NAME_KEY);
            this.info("got user name from form = " + userName);
            if (this.isEmpty(userName)) {
                throw new GeneralException("Error: No user name found");
            }
            password = request.getParameter(AUTHORIZATION_PASSWORD_KEY);
        }
        this.info("3.b. transaction has user name = " + userName);
        this.info("3.b. " + transIDString);
        KeyPair keyPair = null;
        MyPKCS10CertRequest localCertRequest = null;
        try {
            keyPair = AbstractAuthorizationServlet.getServiceEnvironment().getKeyPair();
            localCertRequest = CertUtil.createCertRequest((KeyPair)keyPair);
        }
        catch (GeneralSecurityException e) {
            this.error("3.b. " + e.getMessage());
        }
        this.debug("3.b. " + CertUtil.fromCertReqToString((MyPKCS10CertRequest)trans.getCertReq()));
        this.debug("3.b. " + CertUtil.fromCertReqToString((MyPKCS10CertRequest)localCertRequest));
        Object lastException = null;
        this.info("3.b. MP facade #=" + MyProxyDelegationServlet.getServiceEnvironment().getMyProxyServices().size());
        userName = AbstractAuthorizationServlet.getServiceEnvironment().getUsernameTransformer().createMyProxyUsername(request);
        this.info("3.b. Starting call to MyProxy with (transformed) username = " + userName);
        LinkedList<X509Certificate> certs = this.getX509Certificates(trans, transIDString, userName, password, localCertRequest);
        certs.addFirst(JGlobusUtil.createProxyCertificate(certs.getLast(), keyPair.getPrivate(), trans.getCertReq().getPublicKey(), (int)(trans.getLifetime() / 1000L)));
        MyX509Certificates myCerts = new MyX509Certificates(certs);
        trans.setProtectedAsset((ProtectedAsset)myCerts);
        if (AbstractAuthorizationServlet.getServiceEnvironment().getAuthorizationServletConfig().isReturnDnAsUsername()) {
            if (myCerts.getX509Certificates().length > 0) {
                X500Principal x500Principal = myCerts.getX509Certificates()[0].getSubjectX500Principal();
                userName = x500Principal.getName();
                if (AbstractAuthorizationServlet.getServiceEnvironment().getAuthorizationServletConfig().isConvertDNToGlobusID()) {
                    userName = JGlobusUtil.toGlobusID(userName);
                }
            } else {
                userName = "no_certificates_found";
            }
            trans.setUsername(userName);
            this.info("3.c. Set username returned to client to first certificate's DN: " + userName);
        }
        trans.setUsername(userName);
        trans.setVerifier(MyProxyDelegationServlet.getServiceEnvironment().getTokenForge().getVerifier(new String[0]));
        MyProxyDelegationServlet.getServiceEnvironment().getTransactionStore().save((Identifiable)trans);
        this.debug("4.a. verifier = " + trans.getVerifier() + ", " + transIDString);
        String cb = this.createCallback(trans);
        this.info("4.a. starting redirect to " + cb + ", " + transIDString);
        response.sendRedirect(cb);
        this.info("4.b. Redirect to callback " + cb + " ok, " + transIDString);
    }

    protected LinkedList<X509Certificate> getX509Certificates(ServiceTransaction trans, String transIDString, String userName, String password, MyPKCS10CertRequest localCertRequest) throws GeneralSecurityException {
        Throwable lastException = null;
        LinkedList<X509Certificate> certs = new LinkedList<X509Certificate>();
        for (MyProxyServiceFacade msp : MyProxyDelegationServlet.getServiceEnvironment().getMyProxyServices()) {
            this.info("3.b. myproxy is " + msp.getFacadeConfiguration().getHostname() + ":" + msp.getFacadeConfiguration().getPort());
            try {
                Collection returnedCerts = msp.getCerts(userName, password, localCertRequest.getEncoded(), trans.getLifetime());
                certs.addAll(returnedCerts);
                break;
            }
            catch (GeneralSecurityException gsx) {
                this.error("failed to get cert for token " + transIDString + ", message = " + gsx.getMessage());
                throw gsx;
            }
            catch (Throwable t) {
                lastException = t;
                this.error("3.b. returned exception is " + t.getClass().getName());
            }
        }
        if (certs.isEmpty()) {
            this.info("Error: No usable MyProxy service found." + transIDString);
            throw new GeneralException("Error: No usable MyProxy service found.", lastException);
        }
        this.info("3.c. Got cert from MyProxy, issuing a limited proxy & storing it, " + transIDString);
        return certs;
    }

    protected class AuthorizedState
    extends PresentationState {
        ServiceTransaction transaction;

        public AuthorizedState(int state, HttpServletRequest request, HttpServletResponse response, ServiceTransaction transaction) {
            super(state, request, response);
            this.transaction = transaction;
        }

        public ServiceTransaction getTransaction() {
            return this.transaction;
        }
    }
}

