/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.server.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.MyProxyDelegationServlet;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.delegation.server.ServiceTransaction;
import edu.uiuc.ncsa.security.delegation.server.issuers.PAIssuer;
import edu.uiuc.ncsa.security.delegation.server.request.IssuerResponse;
import edu.uiuc.ncsa.security.delegation.server.request.PARequest;
import edu.uiuc.ncsa.security.delegation.server.request.PAResponse;
import edu.uiuc.ncsa.security.delegation.services.Request;
import edu.uiuc.ncsa.security.delegation.servlet.TransactionState;
import edu.uiuc.ncsa.security.delegation.storage.impl.BasicTransaction;
import edu.uiuc.ncsa.security.delegation.token.AccessToken;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractCertServlet
extends MyProxyDelegationServlet {
    protected PAIssuer getPAI() throws IOException {
        return AbstractCertServlet.getServiceEnvironment().getPaIssuer();
    }

    protected void doIt(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable {
        this.doDelegation(httpServletRequest, httpServletResponse);
    }

    protected void doDelegation(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable {
        this.info("6.a. Starting to process cert request");
        PARequest paRequest = new PARequest(httpServletRequest, this.getClient(httpServletRequest));
        String cc = "client = " + paRequest.getClient().getIdentifier();
        paRequest.setAccessToken(AbstractCertServlet.getServiceEnvironment().getTokenForge().getAccessToken(httpServletRequest));
        PAResponse paResponse = (PAResponse)this.getPAI().process((Request)paRequest);
        AccessToken accessToken = paResponse.getAccessToken();
        this.debug("6.a. " + cc);
        ServiceTransaction t = this.verifyAndGet((IssuerResponse)paResponse);
        this.info("6.a. Processing request for transaction " + t.getIdentifier());
        t.setAccessTokenValid(false);
        this.preprocess(new TransactionState(httpServletRequest, httpServletResponse, paResponse.getParameters(), (BasicTransaction)t));
        this.debug("6.a. protected asset:" + (t.getProtectedAsset() == null ? "(null)" : "ok") + ", " + cc);
        HashMap<String, String> username = new HashMap<String, String>();
        username.put("username", t.getUsername());
        username.putAll(paResponse.getParameters());
        paResponse.setAdditionalInformation(username);
        paResponse.setProtectedAsset(t.getProtectedAsset());
        this.debug("6.a. Added username \"" + t.getUsername() + "\" & cert for request from " + cc);
        this.getTransactionStore().save((Identifiable)t);
        this.info("6.b. Done with cert request " + cc);
        paResponse.write(httpServletResponse);
        this.info("6.b. Completed transaction " + t.getIdentifierString() + ", " + cc);
        this.postprocess(new TransactionState(httpServletRequest, httpServletResponse, paResponse.getParameters(), (BasicTransaction)t));
    }
}

