/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.server.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.IssuerTransactionState;
import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.MyProxyDelegationServlet;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.delegation.server.ExceptionWrapper;
import edu.uiuc.ncsa.security.delegation.server.ServiceTransaction;
import edu.uiuc.ncsa.security.delegation.server.UnapprovedClientException;
import edu.uiuc.ncsa.security.delegation.server.request.AGRequest;
import edu.uiuc.ncsa.security.delegation.server.request.AGResponse;
import edu.uiuc.ncsa.security.delegation.server.request.IssuerResponse;
import edu.uiuc.ncsa.security.delegation.services.Request;
import edu.uiuc.ncsa.security.delegation.servlet.TransactionState;
import edu.uiuc.ncsa.security.delegation.storage.Client;
import edu.uiuc.ncsa.security.delegation.storage.impl.BasicTransaction;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractInitServlet
extends MyProxyDelegationServlet {
    protected void doIt(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable {
        this.doDelegation(httpServletRequest, httpServletResponse);
    }

    protected void doDelegation(HttpServletRequest req, HttpServletResponse resp) throws Throwable {
        Client client = this.getClient(req);
        try {
            String cid = "client=" + client.getIdentifier();
            this.info("2.a. Starting a new cert request: " + cid);
            this.checkClient(client);
            AGResponse agResponse = (AGResponse)this.getAGI().process((Request)new AGRequest(req, client));
            agResponse.setClient(client);
            ServiceTransaction transaction = this.verifyAndGet((IssuerResponse)agResponse);
            transaction.setClient(client);
            this.getTransactionStore().save((Identifiable)transaction);
            Map params = agResponse.getParameters();
            this.preprocess(new TransactionState(req, resp, params, (BasicTransaction)transaction));
            System.out.println(((Object)((Object)this)).getClass().getSimpleName() + ".doIt: new client id = " + transaction.getIdentifierString());
            this.debug("saved transaction for " + cid + ", trans id=" + transaction.getIdentifierString());
            agResponse.write(resp);
            this.info("2.b finished initial request for token =\"" + transaction.getIdentifierString() + "\".");
            this.postprocess(new IssuerTransactionState(req, resp, params, (BasicTransaction)transaction, (IssuerResponse)agResponse));
        }
        catch (Throwable t) {
            if (t instanceof UnapprovedClientException) {
                this.warn("Unapproved client: " + client.getIdentifierString());
                throw t;
            }
            ExceptionWrapper ew = new ExceptionWrapper(t, client);
            throw ew;
        }
    }
}

