/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.server.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.CRServlet;
import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.MyProxyDelegationServlet;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.DateUtils;
import edu.uiuc.ncsa.security.delegation.server.ServiceTransaction;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AuthorizedServlet
extends CRServlet {
    public static final String AUTHORIZATION_USER_NAME_KEY = "userName";
    public static final String AUTHORIZATION_PASSWORD_KEY = "password";
    public static final String AUTHORIZATION_CERT_LIFETIME_KEY = "lifetime";
    public static final String STATUS_KEY = "status";
    public static final String STATUS_OK = "ok";
    public static final String REDIRECT_URL_KEY = "redirect_url";

    public abstract String createCallback(ServiceTransaction var1);

    protected void doIt(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        String ag = request.getParameter(AuthorizedServlet.CONST((String)"oa4mp:token"));
        ServiceTransaction trans = null;
        if (ag == null) {
            throw new GeneralException("Error: Invalid request -- no token. Request rejected.");
        }
        trans = this.getAndCheckTransaction(ag);
        String username = request.getParameter(AUTHORIZATION_USER_NAME_KEY);
        String password = request.getParameter(AUTHORIZATION_PASSWORD_KEY);
        String xUsername = AuthorizedServlet.getServiceEnvironment().getUsernameTransformer().createMyProxyUsername(request);
        if (xUsername != null) {
            username = xUsername;
        }
        trans.setUsername(username);
        String lifetimeS = request.getParameter(AUTHORIZATION_CERT_LIFETIME_KEY);
        long lifetime = trans.getLifetime();
        if (lifetimeS != null && 0 < lifetimeS.length()) {
            try {
                lifetime = Long.parseLong(lifetimeS);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this.createMPConnection(trans.getIdentifier(), username, password, lifetime, "");
        String cb = this.createCallback(trans);
        PrintWriter w = response.getWriter();
        String returnedString = "status=ok\n";
        response.setStatus(200);
        returnedString = returnedString + REDIRECT_URL_KEY + "=" + cb;
        ((Writer)w).write(returnedString);
        ((Writer)w).close();
        response.sendRedirect(cb);
    }

    protected ServiceTransaction getAndCheckTransaction(String token) throws IOException {
        DateUtils.checkTimestamp((String)token);
        AuthorizationGrant grant = MyProxyDelegationServlet.getServiceEnvironment().getTokenForge().getAuthorizationGrant(new String[]{token});
        ServiceTransaction trans = (ServiceTransaction)MyProxyDelegationServlet.getServiceEnvironment().getTransactionStore().get(grant);
        if (trans == null) {
            this.warn("Error: no delegation request found for " + token);
            throw new GeneralException("Error: no delegation request found.");
        }
        this.checkClient(trans.getClient());
        return trans;
    }
}

