/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.server.servlet;

import edu.uiuc.ncsa.myproxy.MPCProvider;
import edu.uiuc.ncsa.myproxy.MyProxyConnectable;
import edu.uiuc.ncsa.myproxy.MyProxyServiceFacade;
import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.MyProxyDelegationServlet;
import edu.uiuc.ncsa.myproxy.oa4mp.server.util.JGlobusUtil;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.cache.Cacheable;
import edu.uiuc.ncsa.security.core.exceptions.ConnectionException;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.delegation.server.ServiceTransaction;
import edu.uiuc.ncsa.security.delegation.token.MyX509Certificates;
import edu.uiuc.ncsa.security.delegation.token.ProtectedAsset;
import edu.uiuc.ncsa.security.util.pkcs.CertUtil;
import edu.uiuc.ncsa.security.util.pkcs.MyPKCS10CertRequest;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import javax.security.auth.x500.X500Principal;

public abstract class CRServlet
extends MyProxyDelegationServlet {
    protected abstract void doRealCertRequest(ServiceTransaction var1, String var2) throws Throwable;

    protected void doCertRequest(ServiceTransaction trans, String statusString) throws Throwable {
        if (!this.hasMPConnection(trans)) {
            throw new ConnectionException("Error: There is no currently active MyProxy connection.");
        }
        MyPKCS10CertRequest localCertRequest = trans.getCertReq();
        KeyPair keyPair = null;
        if (trans.getClient().isProxyLimited()) {
            this.info("3.b. starting proxy limited for " + trans.getClient().getIdentifier() + ". Generating keypair and cert request.");
            try {
                keyPair = CRServlet.getServiceEnvironment().getKeyPair();
                localCertRequest = CertUtil.createCertRequest((KeyPair)keyPair);
            }
            catch (GeneralSecurityException e) {
                this.error("3.b. " + e.getMessage());
            }
        }
        LinkedList<X509Certificate> certs = this.getX509Certificates(trans, localCertRequest, statusString);
        this.debug("3.b. Got cert from server, count=" + certs.size());
        LinkedList<X509Certificate> certList = new LinkedList<X509Certificate>();
        if (trans.getClient().isProxyLimited()) {
            this.info("3.b. Limited proxy for client " + trans.getClient().getIdentifier() + ", creating limited cert and signing it.");
            certList.addAll(certs);
            certList.addFirst(JGlobusUtil.createProxyCertificate(certs.getLast(), keyPair.getPrivate(), trans.getCertReq().getPublicKey(), (int)(trans.getLifetime() / 1000L)));
            certs = certList;
        }
        this.debug("3.b. Preparing to return cert chain of " + certs.size() + " to client.");
        MyX509Certificates myCerts = new MyX509Certificates(certs);
        trans.setProtectedAsset((ProtectedAsset)myCerts);
        String userName = trans.getUsername();
        if (CRServlet.getServiceEnvironment().getAuthorizationServletConfig().isReturnDnAsUsername()) {
            if (myCerts.getX509Certificates().length > 0) {
                X500Principal x500Principal = myCerts.getX509Certificates()[0].getSubjectX500Principal();
                userName = x500Principal.getName();
                if (CRServlet.getServiceEnvironment().getAuthorizationServletConfig().isConvertDNToGlobusID()) {
                    userName = JGlobusUtil.toGlobusID(userName);
                }
                this.debug(statusString + ": USERNAME = " + userName);
            } else {
                userName = "no_certificates_found";
            }
            trans.setUsername(userName);
            this.info("3.c. Set username returned to client to first certificate's DN: " + userName);
        }
        trans.setUsername(userName);
        trans.setVerifier(MyProxyDelegationServlet.getServiceEnvironment().getTokenForge().getVerifier(new String[0]));
        CRServlet.getServiceEnvironment().getTransactionStore().save((Identifiable)trans);
        this.getMPConnection(trans.getIdentifier()).close();
    }

    protected LinkedList<X509Certificate> getX509Certificates(ServiceTransaction transaction, MyPKCS10CertRequest localCertRequest, String statusString) throws GeneralSecurityException {
        MyProxyConnectable mpc = this.getMPConnection(transaction);
        LinkedList certs = mpc.getCerts(localCertRequest);
        if (certs.isEmpty()) {
            this.info(statusString + "Error: MyProxy service returned no certs.");
            throw new GeneralException("Error: MyProxy service returned no certs.");
        }
        this.info(statusString + "Got cert from MyProxy, issuing a limited proxy & storing it.");
        return certs;
    }

    protected MyProxyConnectable createMPConnection(Identifier identifier, String userName, String password, long lifetime, String statusString) throws GeneralSecurityException {
        Throwable lastException = null;
        for (MyProxyServiceFacade msp : MyProxyDelegationServlet.getServiceEnvironment().getMyProxyServices()) {
            this.info(statusString + " trying to find MyProxy server " + msp.getFacadeConfiguration().getHostname() + ":" + msp.getFacadeConfiguration().getPort());
            MPCProvider mpcProvider = null;
            try {
                mpcProvider = msp.getMPCProvider(userName, password, null, lifetime);
            }
            catch (IOException e) {
                this.warn("Got IOException connecting to MyProxy:" + e.getMessage());
                throw new GeneralException("IOException getting MyProxy provider:" + e.getMessage(), (Throwable)e);
            }
            MyProxyConnectable mpc = mpcProvider.get();
            mpc.setIdentifier(identifier);
            try {
                mpc.open();
                this.info(statusString + " connection to " + msp.getFacadeConfiguration().getHostname());
                mpc.setIdentifier(identifier);
                CRServlet.getMyproxyConnectionCache().add((Cacheable)mpc);
                return mpc;
            }
            catch (ConnectionException cx) {
                this.info("Benign failure connecting to MyProxy: " + cx.getMessage());
                lastException = cx;
            }
        }
        this.info("Error: No usable MyProxy service found." + statusString);
        if (lastException instanceof GeneralException) {
            throw (GeneralException)lastException;
        }
        throw new GeneralSecurityException("Error: No usable MyProxy service found.", lastException.getCause() == null ? lastException : lastException.getCause());
    }
}

