/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.server.servlet;

import edu.uiuc.ncsa.myproxy.MyProxyConnectable;
import edu.uiuc.ncsa.myproxy.oa4mp.server.ServiceEnvironment;
import edu.uiuc.ncsa.myproxy.oa4mp.server.ServiceEnvironmentImpl;
import edu.uiuc.ncsa.myproxy.oa4mp.server.util.AbstractCLIApprover;
import edu.uiuc.ncsa.myproxy.oa4mp.server.util.ExceptionEvent;
import edu.uiuc.ncsa.myproxy.oa4mp.server.util.ExceptionEventListener;
import edu.uiuc.ncsa.myproxy.oa4mp.server.util.ExceptionEventNotifier;
import edu.uiuc.ncsa.myproxy.oa4mp.server.util.NewClientNotifier;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.cache.Cache;
import edu.uiuc.ncsa.security.core.cache.CachedObject;
import edu.uiuc.ncsa.security.core.cache.Cleanup;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.UnknownClientException;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.HostUtil;
import edu.uiuc.ncsa.security.core.util.QueueWithSpare;
import edu.uiuc.ncsa.security.delegation.server.ExceptionWrapper;
import edu.uiuc.ncsa.security.delegation.server.ServiceTransaction;
import edu.uiuc.ncsa.security.delegation.server.UnapprovedClientException;
import edu.uiuc.ncsa.security.delegation.server.issuers.AGIssuer;
import edu.uiuc.ncsa.security.delegation.server.issuers.ATIssuer;
import edu.uiuc.ncsa.security.delegation.server.request.IssuerResponse;
import edu.uiuc.ncsa.security.delegation.services.AddressableServer;
import edu.uiuc.ncsa.security.delegation.servlet.TransactionFilter;
import edu.uiuc.ncsa.security.delegation.servlet.TransactionState;
import edu.uiuc.ncsa.security.delegation.storage.Client;
import edu.uiuc.ncsa.security.delegation.storage.TransactionStore;
import edu.uiuc.ncsa.security.delegation.storage.impl.BasicTransaction;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import edu.uiuc.ncsa.security.servlet.AbstractServlet;
import edu.uiuc.ncsa.security.servlet.JSPUtil;
import edu.uiuc.ncsa.security.servlet.NotificationListener;
import edu.uiuc.ncsa.security.storage.sql.SQLStore;
import edu.uiuc.ncsa.security.util.mail.MailUtil;
import edu.uiuc.ncsa.security.util.pkcs.KeyPairPopulationThread;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.ProtocolException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;

public abstract class MyProxyDelegationServlet
extends AbstractServlet
implements TransactionFilter {
    public static final String ERROR_NOTIFICATION_BODY_KEY = "oa4mp:server.error.message";
    public static final String ERROR_NOTIFICATION_SUBJECT_KEY = "oa4mp:server.error.subject";
    static List<NotificationListener> notificationListeners = new ArrayList<NotificationListener>();
    public static Cleanup<String, BasicTransaction> transactionCleanup;
    public static Cleanup<Identifier, CachedObject> myproxyConnectionCleanup;
    public static Cache myproxyConnectionCache;
    public static KeyPairPopulationThread kpt;
    static boolean notifiersSet;
    protected static boolean storeUpdatesDone;
    public static AbstractCLIApprover.ClientApprovalThread caThread;

    public abstract ServiceTransaction verifyAndGet(IssuerResponse var1) throws IOException;

    public static void addNotificationListener(NotificationListener notificationListener) {
        if (!notificationListeners.contains(notificationListener)) {
            notificationListeners.add(notificationListener);
        }
    }

    public static boolean removeNotificationListener(NotificationListener notificationListener) {
        return notificationListeners.remove(notificationListener);
    }

    public static Cache getMyproxyConnectionCache() {
        if (myproxyConnectionCache == null) {
            myproxyConnectionCache = new Cache();
        }
        return myproxyConnectionCache;
    }

    public ServiceEnvironmentImpl loadProperties2() throws IOException {
        ServiceEnvironmentImpl se2 = (ServiceEnvironmentImpl)MyProxyDelegationServlet.getConfigurationLoader().load();
        if (se2.isPollingEnabled()) {
            caThread = se2.getClientApprovalThread();
        }
        kpt = new KeyPairPopulationThread((QueueWithSpare)se2.getKeyPairQueue());
        return se2;
    }

    public void loadEnvironment() throws IOException {
        if (environment == null) {
            MyProxyDelegationServlet.setEnvironment((AbstractEnvironment)this.loadProperties2());
        }
    }

    protected AGIssuer getAGI() throws IOException {
        return MyProxyDelegationServlet.getServiceEnvironment().getAgIssuer();
    }

    protected ATIssuer getATI() throws IOException {
        return MyProxyDelegationServlet.getServiceEnvironment().getAtIssuer();
    }

    public static ServiceEnvironment getServiceEnvironment() {
        return (ServiceEnvironment)MyProxyDelegationServlet.getEnvironment();
    }

    String getTemplate(File filename) throws IOException {
        String body = "";
        try {
            FileInputStream fr = new FileInputStream(filename);
            StringBuffer sb = new StringBuffer();
            int z = 0;
            while ((z = fr.read()) != -1) {
                sb.append((char)z);
            }
            body = sb.toString();
            fr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return body;
    }

    public void setupNotifiers() throws IOException {
        if (notifiersSet) {
            return;
        }
        NewClientNotifier newClientNotifier = new NewClientNotifier(MyProxyDelegationServlet.getServiceEnvironment().getMailUtil(), this.getMyLogger());
        MyProxyDelegationServlet.addNotificationListener(newClientNotifier);
        MailUtil x = new MailUtil(MyProxyDelegationServlet.getServiceEnvironment().getMailUtil().getMailEnvironment());
        String fName = this.getServletContext().getInitParameter(ERROR_NOTIFICATION_SUBJECT_KEY);
        if (fName == null) {
            this.info("No error notification subject set. Skipping...");
            notifiersSet = true;
            return;
        }
        this.info("Set error notification subject to " + fName);
        x.setSubjectTemplate(this.getTemplate(new File(fName)));
        fName = this.getServletContext().getInitParameter(ERROR_NOTIFICATION_BODY_KEY);
        if (fName == null) {
            this.info("No error notification message body set. Skipping...");
            notifiersSet = true;
            return;
        }
        this.info("Set error notification message body to " + fName);
        x.setMessageTemplate(this.getTemplate(new File(fName)));
        ExceptionEventNotifier exceptionNotifier = new ExceptionEventNotifier(x, this.getMyLogger());
        MyProxyDelegationServlet.addNotificationListener(exceptionNotifier);
        notifiersSet = true;
    }

    public void storeUpdates() throws IOException, SQLException {
        if (storeUpdatesDone) {
            return;
        }
        storeUpdatesDone = true;
        this.processStoreCheck((Store)this.getTransactionStore());
        this.processStoreCheck((Store)MyProxyDelegationServlet.getServiceEnvironment().getClientStore());
        this.processStoreCheck((Store)MyProxyDelegationServlet.getServiceEnvironment().getClientApprovalStore());
    }

    protected void processStoreCheck(Store store) throws SQLException {
        if (store instanceof SQLStore) {
            ((SQLStore)store).checkColumns();
        }
    }

    protected void shutdownCleanup(Cleanup c) {
        if (c != null && !c.isStopThread()) {
            c.setStopThread(true);
            c.interrupt();
        }
    }

    public void destroy() {
        super.destroy();
        this.shutdownCleanup(transactionCleanup);
        this.shutdownCleanup(myproxyConnectionCleanup);
        if (caThread != null) {
            caThread.setStopThread(true);
        }
        if (kpt != null) {
            kpt.setStopThread(true);
        }
    }

    protected TransactionStore getTransactionStore() throws IOException {
        return MyProxyDelegationServlet.getServiceEnvironment().getTransactionStore();
    }

    public Client getClient(HttpServletRequest req) {
        Identifier id = BasicIdentifier.newID((String)req.getParameter(MyProxyDelegationServlet.CONST((String)"oa4mp:client_id")));
        return this.getClient(id);
    }

    public Client getClient(Identifier identifier) {
        if (identifier == null) {
            throw new UnknownClientException("no client id");
        }
        Client c = (Client)MyProxyDelegationServlet.getServiceEnvironment().getClientStore().get((Object)identifier);
        if (c == null) {
            String ww = "The client with identifier \"" + identifier.toString() + "\"  cannot be found.  Is the value in the client config correct?";
            this.warn(ww);
            throw new UnknownClientException(ww, identifier);
        }
        this.checkClient(c);
        return c;
    }

    public ServiceTransaction newTransaction() throws IOException {
        return (ServiceTransaction)MyProxyDelegationServlet.getServiceEnvironment().getTransactionStore().create();
    }

    protected ServiceTransaction getTransaction(AuthorizationGrant grant) throws IOException {
        return (ServiceTransaction)this.getTransactionStore().get(grant);
    }

    protected Client getClient(AuthorizationGrant authorizationGrant) throws IOException {
        ServiceTransaction transaction = this.getTransaction(authorizationGrant);
        return transaction.getClient();
    }

    public void checkClient(Client client) {
        if (!MyProxyDelegationServlet.getServiceEnvironment().getClientApprovalStore().isApproved(client.getIdentifier())) {
            String ww = "The client with identifier \"" + client.getIdentifier() + "\" has not been approved. Request rejected. Please contact your administrator.";
            this.warn(ww);
            throw new UnapprovedClientException("Error: " + ww, client);
        }
    }

    protected boolean isEmpty(String x) {
        return x == null || x.length() == 0;
    }

    public void preprocess(TransactionState state) throws Throwable {
        state.getResponse().setHeader("X-Frame-Options", "DENY");
    }

    public void postprocess(TransactionState state) throws Throwable {
    }

    protected void setRedirect(Throwable t, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String x;
        if (this.isDebugOn()) {
            t.printStackTrace();
        }
        if (!(x = ((AddressableServer)MyProxyDelegationServlet.getServiceEnvironment().getAgIssuer()).getAddress().toString()).endsWith("/")) {
            x = x + "/";
        }
        response.setHeader("X-Frame-Options", "DENY");
        Throwable cause = t;
        Client client = null;
        String identifier = "";
        if (t instanceof ExceptionWrapper) {
            ExceptionWrapper ew = (ExceptionWrapper)t;
            cause = ew.getCause();
            client = ew.getClient();
            if (client.getIdentifier() != null) {
                identifier = client.getIdentifierString();
            }
        }
        String causeName = cause.getClass().getSimpleName();
        String message = URLEncoder.encode(cause.getMessage(), "UTF-8");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(baos);
        cause.printStackTrace(printStream);
        printStream.flush();
        printStream.close();
        String stackTrace = Base64.encodeBase64URLSafeString((byte[])baos.toByteArray());
        if (cause instanceof UnknownClientException || cause instanceof UnapprovedClientException) {
            throw (GeneralException)cause;
        }
        response.sendRedirect(x + "error" + "?" + "cause" + "=" + causeName + "&" + "identifier" + "=" + identifier + "&" + "stackTrace" + "=" + stackTrace + "&" + "message" + "=" + message);
    }

    protected void fireExceptionCaught(Throwable throwable, Map<String, String> state) {
        for (NotificationListener notificationListener : notificationListeners) {
            if (!(notificationListener instanceof ExceptionEventListener)) continue;
            ((ExceptionEventListener)notificationListener).fireExceptionCaught(new ExceptionEvent((Object)this, throwable, state));
        }
    }

    protected void handleException(Throwable t, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        t.printStackTrace();
        if (MyProxyDelegationServlet.getServiceEnvironment().isDebugOn()) {
            t.printStackTrace();
        }
        this.getMyLogger().error("Error!", t);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        if (t.getCause() != null) {
            t.getCause().printStackTrace(pw);
        } else {
            t.printStackTrace(pw);
        }
        pw.flush();
        pw.close();
        String stacktrace = new String(baos.toByteArray());
        this.error("INTERNAL ERROR: " + (t.getMessage() == null ? "(no message)" : t.getMessage()));
        this.error(stacktrace);
        if (t instanceof UnknownClientException || t instanceof UnapprovedClientException) {
            throw (GeneralException)t;
        }
        boolean doClientDebug = false;
        request.setAttribute("message", (Object)((t.getCause() == null ? t.getMessage() : t.getCause().getMessage()) + "\n"));
        request.setAttribute("clientIP", (Object)(request.getRemoteAddr() + "\n"));
        try {
            request.setAttribute("clientHost", (Object)(HostUtil.reverseLookup((String)request.getRemoteAddr()) + "\n"));
        }
        catch (UnknownHostException ux) {
            request.setAttribute("clientHost", (Object)"could not resolve client IP to a host\n");
        }
        if (doClientDebug) {
            HashMap<String, String> state = new HashMap<String, String>();
            state.put("servletEngine", this.getServletContext().getServerInfo() + " ");
            state.put("host", request.getServerName() + ":" + request.getServerPort() + "\n");
            state.put("client", request.getRemoteHost() + "\n");
            state.put("servlet", this.getServletName() + "\n");
            state.put("url", request.getRequestURI() + "\n");
            Cookie[] cookies = request.getCookies();
            String cc = "";
            if (cookies == null) {
                cc = "(none)";
            } else {
                for (Cookie cookie : cookies) {
                    cc = cc + cookie.getName() + " : " + cookie.getValue() + "\n";
                }
            }
            state.put("cookies", cc);
            state.put("message", t.getMessage() + "\n");
            state.put("stackTrace", stacktrace);
            this.fireExceptionCaught(t, state);
            this.setRedirect(t, request, response);
        } else if (t.getCause() != null) {
            if (t.getCause() instanceof FailedLoginException || t.getCause() instanceof LoginException) {
                JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)"/failedLogin.jsp");
                return;
            }
            if (t.getCause() instanceof ProtocolException) {
                JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)"/failedLogin.jsp");
                return;
            }
        }
        JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)"/oops.jsp");
    }

    protected boolean hasMPConnection(Identifier identifier) {
        return MyProxyDelegationServlet.getMyproxyConnectionCache().containsKey((Object)identifier);
    }

    protected boolean hasMPConnection(ServiceTransaction transaction) {
        return this.hasMPConnection(transaction.getIdentifier());
    }

    protected MyProxyConnectable getMPConnection(ServiceTransaction transaction) {
        return this.getMPConnection(transaction.getIdentifier());
    }

    protected MyProxyConnectable getMPConnection(Identifier identifier) {
        return (MyProxyConnectable)MyProxyDelegationServlet.getMyproxyConnectionCache().get((Object)identifier).getValue();
    }

    protected Map<String, String> getFirstParameters(HttpServletRequest req) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Object key : req.getParameterMap().keySet()) {
            map.put(key.toString(), this.getFirstParameterValue(req, key.toString()));
        }
        return map;
    }

    static {
        myproxyConnectionCleanup = null;
        notifiersSet = false;
        storeUpdatesDone = false;
        caThread = null;
    }
}

