/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.server.servlet;

import edu.uiuc.ncsa.myproxy.MyProxyConnectable;
import edu.uiuc.ncsa.myproxy.oa4mp.server.ServiceEnvironmentImpl;
import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.MyProxyDelegationServlet;
import edu.uiuc.ncsa.myproxy.oa4mp.server.util.AbstractCLIApprover;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.cache.Cache;
import edu.uiuc.ncsa.security.core.cache.CachedObject;
import edu.uiuc.ncsa.security.core.cache.Cleanup;
import edu.uiuc.ncsa.security.core.cache.RetentionPolicy;
import edu.uiuc.ncsa.security.core.cache.ValidTimestampPolicy;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.servlet.AbstractServlet;
import edu.uiuc.ncsa.security.servlet.Initialization;
import edu.uiuc.ncsa.security.util.pkcs.KeyPairPopulationThread;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;

public class OA4MPServletInitializer
implements Initialization {
    protected static boolean isInitRun = false;
    AbstractEnvironment environment;
    AbstractServlet servlet;

    public AbstractEnvironment getEnvironment() {
        return this.environment;
    }

    public void init() throws ServletException {
        KeyPairPopulationThread kpt;
        AbstractCLIApprover.ClientApprovalThread caThread;
        Cleanup<Identifier, CachedObject> myproxyConnectionCleanup;
        if (isInitRun) {
            return;
        }
        isInitRun = true;
        MyProxyDelegationServlet mps = (MyProxyDelegationServlet)this.getServlet();
        try {
            mps.storeUpdates();
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
            throw new ServletException("Could not update table", (Throwable)e);
        }
        Cleanup transactionCleanup = MyProxyDelegationServlet.transactionCleanup;
        ServiceEnvironmentImpl env = (ServiceEnvironmentImpl)this.getEnvironment();
        MyLoggingFacade logger = env.getMyLogger();
        if (transactionCleanup == null) {
            MyProxyDelegationServlet.transactionCleanup = transactionCleanup = new Cleanup(logger);
            transactionCleanup.setStopThread(false);
            transactionCleanup.setMap(env.getTransactionStore());
            transactionCleanup.addRetentionPolicy((RetentionPolicy)new ValidTimestampPolicy());
            transactionCleanup.start();
            logger.info("Starting transaction store cleanup thread");
        }
        if ((myproxyConnectionCleanup = MyProxyDelegationServlet.myproxyConnectionCleanup) == null) {
            MyProxyDelegationServlet.myproxyConnectionCleanup = myproxyConnectionCleanup = new Cleanup<Identifier, CachedObject>(logger){

                public List<CachedObject> age() {
                    List x = super.age();
                    for (CachedObject co : x) {
                        Object mp = co.getValue();
                        if (!(mp instanceof MyProxyConnectable)) continue;
                        try {
                            ((MyProxyConnectable)mp).close();
                        }
                        catch (Throwable t) {}
                    }
                    return x;
                }
            };
            myproxyConnectionCleanup.setStopThread(false);
            Cache myproxyConnectionCache = MyProxyDelegationServlet.myproxyConnectionCache;
            if (myproxyConnectionCache == null) {
                MyProxyDelegationServlet.myproxyConnectionCache = myproxyConnectionCache = new Cache();
            }
            myproxyConnectionCleanup.setMap((Map)myproxyConnectionCache);
            myproxyConnectionCleanup.addRetentionPolicy((RetentionPolicy)new ValidTimestampPolicy(10000L));
            myproxyConnectionCleanup.start();
            logger.info("Starting myproxy connection cache cleanup thread");
        }
        if ((caThread = MyProxyDelegationServlet.caThread) != null && !caThread.isAlive()) {
            caThread.setStopThread(false);
            caThread.start();
        }
        if ((kpt = MyProxyDelegationServlet.kpt) != null && !kpt.isAlive()) {
            kpt.setStopThread(false);
            kpt.start();
        }
        try {
            mps.setupNotifiers();
        }
        catch (IOException e) {
            throw new GeneralException("Error: could not set up notifiers ", (Throwable)e);
        }
    }

    public void setEnvironment(AbstractEnvironment environment) {
        this.environment = environment;
    }

    public AbstractServlet getServlet() {
        return this.servlet;
    }

    public void setServlet(AbstractServlet servlet) {
        this.servlet = servlet;
    }
}

