/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.server.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.MyProxyDelegationServlet;
import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.PresentationState;
import edu.uiuc.ncsa.myproxy.oa4mp.server.util.NewClientEvent;
import edu.uiuc.ncsa.myproxy.oa4mp.server.util.NewClientListener;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.delegation.server.ServiceTransaction;
import edu.uiuc.ncsa.security.delegation.server.request.IssuerResponse;
import edu.uiuc.ncsa.security.delegation.server.storage.ClientApproval;
import edu.uiuc.ncsa.security.delegation.servlet.TransactionState;
import edu.uiuc.ncsa.security.delegation.storage.Client;
import edu.uiuc.ncsa.security.servlet.JSPUtil;
import edu.uiuc.ncsa.security.servlet.NotificationListener;
import edu.uiuc.ncsa.security.servlet.Presentable;
import edu.uiuc.ncsa.security.servlet.PresentableState;
import edu.uiuc.ncsa.security.util.pkcs.KeyUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RegistrationServlet
extends MyProxyDelegationServlet
implements Presentable {
    public static final String CLIENT_NAME = "clientName";
    public static final String CLIENT_PUBLIC_KEY = "clientPublicKey";
    public static final String CLIENT_HOME_URL = "clientHomeUrl";
    public static final String CLIENT_ERROR_URL = "clientErrorUrl";
    public static final String CLIENT_EMAIL = "clientEmail";
    public static final String CLIENT_PROXY_LIMITED = "clientProxyLimited";
    public static final String CLIENT_ACTION_KEY = "action";
    public static final String CLIENT_ACTION_REQUEST_VALUE = "request";
    protected static final int INITIAL_STATE = 0;
    protected static final int ERROR_STATE = -1;
    protected static final int REQUEST_STATE = 100;
    public static String INIT_PAGE = "/registration-init.jsp";
    public static String ERROR_PAGE = "/registration-error.jsp";
    public static String OK_PAGE = "/registration-ok.jsp";

    @Override
    public ServiceTransaction verifyAndGet(IssuerResponse iResponse) throws IOException {
        return null;
    }

    public int getState(HttpServletRequest request) {
        String action = request.getParameter(CLIENT_ACTION_KEY);
        if (action == null) {
            return 0;
        }
        if (action.equals(CLIENT_ACTION_REQUEST_VALUE)) {
            return 100;
        }
        return -1;
    }

    protected void fireNewClientEvent(Client client) {
        for (NotificationListener notificationListener : notificationListeners) {
            if (!(notificationListener instanceof NewClientListener)) continue;
            ((NewClientListener)notificationListener).fireNewClientEvent(new NewClientEvent((Object)this, client));
        }
    }

    public void prepare(PresentableState state) throws Throwable {
        this.preprocess(new TransactionState(state.getRequest(), state.getResponse(), null, null));
        switch (state.getState()) {
            case 0: {
                HttpServletRequest request = state.getRequest();
                this.info("Processing new client registration request.");
                request.setAttribute(CLIENT_NAME, (Object)CLIENT_NAME);
                request.setAttribute(CLIENT_PUBLIC_KEY, (Object)CLIENT_PUBLIC_KEY);
                request.setAttribute(CLIENT_HOME_URL, (Object)CLIENT_HOME_URL);
                request.setAttribute(CLIENT_ERROR_URL, (Object)CLIENT_ERROR_URL);
                request.setAttribute(CLIENT_EMAIL, (Object)CLIENT_EMAIL);
                request.setAttribute(CLIENT_PROXY_LIMITED, (Object)CLIENT_PROXY_LIMITED);
                request.setAttribute(CLIENT_ACTION_KEY, (Object)CLIENT_ACTION_KEY);
                request.setAttribute(CLIENT_ACTION_REQUEST_VALUE, (Object)CLIENT_ACTION_REQUEST_VALUE);
                request.setAttribute("actionToTake", (Object)(request.getContextPath() + "/register"));
                break;
            }
            case 100: {
                return;
            }
            default: {
                this.warn("Error: unknown action request.");
            }
        }
    }

    public void present(PresentableState state) throws Throwable {
        this.postprocess(new TransactionState(state.getRequest(), state.getResponse(), null, null));
        switch (state.getState()) {
            case 0: {
                JSPUtil.fwd((HttpServletRequest)state.getRequest(), (HttpServletResponse)state.getResponse(), (String)INIT_PAGE);
                break;
            }
            case 100: {
                if (state instanceof ClientState) {
                    ClientState cState = (ClientState)state;
                    state.getRequest().setAttribute("client", (Object)cState.getClient());
                    JSPUtil.fwd((HttpServletRequest)state.getRequest(), (HttpServletResponse)state.getResponse(), (String)OK_PAGE);
                    break;
                }
                throw new IllegalStateException("Error: An instance of ClientState was expected, but got an instance of \"" + state.getClass().getName() + "\"");
            }
        }
    }

    public void handleError(PresentableState state, Throwable t) throws IOException, ServletException {
        state.getResponse().setHeader("X-Frame-Options", "DENY");
        JSPUtil.handleException((Throwable)t, (HttpServletRequest)state.getRequest(), (HttpServletResponse)state.getResponse(), (String)ERROR_PAGE);
    }

    protected void doIt(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        if (!request.isSecure()) {
            throw new ServletException("Unsupported protocol");
        }
        int state = this.getState(request);
        if (state == 0 && RegistrationServlet.getServiceEnvironment().getMaxAllowedNewClientRequests() <= RegistrationServlet.getServiceEnvironment().getClientApprovalStore().getUnapprovedCount()) {
            this.log("Too many client approvals pending. Max allowed unapproved is: " + RegistrationServlet.getServiceEnvironment().getMaxAllowedNewClientRequests());
            JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tooManyClientRequests.jsp");
            return;
        }
        PresentationState pState = new PresentationState(state, request, response);
        try {
            this.prepare(pState);
            if (state == 100) {
                Client client = this.addNewClient(request, response);
                pState = new ClientState(state, request, response, client);
            }
            this.present(pState);
        }
        catch (Throwable t) {
            this.warn("Error registering a new client:" + t.getMessage());
            this.handleError(pState, t);
        }
    }

    protected String getRequiredParam(HttpServletRequest req, String key) {
        String x = req.getParameter(key);
        if (x == null || x.length() == 0) {
            throw new IllegalArgumentException("Error: missing parameter for " + key);
        }
        return x;
    }

    boolean getBooleanParam(HttpServletRequest req, String key) {
        String x = req.getParameter(key);
        if (x == null || x.length() == 0) {
            return false;
        }
        return Boolean.parseBoolean(x);
    }

    protected Client addNewClient(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        Client client = (Client)RegistrationServlet.getServiceEnvironment().getClientStore().create();
        this.info("creating entry for client=" + client.getIdentifierString());
        client.setName(this.getRequiredParam(request, CLIENT_NAME));
        client.setSecret(this.getRequiredParam(request, CLIENT_PUBLIC_KEY));
        client.setErrorUri(this.getRequiredParam(request, CLIENT_ERROR_URL));
        client.setHomeUri(this.getRequiredParam(request, CLIENT_HOME_URL));
        client.setEmail(this.getRequiredParam(request, CLIENT_EMAIL));
        client.setProxyLimited(this.getBooleanParam(request, CLIENT_PROXY_LIMITED));
        try {
            this.debug("decoding public key from PEM");
            KeyUtil.fromX509PEM((String)client.getSecret());
        }
        catch (Throwable t) {
            this.warn("could not decode public key for client=" + client.getIdentifierString() + ", message:" + t.getMessage());
            request.setAttribute("client", (Object)client);
            throw t;
        }
        RegistrationServlet.getServiceEnvironment().getClientStore().save((Identifiable)client);
        this.info("Adding approval record for client=" + client.getIdentifierString());
        ClientApproval clientApproval = new ClientApproval(client.getIdentifier());
        clientApproval.setApproved(false);
        RegistrationServlet.getServiceEnvironment().getClientApprovalStore().save((Identifiable)clientApproval);
        this.fireNewClientEvent(client);
        this.info("done with client registration, client=" + client.getIdentifierString());
        return client;
    }

    public static void approveClient(Identifier clientIdentifier, String approver) throws IOException {
        ClientApproval clientApproval = (ClientApproval)RegistrationServlet.getServiceEnvironment().getClientApprovalStore().get((Object)clientIdentifier);
        if (approver == null) {
            approver = "";
        }
        clientApproval.setApprover(approver);
        clientApproval.setApproved(true);
        RegistrationServlet.getServiceEnvironment().getClientApprovalStore().save((Identifiable)clientApproval);
    }

    protected boolean sendNotification(Client client) throws IOException {
        if (!RegistrationServlet.getServiceEnvironment().getMailUtil().isEnabled()) {
            return true;
        }
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("name", client.getName());
        replacements.put("email", client.getEmail());
        replacements.put("homeUri", client.getHomeUri());
        replacements.put("failureUri", client.getErrorUri());
        replacements.put("creationTime", client.getCreationTS().toString());
        replacements.put("identifier", client.getIdentifierString());
        replacements.put("limitedProxy", Boolean.toString(client.isProxyLimited()));
        try {
            replacements.put("host", InetAddress.getLocalHost().getCanonicalHostName());
        }
        catch (Throwable t) {
            this.warn("Warning: Could not resolve localhost to its canonical name.");
            replacements.put("host", "localhost");
        }
        boolean rc = RegistrationServlet.getServiceEnvironment().getMailUtil().sendMessage(replacements);
        if (rc) {
            this.info("sending email notification for client " + client.getIdentifierString());
        } else {
            this.info("failure sending email notification for client " + client.getIdentifierString());
        }
        return rc;
    }

    static class ClientState
    extends PresentationState {
        Client client;

        ClientState(int state, HttpServletRequest request, HttpServletResponse response, Client client) {
            super(state, request, response);
            this.client = client;
        }

        public Client getClient() {
            return this.client;
        }
    }
}

