/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.server.servlet;

import edu.uiuc.ncsa.myproxy.MyProxyServiceFacade;
import edu.uiuc.ncsa.myproxy.oa4mp.server.ClientApprovalProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.server.DSTransactionProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.server.MyProxyFacadeProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.server.OA4MPServiceTransaction;
import edu.uiuc.ncsa.myproxy.oa4mp.server.ServiceEnvironmentImpl;
import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.AuthorizationServletConfig;
import edu.uiuc.ncsa.myproxy.oa4mp.server.storage.MultiDSClientApprovalStoreProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.server.storage.MultiDSClientStoreProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.server.storage.MultiDSTransactionStoreProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.server.storage.filestore.DSFSClientApprovalStoreProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.server.storage.filestore.DSFSClientStoreProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.server.storage.filestore.DSFSTransactionStoreProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.server.storage.sql.provider.DSClientSQLStoreProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.server.storage.sql.provider.DSSQLClientApprovalStoreProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.server.storage.sql.provider.DSSQLTransactionStoreProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.server.util.AbstractCLIApprover;
import edu.uiuc.ncsa.myproxy.oa4mp.server.util.ClientApproverConverter;
import edu.uiuc.ncsa.myproxy.oa4mp.server.util.TransactionConverter;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.configuration.Configurations;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEvent;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEventListener;
import edu.uiuc.ncsa.security.core.configuration.provider.TypedProvider;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.IdentifiableProviderImpl;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.delegation.server.issuers.AGIssuer;
import edu.uiuc.ncsa.security.delegation.server.issuers.ATIssuer;
import edu.uiuc.ncsa.security.delegation.server.issuers.PAIssuer;
import edu.uiuc.ncsa.security.delegation.server.storage.ClientApproval;
import edu.uiuc.ncsa.security.delegation.server.storage.ClientApprovalStore;
import edu.uiuc.ncsa.security.delegation.server.storage.ClientStore;
import edu.uiuc.ncsa.security.delegation.server.storage.impl.ClientApprovalMemoryStore;
import edu.uiuc.ncsa.security.delegation.server.storage.impl.ClientMemoryStore;
import edu.uiuc.ncsa.security.delegation.servlet.StorageConfigLoader;
import edu.uiuc.ncsa.security.delegation.storage.Client;
import edu.uiuc.ncsa.security.delegation.storage.TransactionStore;
import edu.uiuc.ncsa.security.delegation.storage.impl.ClientConverter;
import edu.uiuc.ncsa.security.delegation.storage.impl.TransactionMemoryStore;
import edu.uiuc.ncsa.security.delegation.token.TokenForge;
import edu.uiuc.ncsa.security.servlet.TrivialUsernameTransformer;
import edu.uiuc.ncsa.security.servlet.UsernameTransformer;
import edu.uiuc.ncsa.security.servlet.mail.ServletMailUtilProvider;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPoolProvider;
import edu.uiuc.ncsa.security.util.mail.MailUtilProvider;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Provider;
import org.apache.commons.configuration.tree.ConfigurationNode;

public abstract class ServerConfigurationLoader<T extends ServiceEnvironmentImpl>
extends StorageConfigLoader<T> {
    protected MultiDSClientStoreProvider csp;
    protected MultiDSClientApprovalStoreProvider casp;
    protected LinkedList<MyProxyFacadeProvider> mfp = null;
    protected MailUtilProvider mup = null;
    protected ServiceEnvironmentImpl.MessagesProvider messagesProvider = null;
    protected AuthorizationServletConfig authorizationServletConfig;
    protected Provider<TransactionStore> tsp;
    int maxAllowedNewClientRequests = -1;
    URI address;

    boolean getCfgBoolean(ConfigurationNode sn, String tagName, boolean defaultValue) {
        String x = Configurations.getFirstAttribute((ConfigurationNode)sn, (String)tagName);
        if (x == null || x.length() == 0) {
            return defaultValue;
        }
        boolean b = defaultValue;
        try {
            b = Boolean.parseBoolean(x);
        }
        catch (Throwable t) {
            return defaultValue;
        }
        return b;
    }

    public AuthorizationServletConfig getAuthorizationServletConfig() {
        if (this.authorizationServletConfig == null) {
            List kids = this.cn.getChildren("authorizationServlet");
            String headFieldName = null;
            boolean requiredHeader = false;
            boolean useheader = false;
            boolean showLogon = true;
            boolean verifyUsername = true;
            boolean returnDnAsUsername = false;
            boolean convertDNToGlobusID = false;
            if (!kids.isEmpty()) {
                ConfigurationNode sn = (ConfigurationNode)kids.get(0);
                try {
                    useheader = this.getCfgBoolean(sn, "useHeader", useheader);
                    requiredHeader = this.getCfgBoolean(sn, "requireHeader", requiredHeader);
                    headFieldName = Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"headerFieldName");
                    returnDnAsUsername = this.getCfgBoolean(sn, "returnDnAsUsername", returnDnAsUsername);
                    showLogon = this.getCfgBoolean(sn, "showLogon", showLogon);
                    verifyUsername = this.getCfgBoolean(sn, "verifyUsername", verifyUsername);
                    convertDNToGlobusID = this.getCfgBoolean(sn, "convertDNToGlobusID", convertDNToGlobusID);
                }
                catch (Throwable t) {
                    this.info("Error loading authorization configuration. Disabling use of headers");
                }
            }
            this.authorizationServletConfig = new AuthorizationServletConfig(useheader, requiredHeader, headFieldName, returnDnAsUsername, showLogon, verifyUsername, convertDNToGlobusID);
        }
        return this.authorizationServletConfig;
    }

    public ServerConfigurationLoader(ConfigurationNode node, MyLoggingFacade logger) {
        super(node, logger);
        String x = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"disableDefaultStores");
        if (x != null) {
            this.isDefaultStoreDisabled(new boolean[]{Boolean.parseBoolean(x)});
        }
    }

    public ServerConfigurationLoader(ConfigurationNode node) {
        this(node, null);
    }

    public abstract Provider<ClientStore> getClientStoreProvider();

    public abstract Provider<ClientApprovalStore> getClientApprovalStoreProvider();

    public abstract Provider<TransactionStore> getTransactionStoreProvider();

    public abstract Provider<TokenForge> getTokenForgeProvider();

    public abstract Provider<AGIssuer> getAGIProvider();

    public abstract Provider<ATIssuer> getATIProvider();

    public abstract Provider<PAIssuer> getPAIProvider();

    public abstract HashMap<String, String> getConstants();

    public abstract IdentifiableProvider<? extends Client> getClientProvider();

    public Object[] loadPolling() {
        File pollingDir = null;
        Long pollingInt = 1000L;
        String pd = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"pollingDirectory");
        String pi = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"pollingInterval");
        if (pd != null && 0 < pd.length()) {
            pollingDir = new File(pd);
            if (!pollingDir.exists()) {
                this.info("WARNING: the given polling directory \"" + pd + "\" does not exist. Polling disabled.");
                pollingDir = null;
            } else if (pollingDir.isDirectory()) {
                this.info("polling directory set to \"" + pollingDir.getAbsolutePath() + "\"");
            } else {
                pollingDir = pollingDir.getParentFile();
                this.info("WARNING: the given polling directory \"" + pd + "\" does not exist. Polling set to " + pollingDir.getAbsolutePath());
            }
            if (pollingDir != null && pi != null) {
                try {
                    pollingInt = Long.parseLong(pi);
                    this.info("Polling interval set to " + pollingInt + " ms.");
                }
                catch (Throwable t) {
                    this.info("WARNING: the polling interval of \"" + pi + "\" could not be interpreted. Using default.");
                }
            }
        } else {
            this.info("No polling configured.");
        }
        if (pollingDir == null) {
            return null;
        }
        return new Object[]{pollingDir, pollingInt};
    }

    protected Provider<TransactionStore> getTSP() {
        if (this.tsp == null) {
            final DSTransactionProvider tp = new DSTransactionProvider();
            TransactionConverter tc = new TransactionConverter(tp, (TokenForge)this.getTokenForgeProvider().get(), (ClientStore<? extends Client>)((ClientStore<Client>)((ClientStore<? extends Client>)((ClientStore)this.getCSP().get()))));
            MultiDSTransactionStoreProvider storeProvider = new MultiDSTransactionStoreProvider(this.cn, this.isDefaultStoreDisabled(new boolean[0]), (MyLoggingFacade)this.loggerProvider.get(), tp);
            storeProvider.addListener((CfgEventListener)new DSSQLTransactionStoreProvider(this.cn, (ConnectionPoolProvider<ConnectionPool>)((ConnectionPoolProvider<? extends ConnectionPool>)this.getMySQLConnectionPoolProvider()), "mysql", this.getCSP(), (Provider<OA4MPServiceTransaction>)tp, this.getTokenForgeProvider(), (MapConverter)tc));
            storeProvider.addListener((CfgEventListener)new DSSQLTransactionStoreProvider(this.cn, (ConnectionPoolProvider<ConnectionPool>)((ConnectionPoolProvider<? extends ConnectionPool>)this.getMariaDBConnectionPoolProvider()), "mariadb", this.getCSP(), (Provider<OA4MPServiceTransaction>)tp, this.getTokenForgeProvider(), (MapConverter)tc));
            storeProvider.addListener((CfgEventListener)new DSSQLTransactionStoreProvider(this.cn, (ConnectionPoolProvider<ConnectionPool>)((ConnectionPoolProvider<? extends ConnectionPool>)this.getPgConnectionPoolProvider()), "postgresql", this.getCSP(), (Provider<OA4MPServiceTransaction>)tp, this.getTokenForgeProvider(), (MapConverter)tc));
            storeProvider.addListener((CfgEventListener)new DSFSTransactionStoreProvider(this.cn, (IdentifiableProvider<OA4MPServiceTransaction>)tp, this.getTokenForgeProvider(), tc));
            storeProvider.addListener((CfgEventListener)new TypedProvider<TransactionStore>(this.cn, "memoryStore", "transactions"){

                public Object componentFound(CfgEvent configurationEvent) {
                    if (this.checkEvent(configurationEvent)) {
                        return this.get();
                    }
                    return null;
                }

                public TransactionStore get() {
                    return new TransactionMemoryStore((IdentifiableProvider)tp);
                }
            });
            this.tsp = storeProvider;
        }
        return this.tsp;
    }

    protected MultiDSClientStoreProvider getCSP() {
        if (this.csp == null) {
            ClientConverter converter = new ClientConverter(this.getClientProvider());
            this.csp = new MultiDSClientStoreProvider(this.cn, this.isDefaultStoreDisabled(new boolean[0]), (MyLoggingFacade)this.loggerProvider.get(), null, null, this.getClientProvider());
            this.csp.addListener((CfgEventListener)new DSFSClientStoreProvider(this.cn, (MapConverter<Client>)converter, (Provider<? extends Client>)this.getClientProvider()));
            this.csp.addListener((CfgEventListener)new DSClientSQLStoreProvider((ConnectionPoolProvider<ConnectionPool>)((ConnectionPoolProvider<? extends ConnectionPool>)this.getMySQLConnectionPoolProvider()), "mysql", (MapConverter)converter, (Provider<Client>)this.getClientProvider()));
            this.csp.addListener((CfgEventListener)new DSClientSQLStoreProvider((ConnectionPoolProvider<ConnectionPool>)((ConnectionPoolProvider<? extends ConnectionPool>)this.getMariaDBConnectionPoolProvider()), "mariadb", (MapConverter)converter, (Provider<Client>)this.getClientProvider()));
            this.csp.addListener((CfgEventListener)new DSClientSQLStoreProvider((ConnectionPoolProvider<ConnectionPool>)((ConnectionPoolProvider<? extends ConnectionPool>)this.getPgConnectionPoolProvider()), "postgresql", (MapConverter)converter, (Provider<Client>)this.getClientProvider()));
            this.csp.addListener((CfgEventListener)new TypedProvider<ClientStore>(this.cn, "memoryStore", "clients"){

                public Object componentFound(CfgEvent configurationEvent) {
                    if (this.checkEvent(configurationEvent)) {
                        return this.get();
                    }
                    return null;
                }

                public ClientStore get() {
                    return new ClientMemoryStore(ServerConfigurationLoader.this.getClientProvider());
                }
            });
        }
        return this.csp;
    }

    protected MultiDSClientApprovalStoreProvider getCASP() {
        if (this.casp == null) {
            this.casp = new MultiDSClientApprovalStoreProvider(this.cn, this.isDefaultStoreDisabled(new boolean[0]), (MyLoggingFacade)this.loggerProvider.get());
            final ClientApprovalProvider caProvider = new ClientApprovalProvider();
            ClientApproverConverter<ClientApproval> cp = new ClientApproverConverter<ClientApproval>(caProvider);
            this.casp.addListener((CfgEventListener)new DSFSClientApprovalStoreProvider(this.cn, cp));
            this.casp.addListener((CfgEventListener)new DSSQLClientApprovalStoreProvider(this.cn, (ConnectionPoolProvider<? extends ConnectionPool>)this.getMySQLConnectionPoolProvider(), "mysql", cp));
            this.casp.addListener((CfgEventListener)new DSSQLClientApprovalStoreProvider(this.cn, (ConnectionPoolProvider<? extends ConnectionPool>)this.getMariaDBConnectionPoolProvider(), "mariadb", cp));
            this.casp.addListener((CfgEventListener)new DSSQLClientApprovalStoreProvider(this.cn, (ConnectionPoolProvider<? extends ConnectionPool>)this.getPgConnectionPoolProvider(), "postgresql", cp));
            this.casp.addListener((CfgEventListener)new TypedProvider<ClientApprovalStore>(this.cn, "memoryStore", "clientApprovals"){

                public Object componentFound(CfgEvent configurationEvent) {
                    if (this.checkEvent(configurationEvent)) {
                        return this.get();
                    }
                    return null;
                }

                public ClientApprovalStore get() {
                    return new ClientApprovalMemoryStore((IdentifiableProviderImpl)caProvider);
                }
            });
        }
        return this.casp;
    }

    protected LinkedList<MyProxyFacadeProvider> getMyProxyFacadeProvider() {
        if (this.mfp == null) {
            this.mfp = new LinkedList();
            if (0 < this.cn.getChildrenCount("myproxy")) {
                List kids = this.cn.getChildren("myproxy");
                for (int i = 0; i < kids.size(); ++i) {
                    this.mfp.add(new MyProxyFacadeProvider((ConfigurationNode)kids.get(i)));
                }
            } else {
                this.mfp.add(new MyProxyFacadeProvider());
            }
        }
        return this.mfp;
    }

    protected MailUtilProvider getMailUtilProvider() {
        if (this.mup == null) {
            this.mup = 0 < this.cn.getChildrenCount("mail") ? new ServletMailUtilProvider((ConfigurationNode)this.cn.getChildren("mail").get(0)) : new ServletMailUtilProvider();
        }
        return this.mup;
    }

    protected ServiceEnvironmentImpl.MessagesProvider getMP() {
        if (this.messagesProvider == null && 0 < this.cn.getChildrenCount("messages")) {
            this.messagesProvider = new ServiceEnvironmentImpl.MessagesProvider((ConfigurationNode)this.cn.getChildren("messages").get(0));
        }
        return this.messagesProvider;
    }

    public T createInstance() {
        return (T)new ServiceEnvironmentImpl((MyLoggingFacade)this.loggerProvider.get(), this.getTransactionStoreProvider(), this.getClientStoreProvider(), this.getMaxAllowedNewClientRequests(), this.getClientApprovalStoreProvider(), this.getMyProxyFacadeProvider(), this.getMailUtilProvider(), this.getMP(), this.getAGIProvider(), this.getATIProvider(), this.getPAIProvider(), this.getTokenForgeProvider(), this.getConstants(), this.getAuthorizationServletConfig(), this.getUsernameTransformer());
    }

    public int getMaxAllowedNewClientRequests() {
        if (this.maxAllowedNewClientRequests < 0) {
            this.maxAllowedNewClientRequests = 100;
            String x = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"maxAllowedNewClientRequests");
            if (x != null) {
                try {
                    this.maxAllowedNewClientRequests = Integer.parseInt(x);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return this.maxAllowedNewClientRequests;
    }

    public URI getServiceAddress() {
        if (this.address == null) {
            String x = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"address");
            if (x == null) {
                this.warn("Warning: service address set to default. Do you need an \"address\" attribute in your service config. tag?");
                x = "http://localhost";
            }
            this.address = URI.create(x);
        }
        return this.address;
    }

    public UsernameTransformer getUsernameTransformer() {
        return new TrivialUsernameTransformer();
    }

    public T load() {
        this.info("loading configuration.");
        AbstractEnvironment se2 = this.createInstance();
        se2.setServiceAddress(this.getServiceAddress());
        se2.setDebugOn(Boolean.parseBoolean(Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"debug")));
        Object[] polling = this.loadPolling();
        if (polling != null) {
            this.info("Loading polling for " + polling[0]);
            AbstractCLIApprover.ClientApprovalThread cat = new AbstractCLIApprover.ClientApprovalThread(this.myLogger, (ServiceEnvironmentImpl)se2, (File)polling[0], (Long)polling[1]);
            se2.setClientApprovalThread(cat);
        }
        if (se2.isDebugOn()) {
            this.info("Debug mode enabled.");
            for (MyProxyServiceFacade x : se2.getMyProxyServices()) {
                this.debug("loaded myproxy configuration for " + x.getFacadeConfiguration().getHostname() + ":" + x.getFacadeConfiguration().getPort());
            }
        }
        return (T)se2;
    }
}

