/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.server.util;

import edu.uiuc.ncsa.myproxy.oa4mp.server.ServiceEnvironmentImpl;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.delegation.server.storage.ClientApproval;
import edu.uiuc.ncsa.security.delegation.storage.Client;
import edu.uiuc.ncsa.security.util.cli.CLITool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.cli.Options;

public abstract class AbstractCLIApprover
extends CLITool {
    public static final String ANONYMOUS = "anonymous";
    public static final String POLLING_INTERVAL = "pollingInterval";
    public static final String POLLING_DIRECTORY = "pollingDirectory";
    public static final String TEMP_FILE_PREFIX = "clientApproval";
    public static final String TEMP_FILE_SUFFIX = ".ca";
    public static final String ID_DELIMITER = "/";
    ServiceEnvironmentImpl se;
    long pollingInt = 60000L;
    File pollingDir = null;

    public void doIt() throws Exception {
        String inString;
        ClientApproval ca;
        Set keys = this.se.getClientApprovalStore().keySet();
        LinkedList<ClientApproval> linkedList = new LinkedList<ClientApproval>();
        this.info("starting approval");
        int i = 0;
        for (Object k : keys) {
            ca = (ClientApproval)this.se.getClientApprovalStore().get(k);
            linkedList.add(ca);
            AbstractCLIApprover.say((String)(i++ + ". " + (ca.isApproved() ? "(A) " : "(D) ") + ((ClientApproval)linkedList.getLast()).getIdentifierString()));
        }
        if (linkedList.isEmpty()) {
            AbstractCLIApprover.say((String)"(No entries found. You will need to manually enter the id.)");
        }
        boolean keepAsking = true;
        ca = null;
        while (keepAsking) {
            AbstractCLIApprover.say((String)"Enter the number of the client to approve or disapprove, OR, enter an id, starting with a /");
            inString = this.readline();
            if (inString.startsWith(ID_DELIMITER)) {
                ca = new ClientApproval((Identifier)new BasicIdentifier(inString.substring(ID_DELIMITER.length())));
                keepAsking = false;
                continue;
            }
            try {
                int index = Integer.parseInt(inString);
                if (0 <= index && index < linkedList.size()) {
                    ca = (ClientApproval)linkedList.get(index);
                    keepAsking = false;
                    continue;
                }
                AbstractCLIApprover.say((String)"Sorry, that index is out of range. Try again.");
            }
            catch (NumberFormatException xx) {
                boolean noInput = inString == null || inString.length() == 0;
                AbstractCLIApprover.say((String)("Woops. Didn't understand " + (noInput ? "(empty)" : "\"" + inString + "\"") + ". Try again."));
            }
        }
        if (ca == null) {
            this.warn("No client approval found. Aborting session");
            throw new GeneralException("Internal error: Somehow the client approval was not found. Fix that.");
        }
        Client client = (Client)this.se.getClientStore().get((Object)ca.getIdentifier());
        if (client == null) {
            this.info("No client found for the given identifier. Aborting.");
            AbstractCLIApprover.say((String)"no client found for the id. You probably want to fix that.\nexiting...");
            return;
        }
        AbstractCLIApprover.say((String)"You have chosen the following client");
        AbstractCLIApprover.say((String)this.formatClient(client));
        AbstractCLIApprover.say((String)"Enter your approver name [anonymous]:");
        inString = this.readline();
        ca.setApproved(true);
        if (inString == null || 0 == inString.length()) {
            ca.setApprover(ANONYMOUS);
        } else {
            ca.setApprover(inString);
        }
        this.info("Approver is identifier as " + ca.getApprover());
        AbstractCLIApprover.say((String)"Enter Approve or Deny (A/D) [D]");
        inString = this.readline();
        if (inString != null && inString.toLowerCase().equals("a")) {
            ca.setApproved(true);
        }
        this.info("Approver " + (ca.isApproved() ? "denies" : "allows") + " approval.");
        AbstractCLIApprover.say((String)"Commit changes? (y/n)");
        inString = this.readline();
        if (!inString.toLowerCase().equals("y")) {
            this.info("Approval aborted manually. No changes saved.");
            AbstractCLIApprover.say((String)"You didn't explicitly say to save it -- operation aborted.\nexiting...");
            return;
        }
        ca.setApprovalTimestamp(new Date());
        if (this.pollingDir != null) {
            File tempFile = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX, this.pollingDir);
            FileOutputStream fos = new FileOutputStream(tempFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(ca);
            fos.flush();
            fos.close();
        } else {
            this.se.getClientApprovalStore().save((Identifiable)ca);
        }
        this.info("Approval for client with id \"" + ca.getIdentifierString() + "\" finished.");
    }

    protected String formatClient(Client client) {
        String out = "";
        out = out + "  Name=\"" + client.getName() + "\"\n";
        out = out + "  email=\"" + client.getEmail() + "\"\n";
        out = out + "  home uri=\"" + client.getHomeUri() + "\"\n";
        out = out + "  error uri=\"" + client.getErrorUri() + "\"\n";
        return out;
    }

    public String getComponentName() {
        return "service";
    }

    protected Options getOptions() {
        Options options = super.getOptions();
        options.addOption("name", "name", true, "the name of the configuration. Omitting this means there is exactly one and to use that.");
        return options;
    }

    public void help() {
        AbstractCLIApprover.say((String)"A command line tool to approve client requests");
        AbstractCLIApprover.say((String)("usage: " + ((Object)((Object)this)).getClass().getSimpleName() + " options"));
        AbstractCLIApprover.defaultHelp((boolean)true);
        AbstractCLIApprover.say((String)"Where the options are given as -x (fnord) = short option, (long option), and [] = optional. Other options: ");
        AbstractCLIApprover.say((String)"  [-name (-name) -- set the name of the configuration.]");
        AbstractCLIApprover.say((String)"If the configuration name is omitted, it is assumed there is exactly one in the given file and that is to be used.");
    }

    public static class ClientApprovalThread
    extends Thread {
        MyLoggingFacade logger;
        File pollingDir = null;
        Long pollingInterval = 60000L;
        ServiceEnvironmentImpl se;
        boolean stopThread = false;

        public ClientApprovalThread(MyLoggingFacade myLogger, ServiceEnvironmentImpl se2, File pollingDir, Long pollingInterval) {
            this.logger = myLogger;
            this.pollingDir = pollingDir;
            this.pollingInterval = pollingInterval;
            this.se = se2;
        }

        void info(Object x) {
            if (this.logger != null) {
                this.logger.info(x.toString());
            }
        }

        public boolean isStopThread() {
            return this.stopThread;
        }

        public void setStopThread(boolean stopThread) {
            this.stopThread = stopThread;
        }

        public File getPollingDirectory() {
            return this.pollingDir;
        }

        public long getPollingInterval() {
            return this.pollingInterval;
        }

        @Override
        public void run() {
            try {
                this.info("starting client approval polling");
                while (!this.isStopThread()) {
                    File[] files;
                    if (this.pollingDir == null) continue;
                    for (File f : files = this.pollingDir.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.endsWith(AbstractCLIApprover.TEMP_FILE_SUFFIX);
                        }
                    })) {
                        try {
                            this.info(this.getClass().getSimpleName() + ": Checking file " + f);
                            FileInputStream fis = new FileInputStream(f);
                            ObjectInputStream ois = new ObjectInputStream(fis);
                            ClientApproval ca = (ClientApproval)ois.readObject();
                            ois.close();
                            this.info("processing id =\"" + ca.getIdentifierString() + "\", approver is \"" + ca.getApprover() + "\"");
                            Client c = (Client)this.se.getClientStore().get((Object)ca.getIdentifier());
                            if (c != null) {
                                this.se.getClientApprovalStore().save((Identifiable)ca);
                                f.delete();
                            } else {
                                this.logger.warn("Error! An attempt to alter client with id \"" + ca.getIdentifierString() + "\" was made, but no such client was found.");
                            }
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        ClientApprovalThread.sleep(this.pollingInterval);
                    }
                }
            }
            catch (InterruptedException e) {
                this.setStopThread(true);
                this.info("Stopping client approval polling thread...");
                return;
            }
        }
    }
}

