/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.server.util;

import edu.uiuc.ncsa.myproxy.oa4mp.server.OA4MPServiceTransaction;
import edu.uiuc.ncsa.myproxy.oa4mp.server.storage.keys.DSTransactionKeys;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.delegation.server.storage.ClientStore;
import edu.uiuc.ncsa.security.delegation.server.storage.support.ServiceTransactionConverter;
import edu.uiuc.ncsa.security.delegation.storage.Client;
import edu.uiuc.ncsa.security.delegation.token.MyX509Certificates;
import edu.uiuc.ncsa.security.delegation.token.ProtectedAsset;
import edu.uiuc.ncsa.security.delegation.token.TokenForge;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import edu.uiuc.ncsa.security.storage.data.SerializationKeys;
import edu.uiuc.ncsa.security.util.pkcs.CertUtil;
import edu.uiuc.ncsa.security.util.pkcs.MyPKCS10CertRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;

public class TransactionConverter<V extends OA4MPServiceTransaction>
extends ServiceTransactionConverter<V> {
    ClientStore<? extends Client> clientStore;

    public TransactionConverter(IdentifiableProvider<V> identifiableProvider, TokenForge tokenForge, ClientStore<? extends Client> cs) {
        this((SerializationKeys)new DSTransactionKeys(), identifiableProvider, tokenForge, cs);
    }

    public TransactionConverter(SerializationKeys keys, IdentifiableProvider<V> identifiableProvider, TokenForge tokenForge, ClientStore<? extends Client> cs) {
        super(keys, identifiableProvider, tokenForge);
        this.clientStore = cs;
    }

    protected DSTransactionKeys getDSTK() {
        return (DSTransactionKeys)this.getSTK();
    }

    public V fromMap(ConversionMap<String, Object> map, V v) {
        String myproxyUsername;
        String uName;
        Identifier clientKey;
        String y;
        OA4MPServiceTransaction t = (OA4MPServiceTransaction)super.fromMap(map, v);
        String CertReqString = map.getString((Object)this.getDSTK().certReq(new String[0]));
        if (CertReqString != null && 0 < CertReqString.length()) {
            t.setCertReq(CertUtil.fromStringToCertReq((String)CertReqString));
        }
        if ((y = map.getString((Object)this.getDSTK().cert(new String[0]))) != null && 0 < y.length()) {
            try {
                ByteArrayInputStream baos = new ByteArrayInputStream(y.getBytes("UTF-8"));
                MyX509Certificates myCert = new MyX509Certificates(CertUtil.fromPEM((InputStream)baos));
                t.setProtectedAsset((ProtectedAsset)myCert);
            }
            catch (CertificateException e) {
                throw new GeneralException("Error decoding certificate", (Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if ((clientKey = BasicIdentifier.newID((String)map.getString((Object)this.getDSTK().clientKey(new String[0])))) != null) {
            t.setClient((Client)this.clientStore.get((Object)clientKey));
        }
        if ((uName = map.getString((Object)this.getDSTK().username(new String[0]))) != null) {
            t.setUsername(uName);
        }
        if ((myproxyUsername = map.getString((Object)this.getDSTK().myproxyUsername(new String[0]))) != null) {
            t.setMyproxyUsername(myproxyUsername);
        }
        return (V)((Object)t);
    }

    public void toMap(V t, ConversionMap<String, Object> map) {
        super.toMap(t, map);
        if (t.getCertReq() == null) {
            map.put((Object)this.getDSTK().certReq(new String[0]), null);
        } else {
            map.put((Object)this.getDSTK().certReq(new String[0]), (Object)CertUtil.fromCertReqToString((MyPKCS10CertRequest)t.getCertReq()));
        }
        MyX509Certificates myCert = (MyX509Certificates)t.getProtectedAsset();
        if (myCert == null || myCert.getX509Certificates() == null || myCert.getX509Certificates().length == 0) {
            map.put((Object)this.getDSTK().cert(new String[0]), null);
        } else {
            try {
                map.put((Object)this.getDSTK().cert(new String[0]), (Object)myCert.getX509CertificatesPEM());
            }
            catch (CertificateEncodingException e) {
                throw new GeneralException("Error: could not encode certificate", (Throwable)e);
            }
        }
        if (t.getClient() == null) {
            map.put((Object)this.getDSTK().clientKey(new String[0]), null);
        } else {
            map.put((Object)this.getDSTK().clientKey(new String[0]), (Object)t.getClient().getIdentifier());
        }
        if (t.getUsername() == null) {
            map.put((Object)this.getDSTK().username(new String[0]), null);
        } else {
            map.put((Object)this.getDSTK().username(new String[0]), (Object)t.getUsername());
        }
        if (((OA4MPServiceTransaction)((Object)t)).getMyproxyUsername() == null) {
            map.put((Object)this.getDSTK().myproxyUsername(new String[0]), null);
        } else {
            map.put((Object)this.getDSTK().myproxyUsername(new String[0]), (Object)((OA4MPServiceTransaction)((Object)t)).getMyproxyUsername());
        }
    }
}

