/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.loader.edu.uiuc.ncsa.myproxy.oa4mp.server.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.AbstractAccessTokenServlet;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.DateUtils;
import edu.uiuc.ncsa.security.delegation.server.ServiceTransaction;
import edu.uiuc.ncsa.security.delegation.server.request.ATResponse;
import edu.uiuc.ncsa.security.delegation.server.request.IssuerResponse;
import edu.uiuc.ncsa.security.delegation.token.Verifier;
import java.io.IOException;

public class AccessTokenServlet
extends AbstractAccessTokenServlet {
    public ServiceTransaction verifyAndGet(IssuerResponse iResponse) throws IOException {
        ATResponse atResponse = (ATResponse)iResponse;
        Verifier verifier = atResponse.getVerifier();
        this.debug("5.a. verifier = " + atResponse.getVerifier());
        DateUtils.checkTimestamp((String)verifier.getToken());
        ServiceTransaction transaction = (ServiceTransaction)this.getTransactionStore().get(verifier);
        this.checkClient(transaction.getClient());
        String cc = "client=" + transaction.getClient().getIdentifierString();
        this.info("5.a. " + cc);
        this.debug("5.a. grant valid=" + transaction.isAuthGrantValid() + ", at valid=" + transaction.isAccessTokenValid());
        if (!transaction.isAuthGrantValid() || transaction.isAccessTokenValid()) {
            String msg = "Error: the state of the transaction is invalid for auth grant " + transaction.getAuthorizationGrant();
            this.warn(msg);
            throw new GeneralException(msg);
        }
        return transaction;
    }
}

