/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.loader.edu.uiuc.ncsa.myproxy.oa4mp.server.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.AbstractInitServlet;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.delegation.server.ServiceTransaction;
import edu.uiuc.ncsa.security.delegation.server.request.AGResponse;
import edu.uiuc.ncsa.security.delegation.server.request.IssuerResponse;
import edu.uiuc.ncsa.security.util.pkcs.CertUtil;
import edu.uiuc.ncsa.security.util.pkcs.MyPKCS10CertRequest;
import java.io.IOException;
import java.net.URI;
import java.util.Map;

public class InitServlet
extends AbstractInitServlet {
    public ServiceTransaction verifyAndGet(IssuerResponse iResponse) throws IOException {
        AGResponse agResponse = (AGResponse)iResponse;
        Map params = agResponse.getParameters();
        ServiceTransaction transaction = this.newTransaction();
        transaction.setAuthorizationGrant(agResponse.getGrant());
        this.debug("creating transaction for trans id=" + transaction.getIdentifierString());
        transaction.setAuthGrantValid(false);
        transaction.setAccessTokenValid(false);
        transaction.setCallback(URI.create((String)params.get("oauth_callback")));
        MyPKCS10CertRequest certReq = null;
        String rawCR = (String)params.get("certreq");
        try {
            certReq = CertUtil.fromStringToCertReq((String)rawCR);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new GeneralException("Error: cert request is bad/not understandable:" + (rawCR == null ? "(null)" : rawCR), throwable);
        }
        transaction.setCertReq(certReq);
        transaction.setLifetime(Long.parseLong((String)params.get("certlifetime")));
        return transaction;
    }
}

