/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.loader;

import edu.uiuc.ncsa.myproxy.oa4mp.server.ServiceEnvironmentImpl;
import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.AbstractConfigurationLoader;
import edu.uiuc.ncsa.myproxy.oa4mp.server.util.OA4MPIdentifierProvider;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.util.IdentifierProvider;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.delegation.server.issuers.AGIssuer;
import edu.uiuc.ncsa.security.delegation.server.issuers.ATIssuer;
import edu.uiuc.ncsa.security.delegation.server.issuers.PAIssuer;
import edu.uiuc.ncsa.security.delegation.server.storage.ClientApprovalStore;
import edu.uiuc.ncsa.security.delegation.server.storage.ClientStore;
import edu.uiuc.ncsa.security.delegation.storage.Client;
import edu.uiuc.ncsa.security.delegation.storage.TransactionStore;
import edu.uiuc.ncsa.security.delegation.token.TokenForge;
import edu.uiuc.ncsa.security.oauth_1_0a.OAuthTokenForge;
import edu.uiuc.ncsa.security.oauth_1_0a.client.OAClientProvider;
import edu.uiuc.ncsa.security.oauth_1_0a.server.AGIProvider;
import edu.uiuc.ncsa.security.oauth_1_0a.server.ATIProvider;
import edu.uiuc.ncsa.security.oauth_1_0a.server.PAIProvider;
import java.util.HashMap;
import javax.inject.Provider;
import org.apache.commons.configuration.tree.ConfigurationNode;

public class OA4MPConfigurationLoader<T extends ServiceEnvironmentImpl>
extends AbstractConfigurationLoader<T> {
    HashMap<String, String> constants;

    public String getVersionString() {
        return "OA4MP server configuration loader, version 3.1.2";
    }

    public Provider<AGIssuer> getAGIProvider() {
        return new AGIProvider((TokenForge)this.getTokenForgeProvider().get(), this.getServiceAddress());
    }

    public Provider<ClientStore> getClientStoreProvider() {
        return this.getCSP();
    }

    public Provider<ClientApprovalStore> getClientApprovalStoreProvider() {
        return this.getCASP();
    }

    public Provider<TransactionStore> getTransactionStoreProvider() {
        return this.getTSP();
    }

    public Provider<TokenForge> getTokenForgeProvider() {
        return new OAuthForgeProvider();
    }

    public Provider<ATIssuer> getATIProvider() {
        return new ATIProvider((TokenForge)this.getTokenForgeProvider().get(), this.getServiceAddress());
    }

    public Provider<PAIssuer> getPAIProvider() {
        return new PAIProvider((TokenForge)this.getTokenForgeProvider().get(), this.getServiceAddress());
    }

    public OA4MPConfigurationLoader(ConfigurationNode node) {
        super(node);
    }

    public OA4MPConfigurationLoader(ConfigurationNode node, MyLoggingFacade logger) {
        super(node, logger);
    }

    public IdentifiableProvider<? extends Client> getClientProvider() {
        return new OAClientProvider((IdentifierProvider)new OA4MPIdentifierProvider("myproxy", "oa4mp,2012:", "client", false));
    }

    public HashMap<String, String> getConstants() {
        if (this.constants == null) {
            this.constants = new HashMap();
            this.constants.put("oa4mp:callback_uri", "oauth_callback");
            this.constants.put("oa4mp:token", "oauth_token");
            this.constants.put("oa4mp:form_encoding", "application/x-www-form-urlencoded");
            this.constants.put("oa4mp:certreq", "certreq");
            this.constants.put("oa4mp:certlifetime", "certlifetime");
            this.constants.put("oa4mp:client_id", "oauth_consumer_key");
        }
        return this.constants;
    }

    protected static class OAuthForgeProvider
    implements Provider<TokenForge> {
        protected OAuthForgeProvider() {
        }

        public TokenForge get() {
            return new OAuthTokenForge("myproxy:oa4mp,2012:oauth1:");
        }
    }
}

