/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.oauth2.loader;

import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.OA2SE;
import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.OA2ServiceTransaction;
import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.storage.OA2ClientSQLStoreProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.storage.OA2FSTStoreProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.storage.OA2MTStore;
import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.storage.OA2MultiTypeProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.storage.OA2SQLTransactionStoreProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.storage.OA2TransactionKeys;
import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.storage.TConverter2;
import edu.uiuc.ncsa.myproxy.oa4mp.server.ClientApprovalProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.server.DSTransactionProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.server.ServiceEnvironmentImpl;
import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.ServerConfigurationLoader;
import edu.uiuc.ncsa.myproxy.oa4mp.server.storage.MultiDSClientApprovalStoreProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.server.storage.MultiDSClientStoreProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.server.storage.filestore.DSFSClientApprovalStoreProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.server.storage.filestore.DSFSClientStoreProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.server.storage.sql.provider.DSSQLClientApprovalStoreProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.server.util.ClientApproverConverter;
import edu.uiuc.ncsa.myproxy.oa4mp.server.util.OA4MPIdentifierProvider;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.configuration.Configurations;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEvent;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEventListener;
import edu.uiuc.ncsa.security.core.configuration.provider.TypedProvider;
import edu.uiuc.ncsa.security.core.util.IdentifiableProviderImpl;
import edu.uiuc.ncsa.security.core.util.IdentifierProvider;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.delegation.server.issuers.AGIssuer;
import edu.uiuc.ncsa.security.delegation.server.issuers.ATIssuer;
import edu.uiuc.ncsa.security.delegation.server.issuers.PAIssuer;
import edu.uiuc.ncsa.security.delegation.server.storage.ClientApprovalStore;
import edu.uiuc.ncsa.security.delegation.server.storage.ClientStore;
import edu.uiuc.ncsa.security.delegation.server.storage.impl.ClientApprovalMemoryStore;
import edu.uiuc.ncsa.security.delegation.server.storage.impl.ClientMemoryStore;
import edu.uiuc.ncsa.security.delegation.storage.Client;
import edu.uiuc.ncsa.security.delegation.storage.ClientApprovalKeys;
import edu.uiuc.ncsa.security.delegation.storage.TransactionStore;
import edu.uiuc.ncsa.security.delegation.token.TokenForge;
import edu.uiuc.ncsa.security.oauth_2_0.OA2ClientConverter;
import edu.uiuc.ncsa.security.oauth_2_0.OA2ClientProvider;
import edu.uiuc.ncsa.security.oauth_2_0.OA2TokenForge;
import edu.uiuc.ncsa.security.oauth_2_0.server.AGI2;
import edu.uiuc.ncsa.security.oauth_2_0.server.ATI2;
import edu.uiuc.ncsa.security.oauth_2_0.server.PAI2;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.data.SerializationKeys;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPoolProvider;
import java.util.HashMap;
import javax.inject.Provider;
import org.apache.commons.configuration.tree.ConfigurationNode;

public class OA2ConfigurationLoader<T extends ServiceEnvironmentImpl>
extends ServerConfigurationLoader<T> {
    public long REFRESH_TOKEN_LIFETIME_DEFAULT = 1296000000L;
    public int CLIENT_SECRET_LENGTH_DEFAULT = 258;
    HashMap<String, String> constants;
    Provider<AGIssuer> agip = null;
    long rtLifetime = -1L;
    int clientSecretLength = -1;

    public OA2ConfigurationLoader(ConfigurationNode node) {
        super(node);
    }

    public OA2ConfigurationLoader(ConfigurationNode node, MyLoggingFacade logger) {
        super(node, logger);
    }

    public T createInstance() {
        return (T)((Object)new OA2SE((MyLoggingFacade)this.loggerProvider.get(), this.getTransactionStoreProvider(), this.getClientStoreProvider(), this.getMaxAllowedNewClientRequests(), this.getRTLifetime(), this.getClientApprovalStoreProvider(), this.getMyProxyFacadeProvider(), this.getMailUtilProvider(), this.getMP(), this.getAGIProvider(), this.getATIProvider(), this.getPAIProvider(), this.getTokenForgeProvider(), this.getConstants(), this.getAuthorizationServletConfig(), this.getUsernameTransformer(), this.getClientSecretLength()));
    }

    public HashMap<String, String> getConstants() {
        if (this.constants == null) {
            this.constants = new HashMap();
            this.constants.put("oa4mp:callback_uri", "redirect_uri");
            this.constants.put("oa4mp:token", "code");
            this.constants.put("oa4mp:form_encoding", "application/x-www-form-urlencoded");
            this.constants.put("oa4mp:certreq", "certreq");
            this.constants.put("oa4mp:certlifetime", "certlifetime");
            this.constants.put("oa4mp:client_id", "client_id");
        }
        return this.constants;
    }

    public Provider<AGIssuer> getAGIProvider() {
        if (this.agip == null) {
            return new Provider<AGIssuer>(){

                public AGIssuer get() {
                    return new AGI2((TokenForge)OA2ConfigurationLoader.this.getTokenForgeProvider().get(), OA2ConfigurationLoader.this.getServiceAddress());
                }
            };
        }
        return this.agip;
    }

    public Provider<ClientApprovalStore> getClientApprovalStoreProvider() {
        return this.getCASP();
    }

    public Provider<ClientStore> getClientStoreProvider() {
        return this.getCSP();
    }

    protected MultiDSClientApprovalStoreProvider getCASP() {
        if (this.casp == null) {
            this.casp = new MultiDSClientApprovalStoreProvider(this.cn, this.isDefaultStoreDisabled(new boolean[0]), (MyLoggingFacade)this.loggerProvider.get());
            final ClientApprovalProvider caProvider = new ClientApprovalProvider();
            ClientApprovalKeys caKeys = new ClientApprovalKeys();
            caKeys.identifier(new String[]{"client_id"});
            ClientApproverConverter cp = new ClientApproverConverter((SerializationKeys)caKeys, (IdentifiableProviderImpl)caProvider);
            this.casp.addListener((CfgEventListener)new DSFSClientApprovalStoreProvider(this.cn, cp));
            this.casp.addListener((CfgEventListener)new DSSQLClientApprovalStoreProvider(this.cn, (ConnectionPoolProvider)this.getMySQLConnectionPoolProvider(), "mysql", (MapConverter)cp));
            this.casp.addListener((CfgEventListener)new DSSQLClientApprovalStoreProvider(this.cn, (ConnectionPoolProvider)this.getMariaDBConnectionPoolProvider(), "mariadb", (MapConverter)cp));
            this.casp.addListener((CfgEventListener)new DSSQLClientApprovalStoreProvider(this.cn, (ConnectionPoolProvider)this.getPgConnectionPoolProvider(), "postgresql", (MapConverter)cp));
            this.casp.addListener((CfgEventListener)new TypedProvider<ClientApprovalStore>(this.cn, "memoryStore", "clientApprovals"){

                public Object componentFound(CfgEvent configurationEvent) {
                    if (this.checkEvent(configurationEvent)) {
                        return this.get();
                    }
                    return null;
                }

                public ClientApprovalStore get() {
                    return new ClientApprovalMemoryStore((IdentifiableProviderImpl)caProvider);
                }
            });
        }
        return this.casp;
    }

    protected long getRTLifetime() {
        String x;
        if (this.rtLifetime < 0L && (x = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"refreshTokenLifetime")) != null) {
            try {
                this.rtLifetime = Long.parseLong(x) * 1000L;
            }
            catch (Throwable t) {
                this.rtLifetime = this.REFRESH_TOKEN_LIFETIME_DEFAULT;
            }
        }
        return this.rtLifetime;
    }

    public int getClientSecretLength() {
        if (this.clientSecretLength < 0) {
            String x = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"clientSecretLength");
            if (x != null) {
                try {
                    this.clientSecretLength = Integer.parseInt(x);
                }
                catch (Throwable t) {
                    this.clientSecretLength = this.CLIENT_SECRET_LENGTH_DEFAULT;
                }
            } else {
                this.clientSecretLength = this.CLIENT_SECRET_LENGTH_DEFAULT;
            }
        }
        return this.clientSecretLength;
    }

    protected MultiDSClientStoreProvider getCSP() {
        if (this.csp == null) {
            OA2ClientConverter converter = new OA2ClientConverter(this.getClientProvider());
            this.csp = new MultiDSClientStoreProvider(this.cn, this.isDefaultStoreDisabled(new boolean[0]), (MyLoggingFacade)this.loggerProvider.get(), null, null, this.getClientProvider());
            this.csp.addListener((CfgEventListener)new DSFSClientStoreProvider(this.cn, (MapConverter)converter, this.getClientProvider()));
            this.csp.addListener(new OA2ClientSQLStoreProvider((ConnectionPoolProvider<ConnectionPool>)((ConnectionPoolProvider<? extends ConnectionPool>)this.getMySQLConnectionPoolProvider()), "mysql", (MapConverter)converter, (Provider<Client>)this.getClientProvider()));
            this.csp.addListener(new OA2ClientSQLStoreProvider((ConnectionPoolProvider<ConnectionPool>)((ConnectionPoolProvider<? extends ConnectionPool>)this.getMariaDBConnectionPoolProvider()), "mariadb", (MapConverter)converter, (Provider<Client>)this.getClientProvider()));
            this.csp.addListener(new OA2ClientSQLStoreProvider((ConnectionPoolProvider<ConnectionPool>)((ConnectionPoolProvider<? extends ConnectionPool>)this.getPgConnectionPoolProvider()), "postgresql", (MapConverter)converter, (Provider<Client>)this.getClientProvider()));
            this.csp.addListener((CfgEventListener)new TypedProvider<ClientStore>(this.cn, "memoryStore", "clients"){

                public Object componentFound(CfgEvent configurationEvent) {
                    if (this.checkEvent(configurationEvent)) {
                        return this.get();
                    }
                    return null;
                }

                public ClientStore get() {
                    return new ClientMemoryStore(OA2ConfigurationLoader.this.getClientProvider());
                }
            });
        }
        return this.csp;
    }

    protected Provider<TransactionStore> getTSP() {
        if (this.tsp == null) {
            ST2Provider tp = new ST2Provider((IdentifierProvider<Identifier>)new OA4MPIdentifierProvider("myproxy", "oa4mp,2012:", "transaction", false));
            OA2TransactionKeys keys = new OA2TransactionKeys();
            TConverter2 tc = new TConverter2(keys, tp, (TokenForge)this.getTokenForgeProvider().get(), (ClientStore<? extends Client>)((ClientStore<Client>)((ClientStore<? extends Client>)((ClientStore)this.getClientStoreProvider().get()))));
            OA2MultiTypeProvider storeProvider = new OA2MultiTypeProvider(this.cn, this.isDefaultStoreDisabled(new boolean[0]), (MyLoggingFacade)this.loggerProvider.get(), (IdentifiableProvider)tp);
            storeProvider.addListener((CfgEventListener)new OA2SQLTransactionStoreProvider(this.cn, (ConnectionPoolProvider<ConnectionPool>)((ConnectionPoolProvider<? extends ConnectionPool>)this.getMySQLConnectionPoolProvider()), "mysql", this.getCSP(), (Provider<OA2ServiceTransaction>)((Provider<? extends OA2ServiceTransaction>)tp), this.getTokenForgeProvider(), (MapConverter)tc));
            storeProvider.addListener((CfgEventListener)new OA2SQLTransactionStoreProvider(this.cn, (ConnectionPoolProvider<ConnectionPool>)((ConnectionPoolProvider<? extends ConnectionPool>)this.getMariaDBConnectionPoolProvider()), "mariadb", this.getCSP(), (Provider<OA2ServiceTransaction>)((Provider<? extends OA2ServiceTransaction>)tp), this.getTokenForgeProvider(), (MapConverter)tc));
            storeProvider.addListener((CfgEventListener)new OA2SQLTransactionStoreProvider(this.cn, (ConnectionPoolProvider<ConnectionPool>)((ConnectionPoolProvider<? extends ConnectionPool>)this.getPgConnectionPoolProvider()), "postgresql", this.getCSP(), (Provider<OA2ServiceTransaction>)((Provider<? extends OA2ServiceTransaction>)tp), this.getTokenForgeProvider(), (MapConverter)tc));
            storeProvider.addListener((CfgEventListener)new OA2FSTStoreProvider(this.cn, (IdentifiableProvider<? extends OA2ServiceTransaction>)tp, this.getTokenForgeProvider(), tc));
            storeProvider.addListener((CfgEventListener)new TypedProvider<TransactionStore>(this.cn, "memoryStore", "transactions", (IdentifiableProvider)tp){
                final /* synthetic */ IdentifiableProvider val$tp;
                {
                    this.val$tp = identifiableProvider;
                    super(x0, x1, x2);
                }

                public Object componentFound(CfgEvent configurationEvent) {
                    if (this.checkEvent(configurationEvent)) {
                        return this.get();
                    }
                    return null;
                }

                public TransactionStore get() {
                    return new OA2MTStore(this.val$tp);
                }
            });
            this.tsp = storeProvider;
        }
        return this.tsp;
    }

    public Provider<TransactionStore> getTransactionStoreProvider() {
        return this.getTSP();
    }

    public Provider<TokenForge> getTokenForgeProvider() {
        return new Provider<TokenForge>(){

            public TokenForge get() {
                return new OA2TokenForge(OA2ConfigurationLoader.this.getServiceAddress().toString());
            }
        };
    }

    public Provider<ATIssuer> getATIProvider() {
        return new Provider<ATIssuer>(){

            public ATIssuer get() {
                return new ATI2((TokenForge)OA2ConfigurationLoader.this.getTokenForgeProvider().get(), OA2ConfigurationLoader.this.getServiceAddress());
            }
        };
    }

    public Provider<PAIssuer> getPAIProvider() {
        return new Provider<PAIssuer>(){

            public PAIssuer get() {
                return new PAI2((TokenForge)OA2ConfigurationLoader.this.getTokenForgeProvider().get(), OA2ConfigurationLoader.this.getServiceAddress());
            }
        };
    }

    public IdentifiableProvider<? extends Client> getClientProvider() {
        return new OA2ClientProvider((IdentifierProvider)new OA4MPIdentifierProvider("myproxy", "oa4mp,2012:", "client_id", false));
    }

    public String getVersionString() {
        return "OAuth 2 for MyProxy, version 1.2.1";
    }

    public static class ST2Provider
    extends DSTransactionProvider<OA2ServiceTransaction> {
        public ST2Provider(IdentifierProvider<Identifier> idProvider) {
            super(idProvider);
        }

        public OA2ServiceTransaction get(boolean createNewIdentifier) {
            return new OA2ServiceTransaction(this.createNewId(createNewIdentifier));
        }
    }

    public class OA4MP2TProvider
    extends DSTransactionProvider<OA2ServiceTransaction> {
        public OA4MP2TProvider(IdentifierProvider<Identifier> idProvider) {
            super(idProvider);
        }

        public OA2ServiceTransaction get(boolean createNewIdentifier) {
            return new OA2ServiceTransaction(this.createNewId(createNewIdentifier));
        }
    }
}

