/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.oauth2.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.OA2SE;
import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.OA2ServiceTransaction;
import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.servlet.OA2ClientCheck;
import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.storage.RefreshTokenStore;
import edu.uiuc.ncsa.myproxy.oa4mp.server.OA4MPServiceTransaction;
import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.AbstractAccessTokenServlet;
import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.IssuerTransactionState;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.InvalidTokenException;
import edu.uiuc.ncsa.security.core.exceptions.NFWException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.delegation.server.ServiceTransaction;
import edu.uiuc.ncsa.security.delegation.server.request.ATResponse;
import edu.uiuc.ncsa.security.delegation.server.request.IssuerResponse;
import edu.uiuc.ncsa.security.delegation.services.Request;
import edu.uiuc.ncsa.security.delegation.servlet.TransactionState;
import edu.uiuc.ncsa.security.delegation.storage.Client;
import edu.uiuc.ncsa.security.delegation.storage.TransactionStore;
import edu.uiuc.ncsa.security.delegation.storage.impl.BasicTransaction;
import edu.uiuc.ncsa.security.delegation.token.RefreshToken;
import edu.uiuc.ncsa.security.delegation.token.TokenForge;
import edu.uiuc.ncsa.security.oauth_2_0.OA2Client;
import edu.uiuc.ncsa.security.oauth_2_0.OA2TokenForge;
import edu.uiuc.ncsa.security.oauth_2_0.server.ATIResponse2;
import edu.uiuc.ncsa.security.oauth_2_0.server.RTI2;
import edu.uiuc.ncsa.security.oauth_2_0.server.RTIRequest;
import edu.uiuc.ncsa.security.oauth_2_0.server.RTIResponse;
import java.io.IOException;
import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OA2ATServlet
extends AbstractAccessTokenServlet {
    public void preprocess(TransactionState state) throws Throwable {
        super.preprocess(state);
        OA4MPServiceTransaction st = (OA4MPServiceTransaction)state.getTransaction();
        String givenRedirect = (String)state.getParameters().get("redirect_uri");
        OA2ClientCheck.check(st.getClient(), givenRedirect);
        st.setCallback(URI.create((String)state.getParameters().get("redirect_uri")));
    }

    protected long computeRefreshLifetime(OA2ServiceTransaction st2) {
        OA2Client client = (OA2Client)st2.getClient();
        long lifetime = Math.max(st2.getRefreshTokenLifetime(), client.getRtLifetime());
        OA2SE oa2SE = (OA2SE)OA2ATServlet.getServiceEnvironment();
        if (oa2SE.getRefreshTokenLifetime() <= 0L) {
            throw new NFWException("Internal error: the server-wide default for the refresh token lifetime has not been set.");
        }
        lifetime = Math.min(lifetime, oa2SE.getRefreshTokenLifetime());
        return lifetime;
    }

    protected void doIt(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        String grantType = this.getFirstParameterValue(request, "grant_type");
        if (grantType == null) {
            this.warn("Error servicing request. No grant type was given. Rejecting request.");
            throw new GeneralException("Error: Could not service request");
        }
        Client client = this.getClient(request);
        this.checkClient(client);
        if (grantType.equals("refresh_token")) {
            this.doRefresh(request, response);
            return;
        }
        if (grantType.equals("authorization_code")) {
            IssuerTransactionState state = this.doDelegation(request, response);
            ATIResponse2 atResponse = (ATIResponse2)state.getIssuerResponse();
            OA2ServiceTransaction st2 = (OA2ServiceTransaction)state.getTransaction();
            RefreshToken rt = atResponse.getRefreshToken();
            st2.setRefreshToken(rt);
            rt.setExpiresIn(this.computeRefreshLifetime(st2));
            st2.setRefreshTokenValid(true);
            this.getTransactionStore().save((Identifiable)st2);
            return;
        }
        this.warn("Error: grant type was not recognized. Request rejected.");
        throw new ServletException("Error: Unknown request type.");
    }

    protected OA2ServiceTransaction getByRT(RefreshToken refreshToken) throws IOException {
        if (refreshToken == null) {
            throw new GeneralException("Error: null refresh token encountered.");
        }
        RefreshTokenStore rts = (RefreshTokenStore)this.getTransactionStore();
        return rts.get(refreshToken);
    }

    protected OA2TokenForge getTF2() {
        return (OA2TokenForge)OA2ATServlet.getServiceEnvironment().getTokenForge();
    }

    protected TransactionState doRefresh(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RefreshToken oldRT = this.getTF2().getRefreshToken(new String[]{request.getParameter("refresh_token")});
        Client c = this.getClient(request);
        this.checkClient(c);
        OA2ServiceTransaction t = this.getByRT(oldRT);
        if (t == null || !t.isRefreshTokenValid()) {
            throw new InvalidTokenException("Error: The refresh token is no longer valid");
        }
        t.setRefreshTokenValid(false);
        RTIRequest rtiRequest = new RTIRequest(request, c, t.getAccessToken());
        RTI2 rtIsuuer = new RTI2((TokenForge)this.getTF2(), OA2ATServlet.getServiceEnvironment().getServiceAddress());
        RTIResponse rtiResponse = (RTIResponse)rtIsuuer.process((Request)rtiRequest);
        RefreshToken rt = rtiResponse.getRefreshToken();
        rt.setExpiresIn(this.computeRefreshLifetime(t));
        t.setRefreshToken(rtiResponse.getRefreshToken());
        t.setRefreshTokenValid(true);
        this.getTransactionStore().save((Identifiable)t);
        rtiResponse.write(response);
        IssuerTransactionState state = new IssuerTransactionState(request, response, rtiResponse.getParameters(), (BasicTransaction)t, (IssuerResponse)rtiResponse);
        return state;
    }

    public ServiceTransaction verifyAndGet(IssuerResponse iResponse) throws IOException {
        ATResponse atResponse = (ATResponse)iResponse;
        TransactionStore transactionStore = this.getTransactionStore();
        BasicIdentifier basicIdentifier = new BasicIdentifier((String)atResponse.getParameters().get("code"));
        Object o = transactionStore.get((Object)basicIdentifier);
        ServiceTransaction transaction = (ServiceTransaction)o;
        return transaction;
    }
}

