/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.oauth2.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.OA2ServiceTransaction;
import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.AAS2;
import edu.uiuc.ncsa.security.delegation.server.ServiceTransaction;
import edu.uiuc.ncsa.security.servlet.JSPUtil;
import edu.uiuc.ncsa.security.servlet.PresentableState;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OA2AuthorizationServer
extends AAS2 {
    public String AUTHORIZATION_REFRESH_TOKEN_LIFETIME_KEY = "AuthRTL";
    public String AUTHORIZATION_REFRESH_TOKEN_LIFETIME_VALUE = "rtLifetime";

    protected void doIt(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        Map map = this.getFirstParameters(request);
        if (map.containsKey("response_type") && ((String)map.get("response_type")).equals("code")) {
            JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)"/initiate");
            return;
        }
        super.doIt(request, response);
    }

    public void prepare(PresentableState state) throws Throwable {
        super.prepare(state);
        if (state.getState() == 0) {
            state.getRequest().setAttribute(this.AUTHORIZATION_REFRESH_TOKEN_LIFETIME_KEY, (Object)this.AUTHORIZATION_REFRESH_TOKEN_LIFETIME_KEY);
        }
    }

    protected void createRedirect(HttpServletRequest request, HttpServletResponse response, ServiceTransaction trans) throws Throwable {
        String rawrtl = request.getParameter(this.AUTHORIZATION_REFRESH_TOKEN_LIFETIME_KEY);
        OA2ServiceTransaction st2 = (OA2ServiceTransaction)trans;
        try {
            if (rawrtl != null) {
                st2.setRefreshTokenLifetime(Long.parseLong(rawrtl) * 1000L);
            }
        }
        catch (Throwable t) {
            st2.setRefreshTokenLifetime(0L);
        }
        super.createRedirect(request, response, trans);
    }

    public String createCallback(ServiceTransaction trans, Map<String, String> params) {
        String cb = trans.getCallback().toString();
        String idStr = trans.getIdentifierString();
        try {
            cb = cb + (cb.indexOf("?") == -1 ? "?" : "&") + "code" + "=" + URLEncoder.encode(idStr, "UTF-8");
            if (params.containsKey("state")) {
                cb = cb + "&" + "state" + "=" + URLEncoder.encode(params.get("state"), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return cb;
    }

    protected void doRealCertRequest(ServiceTransaction trans, String statusString) throws Throwable {
    }
}

