/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.oauth2.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.OA2ServiceTransaction;
import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.servlet.OA2ClientCheck;
import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.AbstractInitServlet;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.delegation.server.ServiceTransaction;
import edu.uiuc.ncsa.security.delegation.server.request.AGResponse;
import edu.uiuc.ncsa.security.delegation.server.request.IssuerResponse;
import edu.uiuc.ncsa.security.oauth_2_0.NonceHerder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;

public class OA2InitServlet
extends AbstractInitServlet {
    public ServiceTransaction verifyAndGet(IssuerResponse iResponse) throws UnsupportedEncodingException {
        AGResponse agResponse = (AGResponse)iResponse;
        Map params = agResponse.getParameters();
        String rawSecret = (String)params.get("client_secret");
        if (rawSecret == null) {
            throw new GeneralException("Error: No secret. request refused.");
        }
        if (!((AGResponse)iResponse).getClient().getSecret().equals(DigestUtils.shaHex((String)rawSecret))) {
            throw new GeneralException("Error: Secret is incorrect. request refused.");
        }
        String nonce = (String)params.get("nonce");
        NonceHerder.checkNonce((String)nonce);
        String scope = (String)params.get("scope");
        if (scope == null || scope.length() == 0 || scope.indexOf("openid ") == -1) {
            throw new IllegalArgumentException("Error: unsupported/missing scope.");
        }
        OA2ServiceTransaction st = new OA2ServiceTransaction(agResponse.getGrant());
        st.setAuthGrantValid(false);
        st.setAccessTokenValid(false);
        String givenRedirect = (String)params.get("redirect_uri");
        OA2ClientCheck.check(agResponse.getClient(), givenRedirect);
        st.setCallback(URI.create((String)params.get("redirect_uri")));
        if (!((String)params.get("prompt")).equals("login")) {
            String errorCB = st.getCallback().toString() + "?" + "error" + "=" + URLEncoder.encode("login_required", "UTF-8");
            errorCB = errorCB + "&" + "error_description" + "=" + URLEncoder.encode("Error:This requires a login", "UTF-8");
            if (params.containsKey("state")) {
                errorCB = errorCB + "&" + "state" + "=" + URLEncoder.encode((String)params.get("state"), "UTF-8");
            }
            throw new LoginException(errorCB);
        }
        return st;
    }

    protected void handleException(Throwable t, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (t instanceof LoginException) {
            response.sendRedirect(t.getMessage());
            return;
        }
        super.handleException(t, request, response);
    }

    protected static class LoginException
    extends GeneralException {
        LoginException(String message) {
            super(message);
        }
    }
}

