/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.oauth2.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.OA2SE;
import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.AbstractRegistrationServlet;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.delegation.storage.Client;
import edu.uiuc.ncsa.security.oauth_2_0.OA2Client;
import edu.uiuc.ncsa.security.servlet.PresentableState;
import java.io.BufferedReader;
import java.io.StringReader;
import java.net.URI;
import java.security.SecureRandom;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;

public class OA2RegistrationServlet
extends AbstractRegistrationServlet {
    protected static SecureRandom random = new SecureRandom();
    public static final String CALLBACK_URI = "callbackURI";
    public static final String REFRESH_TOKEN_LIFETIME = "rtLifetime";

    protected OA2SE getOA2SE() {
        return (OA2SE)OA2RegistrationServlet.getServiceEnvironment();
    }

    public void prepare(PresentableState state) throws Throwable {
        super.prepare(state);
        HttpServletRequest request = state.getRequest();
        if (state.getState() == 0) {
            request.setAttribute(CALLBACK_URI, (Object)CALLBACK_URI);
            request.setAttribute(REFRESH_TOKEN_LIFETIME, (Object)REFRESH_TOKEN_LIFETIME);
        }
    }

    protected Client addNewClient(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        OA2Client client = (OA2Client)super.addNewClient(request, response);
        String rawCBs = this.getRequiredParam(request, CALLBACK_URI);
        String rawRTLifetime = this.getRequiredParam(request, REFRESH_TOKEN_LIFETIME);
        long clientRtLifetime = 0L;
        boolean rtLifetimeOK = true;
        if (rawRTLifetime != null && 0 < rawRTLifetime.length()) {
            try {
                clientRtLifetime = Long.parseLong(rawRTLifetime);
                rtLifetimeOK = clientRtLifetime >= 0L;
            }
            catch (Throwable t) {
                rtLifetimeOK = false;
            }
            if (!rtLifetimeOK) {
                this.info("Client requested illegal value for refresh token lifetime at registration of \"" + rawRTLifetime + "\"");
            }
        }
        client.setRtLifetime(clientRtLifetime);
        byte[] bytes = new byte[this.getOA2SE().getClientSecretLength()];
        random.nextBytes(bytes);
        String secret64 = Base64.encodeBase64URLSafeString((byte[])bytes);
        client.setSecret(secret64);
        BufferedReader br = new BufferedReader(new StringReader(rawCBs));
        String x = br.readLine();
        LinkedList<String> uris = new LinkedList<String>();
        while (x != null) {
            try {
                URI.create(x);
                uris.add(x);
            }
            catch (Throwable t) {
                this.warn("Attempt to add bad callback uri for client " + client.getIdentifierString());
            }
            x = br.readLine();
        }
        br.close();
        client.setCallbackURIs(uris);
        return client;
    }

    public void present(PresentableState state) throws Throwable {
        super.present(state);
        if (state.getState() == 100) {
            if (state instanceof AbstractRegistrationServlet.ClientState) {
                AbstractRegistrationServlet.ClientState cState = (AbstractRegistrationServlet.ClientState)state;
                String secret = DigestUtils.shaHex((String)cState.getClient().getSecret());
                cState.getClient().setSecret(secret);
                OA2RegistrationServlet.getServiceEnvironment().getClientStore().save((Identifiable)cState.getClient());
            } else {
                throw new IllegalStateException("Error: An instance of ClientState was expected, but got an instance of \"" + state.getClass().getName() + "\"");
            }
        }
    }
}

