/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.oauth2.storage;

import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.OA2ServiceTransaction;
import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.storage.RefreshTokenStore;
import edu.uiuc.ncsa.myproxy.oa4mp.server.storage.filestore.DSFSTransactionStore;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.delegation.token.RefreshToken;
import edu.uiuc.ncsa.security.delegation.token.TokenForge;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import java.io.File;
import java.io.IOException;

public class OA2FSTStore<V extends OA2ServiceTransaction>
extends DSFSTransactionStore<V>
implements RefreshTokenStore<V> {
    public OA2FSTStore(File storeDirectory, File indexDirectory, IdentifiableProvider<V> idp, TokenForge tokenForge, MapConverter<V> cp) {
        super(storeDirectory, indexDirectory, idp, tokenForge, cp);
    }

    public V get(RefreshToken refreshToken) {
        return (V)((Object)((OA2ServiceTransaction)this.getIndexEntry(refreshToken.getToken())));
    }

    public void realSave(boolean checkExists, V t) {
        super.realSave(checkExists, t);
        try {
            if (((OA2ServiceTransaction)((Object)t)).hasRefreshToken()) {
                this.createIndexEntry(((OA2ServiceTransaction)((Object)t)).getRefreshToken().getToken(), t.getIdentifierString());
            }
        }
        catch (IOException e) {
            throw new GeneralException("Error serializing item " + t + "to file ");
        }
    }

    public boolean delete(String identifier) {
        OA2ServiceTransaction t = (OA2ServiceTransaction)this.loadByIdentifier(identifier);
        boolean rc = super.delete(identifier);
        if (t.hasRefreshToken()) {
            this.removeIndexEntry(t.getRefreshToken().getToken());
        }
        return rc;
    }
}

