package edu.uiuc.ncsa.myproxy.oa4mp.oauth2.servlet;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.oauth_2_0.OA2Constants;
import edu.uiuc.ncsa.security.oauth_2_0.OA2Error;
import edu.uiuc.ncsa.security.oauth_2_0.OA2Errors;
import edu.uiuc.ncsa.security.servlet.ExceptionHandler;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;

/**
 * <p>Created by Jeff Gaynor<br>
 * on 2/12/15 at  3:16 PM
 */
public class OA2ExceptionHandler implements ExceptionHandler {
    @Override
    public void handleException(Throwable t, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        OA2Error oa2Error = null;
        String state = request.getParameter(OA2Constants.STATE);
        if (t instanceof OA2Error) {
            oa2Error = (OA2Error) t;
        } else {
            if (t instanceof GeneralException) {
                oa2Error = new OA2Error(OA2Errors.SERVER_ERROR, t.getMessage(), state);
            }


            // Finally, if nothing else works, this is treated as a server error
            if (oa2Error == null) {
                oa2Error = new OA2Error(OA2Errors.SERVER_ERROR, "Internal error:" + t.getMessage(), null);
            }
        }
        handleOA2Error(oa2Error, response);

    }

    protected void handleOA2Error(OA2Error oa2Error, HttpServletResponse response) throws IOException {
        // Fixes OAUTH-174, better handling of errors on the server side, making it all spec. compliant.
        if(oa2Error.getCallback() == null){
            // Except here, since there is no callback possible if it is not included in the first place.
            throw new IllegalStateException("No callback has been specified. Cannot process error.");
        }
        OA2AuthorizationServer.MyHttpServletResponseWrapper wrapper = null;
        if(response instanceof OA2AuthorizationServer.MyHttpServletResponseWrapper){
            wrapper = (OA2AuthorizationServer.MyHttpServletResponseWrapper) response;
            // set this so that other components know a redirect occurred and can handle that themselves (usually by just returning).
            wrapper.setExceptionEncountered(true);
        }
        String cb = oa2Error.getCallback().toString();
        cb = cb + "?" + OA2Constants.ERROR + "=" + oa2Error.getError() + "&" +
                URLEncoder.encode(OA2Constants.ERROR_DESCRIPTION, "UTF-8") + "=" +
                URLEncoder.encode(oa2Error.getDescription(), "UTF-8") + "&" + OA2Constants.STATE + "=" +
                URLEncoder.encode(oa2Error.getState(), "UTF-8");

        response.setStatus(HttpServletResponse.SC_MOVED_PERMANENTLY);
        response.sendRedirect(cb);
        return;
    }
}
